/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.annotations.NotNull;

class ClsPackageStatementImpl
extends ClsElementImpl
implements PsiPackageStatement {
    private final ClsFileImpl myFile;
    private final String myPackageName;

    public ClsPackageStatementImpl(@NotNull ClsFileImpl file2) {
        int index;
        String className;
        this.myFile = file2;
        String packageName = null;
        PsiClass[] psiClasses = file2.getClasses();
        if (psiClasses.length > 0 && (className = psiClasses[0].getQualifiedName()) != null && (index = className.lastIndexOf(46)) >= 0) {
            packageName = className.substring(0, index);
        }
        this.myPackageName = packageName;
    }

    public PsiElement getParent() {
        return this.myFile;
    }

    public PsiJavaCodeReferenceElement getPackageReference() {
        throw new UnsupportedOperationException("Method not implemented");
    }

    public PsiModifierList getAnnotationList() {
        throw new UnsupportedOperationException("Method not implemented");
    }

    @NotNull
    public PsiElement[] getChildren() {
        throw new UnsupportedOperationException("Method not implemented");
    }

    public String getPackageName() {
        return this.myPackageName;
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        if (this.myPackageName != null) {
            buffer.append("package ").append(this.getPackageName()).append(";");
        }
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        this.setMirrorCheckingType(element, JavaElementType.PACKAGE_STATEMENT);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitPackageStatement((PsiPackageStatement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiPackageStatement:" + this.getPackageName();
    }
}

