/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsIdentifierImpl;
import com.intellij.psi.impl.compiled.ClsParsingUtil;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ClsNameValuePairImpl
extends ClsElementImpl
implements PsiNameValuePair {
    private final ClsElementImpl myParent;
    private final ClsIdentifierImpl myNameIdentifier;
    private final PsiAnnotationMemberValue myMemberValue;

    ClsNameValuePairImpl(@NotNull ClsElementImpl parent, @Nullable String name, @NotNull PsiAnnotationMemberValue value) {
        this.myParent = parent;
        this.myNameIdentifier = name != null ? new ClsIdentifierImpl((PsiElement)this, name) : null;
        this.myMemberValue = ClsParsingUtil.getMemberValue((PsiElement)value, this);
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        ClsNameValuePairImpl.appendText((PsiElement)this.myNameIdentifier, 0, buffer, " = ");
        ClsNameValuePairImpl.appendText((PsiElement)this.myMemberValue, 0, buffer);
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        this.setMirrorCheckingType(element, null);
        PsiNameValuePair mirror = (PsiNameValuePair)SourceTreeToPsiMap.treeToPsiNotNull(element);
        ClsNameValuePairImpl.setMirrorIfPresent(this.getNameIdentifier(), mirror.getNameIdentifier());
        ClsNameValuePairImpl.setMirrorIfPresent(this.getValue(), mirror.getValue());
    }

    @NotNull
    public PsiElement[] getChildren() {
        if (this.myNameIdentifier != null) {
            return new PsiElement[]{this.myNameIdentifier, this.myMemberValue};
        }
        return new PsiElement[]{this.myMemberValue};
    }

    public PsiElement getParent() {
        return this.myParent;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitNameValuePair((PsiNameValuePair)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public PsiIdentifier getNameIdentifier() {
        return this.myNameIdentifier;
    }

    @Override
    public String getName() {
        return this.myNameIdentifier != null ? this.myNameIdentifier.getText() : null;
    }

    public String getLiteralValue() {
        return null;
    }

    public PsiAnnotationMemberValue getValue() {
        return this.myMemberValue;
    }

    @NotNull
    public PsiAnnotationMemberValue setValue(@NotNull PsiAnnotationMemberValue newValue) {
        throw ClsNameValuePairImpl.cannotModifyException(this);
    }
}

