/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DefaultProjectFactory;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.ClassFileViewProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwnerEx;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.compiled.ClassFileDecompilers;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.JavaPsiImplementationHelper;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.impl.compiled.ClsCustomNavigationPolicy;
import com.intellij.psi.impl.compiled.ClsCustomNavigationPolicyEx;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsPackageStatementImpl;
import com.intellij.psi.impl.compiled.ClsRepositoryPsiElement;
import com.intellij.psi.impl.compiled.InnerClassSourceStrategy;
import com.intellij.psi.impl.compiled.OutOfOrderInnerClassException;
import com.intellij.psi.impl.compiled.StubBuildingVisitor;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.impl.java.stubs.impl.PsiJavaFileStubImpl;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.stubs.PsiClassHolderFileStub;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.stubs.StubTreeLoader;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.cls.ClsFormatException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.Attribute;
import org.jetbrains.org.objectweb.asm.ClassReader;

public class ClsFileImpl
extends ClsRepositoryPsiElement<PsiClassHolderFileStub>
implements PsiJavaFile,
PsiFileWithStubSupport,
PsiFileEx,
Queryable,
PsiClassOwnerEx,
PsiCompiledFile {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.compiled.ClsFileImpl");
    private static final String BANNER = "\n  // IntelliJ API Decompiler stub source generated from a class file\n  // Implementation of methods is not available\n\n";
    private static final Key<Document> CLS_DOCUMENT_LINK_KEY = Key.create((String)"cls.document.link");
    private final Object myMirrorLock = new Object();
    private final Object myStubLock = new Object();
    private final FileViewProvider myViewProvider;
    private final boolean myIsForDecompiling;
    private volatile SoftReference<StubTree> myStub;
    private volatile TreeElement myMirrorFileElement;
    private volatile ClsPackageStatementImpl myPackageStatement;
    private volatile LanguageLevel myLanguageLevel;
    private boolean myIsPhysical = true;
    private boolean myInvalidated;
    private static final InnerClassSourceStrategy<VirtualFile> STRATEGY = new InnerClassSourceStrategy<VirtualFile>(){

        @Override
        @Nullable
        public VirtualFile findInnerClass(String innerName, VirtualFile outerClass) {
            String baseName = outerClass.getNameWithoutExtension();
            VirtualFile dir = outerClass.getParent();
            assert (dir != null) : outerClass;
            return dir.findChild(baseName + '$' + innerName + ".class");
        }

        @Override
        public void accept(VirtualFile innerClass, StubBuildingVisitor<VirtualFile> visitor) {
            try {
                byte[] bytes = innerClass.contentsToByteArray(false);
                new ClassReader(bytes).accept(visitor, EMPTY_ATTRIBUTES, 4);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    };
    public static final Attribute[] EMPTY_ATTRIBUTES = new Attribute[0];

    public ClsFileImpl(@NotNull FileViewProvider viewProvider) {
        this(viewProvider, false);
    }

    private ClsFileImpl(@NotNull FileViewProvider viewProvider, boolean forDecompiling) {
        super(null);
        this.myViewProvider = viewProvider;
        this.myIsForDecompiling = forDecompiling;
        JavaElementType.CLASS.getIndex();
    }

    @Override
    public PsiManager getManager() {
        return this.myViewProvider.getManager();
    }

    @NotNull
    public VirtualFile getVirtualFile() {
        return this.myViewProvider.getVirtualFile();
    }

    public boolean processChildren(PsiElementProcessor<PsiFileSystemItem> processor2) {
        return true;
    }

    public PsiDirectory getParent() {
        return this.getContainingDirectory();
    }

    public PsiDirectory getContainingDirectory() {
        VirtualFile parentFile = this.getVirtualFile().getParent();
        if (parentFile == null) {
            return null;
        }
        return this.getManager().findDirectory(parentFile);
    }

    @Override
    public PsiFile getContainingFile() {
        if (!this.isValid()) {
            throw new PsiInvalidElementAccessException((PsiElement)this);
        }
        return this;
    }

    @Override
    public boolean isValid() {
        return !this.myInvalidated && (this.myIsForDecompiling || this.getVirtualFile().isValid());
    }

    boolean isForDecompiling() {
        return this.myIsForDecompiling;
    }

    @Override
    @NotNull
    public String getName() {
        return this.getVirtualFile().getName();
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        return this.getClasses();
    }

    @NotNull
    public PsiClass[] getClasses() {
        return this.getStub().getClasses();
    }

    public PsiPackageStatement getPackageStatement() {
        this.getStub();
        ClsPackageStatementImpl statement2 = this.myPackageStatement;
        if (statement2 == null) {
            statement2 = new ClsPackageStatementImpl(this);
        }
        return statement2.getPackageName() != null ? statement2 : null;
    }

    @NotNull
    public String getPackageName() {
        PsiPackageStatement statement2 = this.getPackageStatement();
        return statement2 == null ? "" : statement2.getPackageName();
    }

    public void setPackageName(String packageName) throws IncorrectOperationException {
        throw new IncorrectOperationException("Cannot set package name for compiled files");
    }

    public PsiImportList getImportList() {
        return null;
    }

    public boolean importClass(PsiClass aClass) {
        throw new UnsupportedOperationException("Cannot add imports to compiled classes");
    }

    @NotNull
    public PsiElement[] getOnDemandImports(boolean includeImplicit, boolean checkIncludes) {
        return PsiJavaCodeReferenceElement.EMPTY_ARRAY;
    }

    @NotNull
    public PsiClass[] getSingleClassImports(boolean checkIncludes) {
        return PsiClass.EMPTY_ARRAY;
    }

    @NotNull
    public String[] getImplicitlyImportedPackages() {
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public Set<String> getClassNames() {
        return Collections.singleton(this.getVirtualFile().getNameWithoutExtension());
    }

    @NotNull
    public PsiJavaCodeReferenceElement[] getImplicitlyImportedPackageReferences() {
        return PsiJavaCodeReferenceElement.EMPTY_ARRAY;
    }

    public PsiJavaCodeReferenceElement findImportReferenceTo(PsiClass aClass) {
        return null;
    }

    @NotNull
    public LanguageLevel getLanguageLevel() {
        LanguageLevel level = this.myLanguageLevel;
        if (level == null) {
            List classes = (List)ApplicationManager.getApplication().runReadAction((Computable)new Computable<List>(){

                public List compute() {
                    return ClsFileImpl.this.getStub().getChildrenStubs();
                }
            });
            level = !classes.isEmpty() ? ((PsiClassStub)classes.get(0)).getLanguageLevel() : LanguageLevel.HIGHEST;
            this.myLanguageLevel = level;
        }
        return level;
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        throw ClsFileImpl.cannotModifyException(this);
    }

    public void checkSetName(String name) throws IncorrectOperationException {
        throw ClsFileImpl.cannotModifyException(this);
    }

    public boolean isDirectory() {
        return false;
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        buffer.append(BANNER);
        ClsFileImpl.appendText((PsiElement)this.getPackageStatement(), 0, buffer, "\n\n");
        PsiClass[] classes = this.getClasses();
        if (classes.length > 0) {
            ClsFileImpl.appendText((PsiElement)classes[0], 0, buffer);
        }
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        Object mirrorElement = SourceTreeToPsiMap.treeToPsiNotNull(element);
        if (!(mirrorElement instanceof PsiJavaFile)) {
            throw new ClsElementImpl.InvalidMirrorException("Unexpected mirror file: " + mirrorElement);
        }
        PsiJavaFile mirrorFile = (PsiJavaFile)mirrorElement;
        ClsFileImpl.setMirrorIfPresent(this.getPackageStatement(), mirrorFile.getPackageStatement());
        ClsFileImpl.setMirrors((PsiElement[])this.getClasses(), (PsiElement[])mirrorFile.getClasses());
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        for (ClsCustomNavigationPolicy customNavigationPolicy : (ClsCustomNavigationPolicy[])Extensions.getExtensions(ClsCustomNavigationPolicy.EP_NAME)) {
            if (!(customNavigationPolicy instanceof ClsCustomNavigationPolicyEx)) continue;
            try {
                PsiFile navigationElement = ((ClsCustomNavigationPolicyEx)customNavigationPolicy).getFileNavigationElement(this);
                if (navigationElement == null) continue;
                return navigationElement;
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
        }
        return (PsiElement)CachedValuesManager.getCachedValue((PsiElement)this, (CachedValueProvider)new CachedValueProvider<PsiElement>(){

            @Nullable
            public CachedValueProvider.Result<PsiElement> compute() {
                PsiElement target = JavaPsiImplementationHelper.getInstance(ClsFileImpl.this.getProject()).getClsFileNavigationElement(ClsFileImpl.this);
                ModificationTracker tracker = FileIndexFacade.getInstance((Project)ClsFileImpl.this.getProject()).getRootModificationTracker();
                return CachedValueProvider.Result.create((Object)target, (Object[])new Object[]{ClsFileImpl.this, target.getContainingFile(), tracker});
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PsiElement getMirror() {
        TreeElement mirrorTreeElement = this.myMirrorFileElement;
        if (mirrorTreeElement == null) {
            Object object = this.myMirrorLock;
            synchronized (object) {
                mirrorTreeElement = this.myMirrorFileElement;
                if (mirrorTreeElement == null) {
                    VirtualFile file2 = this.getVirtualFile();
                    PsiClass[] classes = this.getClasses();
                    String fileName = (classes.length > 0 ? classes[0].getName() : file2.getNameWithoutExtension()) + ".java";
                    final Document document = FileDocumentManager.getInstance().getDocument(file2);
                    assert (document != null) : file2.getUrl();
                    CharSequence mirrorText = document.getImmutableCharSequence();
                    boolean internalDecompiler = StringUtil.startsWith((CharSequence)mirrorText, (CharSequence)BANNER);
                    PsiFileFactory factory = PsiFileFactory.getInstance((Project)this.getManager().getProject());
                    PsiFile mirror = factory.createFileFromText(fileName, (Language)JavaLanguage.INSTANCE, mirrorText, false, false);
                    mirror.putUserData(PsiUtil.FILE_LANGUAGE_LEVEL_KEY, (Object)this.getLanguageLevel());
                    mirrorTreeElement = SourceTreeToPsiMap.psiToTreeNotNull((PsiElement)mirror);
                    try {
                        final TreeElement finalMirrorTreeElement = mirrorTreeElement;
                        ProgressManager.getInstance().executeNonCancelableSection(new Runnable(){

                            @Override
                            public void run() {
                                ClsFileImpl.this.setMirror(finalMirrorTreeElement);
                                ClsFileImpl.this.putUserData(CLS_DOCUMENT_LINK_KEY, document);
                            }
                        });
                    }
                    catch (ClsElementImpl.InvalidMirrorException e) {
                        LOG.error(file2.getUrl(), (Throwable)(internalDecompiler ? e : ClsFileImpl.wrapException(e, file2)));
                    }
                    ((PsiFileImpl)mirror).setOriginalFile(this);
                    this.myMirrorFileElement = mirrorTreeElement;
                }
            }
        }
        return mirrorTreeElement.getPsi();
    }

    @Override
    public String getText() {
        VirtualFile file2 = this.getVirtualFile();
        Document document = FileDocumentManager.getInstance().getDocument(file2);
        assert (document != null) : file2.getUrl();
        return document.getText();
    }

    @Override
    public int getTextLength() {
        VirtualFile file2 = this.getVirtualFile();
        Document document = FileDocumentManager.getInstance().getDocument(file2);
        assert (document != null) : file2.getUrl();
        return document.getTextLength();
    }

    private static Exception wrapException(ClsElementImpl.InvalidMirrorException e, VirtualFile file2) {
        PluginId pluginId;
        ClassFileDecompilers.Decompiler decompiler = ClassFileDecompilers.find((VirtualFile)file2);
        if (decompiler instanceof ClassFileDecompilers.Light && (pluginId = PluginManagerCore.getPluginByClassName(decompiler.getClass().getName())) != null) {
            return new PluginException((Throwable)e, pluginId);
        }
        return e;
    }

    public PsiFile getDecompiledPsiFile() {
        return (PsiFile)this.getMirror();
    }

    public long getModificationStamp() {
        return this.getVirtualFile().getModificationStamp();
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitJavaFile((PsiJavaFile)this);
        } else {
            visitor.visitFile((PsiFile)this);
        }
    }

    @NonNls
    public String toString() {
        return "PsiFile:" + this.getName();
    }

    @NotNull
    public PsiFile getOriginalFile() {
        return this;
    }

    @NotNull
    public FileType getFileType() {
        return JavaClassFileType.INSTANCE;
    }

    @NotNull
    public PsiFile[] getPsiRoots() {
        return new PsiFile[]{this};
    }

    @NotNull
    public FileViewProvider getViewProvider() {
        return this.myViewProvider;
    }

    public void subtreeChanged() {
    }

    @Override
    public PsiElement getContext() {
        return FileContextUtil.getFileContext(this);
    }

    @Override
    @NotNull
    public PsiClassHolderFileStub<?> getStub() {
        return (PsiClassHolderFileStub)this.getStubTree().getRoot();
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        processor2.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)this);
        ElementClassHint classHint = (ElementClassHint)processor2.getHint(ElementClassHint.KEY);
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) {
            PsiClass[] classes;
            for (PsiClass aClass : classes = this.getClasses()) {
                if (processor2.execute((PsiElement)aClass, state)) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public StubTree getStubTree() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        StubTree stubTree = (StubTree)SoftReference.dereference(this.myStub);
        if (stubTree != null) {
            return stubTree;
        }
        StubTree newStubTree = (StubTree)StubTreeLoader.getInstance().readOrBuild(this.getProject(), this.getVirtualFile(), this);
        if (newStubTree == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No stub for class file in index: " + this.getVirtualFile().getPresentableUrl());
            }
            newStubTree = new StubTree(new PsiJavaFileStubImpl("corrupted_class_files", true));
        }
        Object object = this.myStubLock;
        synchronized (object) {
            stubTree = (StubTree)SoftReference.dereference(this.myStub);
            if (stubTree != null) {
                return stubTree;
            }
            stubTree = newStubTree;
            PsiFileStubImpl fileStub = (PsiFileStubImpl)stubTree.getRoot();
            fileStub.setPsi(this);
            this.myStub = new SoftReference((Object)stubTree);
        }
        return stubTree;
    }

    @Override
    public ASTNode findTreeForStub(StubTree tree, StubElement<?> stub) {
        return null;
    }

    @Override
    public boolean isContentsLoaded() {
        return this.myStub != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onContentReload() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        Object object = this.myStubLock;
        synchronized (object) {
            StubTree stubTree = (StubTree)SoftReference.dereference(this.myStub);
            this.myStub = null;
            if (stubTree != null) {
                ((PsiFileStubImpl)stubTree.getRoot()).clearPsi("cls onContentReload");
            }
        }
        ClsPackageStatementImpl packageStatement = new ClsPackageStatementImpl(this);
        Object object2 = this.myMirrorLock;
        synchronized (object2) {
            this.putUserData(CLS_DOCUMENT_LINK_KEY, null);
            this.myMirrorFileElement = null;
            this.myPackageStatement = packageStatement;
        }
        this.myLanguageLevel = null;
    }

    @Override
    public void markInvalidated() {
        this.myInvalidated = true;
        DebugUtil.onInvalidated(this);
    }

    public void putInfo(@NotNull Map<String, String> info) {
        PsiFileImpl.putInfo(this, info);
    }

    public FileASTNode getNode() {
        return null;
    }

    @Override
    public boolean isPhysical() {
        return this.myIsPhysical;
    }

    public void setPhysical(boolean isPhysical) {
        this.myIsPhysical = isPhysical;
    }

    @NotNull
    public static CharSequence decompile(@NotNull VirtualFile file2) {
        PsiManager manager = PsiManager.getInstance((Project)DefaultProjectFactory.getInstance().getDefaultProject());
        final ClsFileImpl clsFile = new ClsFileImpl(new ClassFileViewProvider(manager, file2), true);
        final StringBuilder buffer = new StringBuilder();
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                clsFile.appendMirrorText(0, buffer);
            }
        });
        return buffer;
    }

    @Nullable
    public static PsiJavaFileStub buildFileStub(@NotNull VirtualFile file2, @NotNull byte[] bytes) throws ClsFormatException {
        try {
            if (ClassFileViewProvider.isInnerClass(file2, bytes)) {
                return null;
            }
            ClassReader reader = new ClassReader(bytes);
            String className = file2.getNameWithoutExtension();
            String packageName = ClsFileImpl.getPackageName(reader.getClassName());
            PsiJavaFileStubImpl stub = new PsiJavaFileStubImpl(packageName, true);
            try {
                StubBuildingVisitor<VirtualFile> visitor = new StubBuildingVisitor<VirtualFile>(file2, STRATEGY, (StubElement)stub, 0, className);
                reader.accept(visitor, EMPTY_ATTRIBUTES, 4);
                PsiClassStub<?> result = visitor.getResult();
                if (result == null) {
                    return null;
                }
            }
            catch (OutOfOrderInnerClassException e) {
                return null;
            }
            return stub;
        }
        catch (Exception e) {
            throw new ClsFormatException(file2.getPath() + ": " + e.getMessage(), (Throwable)e);
        }
    }

    private static String getPackageName(String internalName) {
        int p = internalName.lastIndexOf(47);
        return p > 0 ? internalName.substring(0, p).replace('/', '.') : "";
    }
}

