/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.core.JavaCoreBundle;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.codeStyle.JavaCodeStyleSettingsFacade;
import com.intellij.psi.impl.PsiElementBase;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ClsElementImpl
extends PsiElementBase
implements PsiCompiledElement {
    public static final Key<PsiCompiledElement> COMPILED_ELEMENT = Key.create((String)"COMPILED_ELEMENT");
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.compiled.ClsElementImpl");
    private volatile TreeElement myMirror;
    protected static final String NEXT_LINE = "go_to_next_line_and_indent";

    @NotNull
    public Language getLanguage() {
        return JavaLanguage.INSTANCE;
    }

    @Override
    public PsiManager getManager() {
        return this.getParent().getManager();
    }

    @Override
    public PsiFile getContainingFile() {
        PsiElement parent = this.getParent();
        if (parent == null) {
            throw new PsiInvalidElementAccessException((PsiElement)this);
        }
        return parent.getContainingFile();
    }

    @Override
    public final boolean isWritable() {
        return false;
    }

    @Override
    public boolean isPhysical() {
        return true;
    }

    @Override
    public boolean isValid() {
        PsiElement parent = this.getParent();
        return parent != null && parent.isValid();
    }

    @Override
    public PsiElement copy() {
        return this;
    }

    @NotNull
    protected PsiElement[] getChildren(PsiElement ... children2) {
        if (children2 == null) {
            return PsiElement.EMPTY_ARRAY;
        }
        ArrayList list = ContainerUtil.newArrayListWithCapacity((int)children2.length);
        for (PsiElement child : children2) {
            if (child == null) continue;
            list.add(child);
        }
        return PsiUtilCore.toPsiElementArray((Collection)list);
    }

    @Override
    public void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        throw ClsElementImpl.cannotModifyException(this);
    }

    @NotNull
    static IncorrectOperationException cannotModifyException(@NotNull ClsElementImpl element) {
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element);
        String path = virtualFile == null ? "?" : virtualFile.getPresentableUrl();
        return new IncorrectOperationException(JavaCoreBundle.message((String)"psi.error.attempt.to.edit.class.file", (Object[])new Object[]{path}));
    }

    @Override
    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        throw ClsElementImpl.cannotModifyException(this);
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        throw ClsElementImpl.cannotModifyException(this);
    }

    @Override
    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        throw ClsElementImpl.cannotModifyException(this);
    }

    @Override
    public void delete() throws IncorrectOperationException {
        throw ClsElementImpl.cannotModifyException(this);
    }

    @Override
    public void checkDelete() throws IncorrectOperationException {
        throw ClsElementImpl.cannotModifyException(this);
    }

    @Override
    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        throw ClsElementImpl.cannotModifyException(this);
    }

    public abstract void appendMirrorText(int var1, @NotNull StringBuilder var2);

    protected int getIndentSize() {
        return JavaCodeStyleSettingsFacade.getInstance((Project)this.getProject()).getIndentSize();
    }

    public abstract void setMirror(@NotNull TreeElement var1) throws InvalidMirrorException;

    public PsiElement getMirror() {
        TreeElement mirror = this.myMirror;
        if (mirror == null) {
            ((ClsFileImpl)this.getContainingFile()).getMirror();
            mirror = this.myMirror;
        }
        return SourceTreeToPsiMap.treeElementToPsi(mirror);
    }

    public final TextRange getTextRange() {
        PsiElement mirror = this.getMirror();
        return mirror != null ? mirror.getTextRange() : TextRange.EMPTY_RANGE;
    }

    public final int getStartOffsetInParent() {
        PsiElement mirror = this.getMirror();
        return mirror != null ? mirror.getStartOffsetInParent() : -1;
    }

    public int getTextLength() {
        String text = this.getText();
        return text == null ? 0 : text.length();
    }

    public PsiElement findElementAt(int offset) {
        PsiElement mirror = this.getMirror();
        if (mirror == null) {
            return null;
        }
        PsiElement mirrorAt = mirror.findElementAt(offset);
        while (mirrorAt != null && !(mirrorAt instanceof PsiFile)) {
            PsiElement elementAt = this.mirrorToElement(mirrorAt);
            if (elementAt != null) {
                return elementAt;
            }
            mirrorAt = mirrorAt.getParent();
        }
        return null;
    }

    @Override
    public PsiReference findReferenceAt(int offset) {
        PsiElement mirror = this.getMirror();
        if (mirror == null) {
            return null;
        }
        PsiReference mirrorRef = mirror.findReferenceAt(offset);
        if (mirrorRef == null) {
            return null;
        }
        PsiElement mirrorElement = mirrorRef.getElement();
        PsiElement element = this.mirrorToElement(mirrorElement);
        if (element == null) {
            return null;
        }
        return element.getReference();
    }

    @Nullable
    private PsiElement mirrorToElement(PsiElement mirror) {
        PsiElement m = this.getMirror();
        if (m == mirror) {
            return this;
        }
        PsiElement[] children2 = this.getChildren();
        if (children2.length == 0) {
            return null;
        }
        for (PsiElement child : children2) {
            PsiElement element;
            ClsElementImpl clsChild = (ClsElementImpl)child;
            if (!PsiTreeUtil.isAncestor((PsiElement)clsChild.getMirror(), (PsiElement)mirror, (boolean)false) || (element = clsChild.mirrorToElement(mirror)) == null) continue;
            return element;
        }
        return null;
    }

    public final int getTextOffset() {
        PsiElement mirror = this.getMirror();
        return mirror != null ? mirror.getTextOffset() : -1;
    }

    public String getText() {
        PsiElement mirror = this.getMirror();
        if (mirror != null) {
            return mirror.getText();
        }
        StringBuilder buffer = new StringBuilder();
        this.appendMirrorText(0, buffer);
        LOG.warn("Mirror wasn't set for " + (Object)((Object)this) + " in " + this.getContainingFile() + ", expected text '" + buffer + "'");
        return buffer.toString();
    }

    @NotNull
    public char[] textToCharArray() {
        PsiElement mirror = this.getMirror();
        return mirror != null ? mirror.textToCharArray() : ArrayUtil.EMPTY_CHAR_ARRAY;
    }

    @Override
    public boolean textMatches(@NotNull CharSequence text) {
        return this.getText().equals(text.toString());
    }

    @Override
    public boolean textMatches(@NotNull PsiElement element) {
        return this.getText().equals(element.getText());
    }

    public ASTNode getNode() {
        return null;
    }

    static void goNextLine(int indentLevel, @NotNull StringBuilder buffer) {
        buffer.append('\n');
        for (int i = 0; i < indentLevel; ++i) {
            buffer.append(' ');
        }
    }

    protected static void appendText(@NotNull PsiElement stub, int indentLevel, @NotNull StringBuilder buffer) {
        ((ClsElementImpl)stub).appendMirrorText(indentLevel, buffer);
    }

    protected static void appendText(@Nullable PsiElement stub, int indentLevel, @NotNull StringBuilder buffer, @NotNull String separator) {
        if (stub == null) {
            return;
        }
        int pos = buffer.length();
        ((ClsElementImpl)stub).appendMirrorText(indentLevel, buffer);
        if (buffer.length() != pos) {
            if (separator == NEXT_LINE) {
                ClsElementImpl.goNextLine(indentLevel, buffer);
            } else {
                buffer.append(separator);
            }
        }
    }

    protected void setMirrorCheckingType(@NotNull TreeElement element, @Nullable IElementType type) throws InvalidMirrorException {
        if (type != null && element.getElementType() != type) {
            throw new InvalidMirrorException(element.getElementType() + " != " + type);
        }
        element.getPsi().putUserData(COMPILED_ELEMENT, (Object)this);
        this.myMirror = element;
    }

    protected static <T extends PsiElement> void setMirror(@Nullable T stub, @Nullable T mirror) throws InvalidMirrorException {
        if (stub == null || mirror == null) {
            throw new InvalidMirrorException(stub, mirror);
        }
        ((ClsElementImpl)stub).setMirror(SourceTreeToPsiMap.psiToTreeNotNull(mirror));
    }

    protected static <T extends PsiElement> void setMirrorIfPresent(@Nullable T stub, @Nullable T mirror) throws InvalidMirrorException {
        if (stub == null != (mirror == null)) {
            throw new InvalidMirrorException(stub, mirror);
        }
        if (stub != null) {
            ((ClsElementImpl)stub).setMirror(SourceTreeToPsiMap.psiToTreeNotNull(mirror));
        }
    }

    protected static <T extends PsiElement> void setMirrors(@NotNull T[] stubs, @NotNull T[] mirrors) throws InvalidMirrorException {
        ClsElementImpl.setMirrors(Arrays.asList(stubs), Arrays.asList(mirrors));
    }

    protected static <T extends PsiElement> void setMirrors(@NotNull List<T> stubs, @NotNull T[] mirrors) throws InvalidMirrorException {
        ClsElementImpl.setMirrors(stubs, Arrays.asList(mirrors));
    }

    protected static <T extends PsiElement> void setMirrors(@NotNull List<T> stubs, @NotNull List<T> mirrors) throws InvalidMirrorException {
        if (stubs.size() != mirrors.size()) {
            throw new InvalidMirrorException(stubs, mirrors);
        }
        for (int i = 0; i < stubs.size(); ++i) {
            ClsElementImpl.setMirror((PsiElement)stubs.get(i), (PsiElement)mirrors.get(i));
        }
    }

    protected static class InvalidMirrorException
    extends RuntimeException {
        public InvalidMirrorException(@NotNull @NonNls String message) {
            super(message);
        }

        public InvalidMirrorException(@Nullable PsiElement stubElement, @Nullable PsiElement mirrorElement) {
            this("stub:" + stubElement + "; mirror:" + mirrorElement);
        }

        public InvalidMirrorException(@NotNull PsiElement[] stubElements, @NotNull PsiElement[] mirrorElements) {
            this("stub:" + Arrays.toString(stubElements) + "; mirror:" + Arrays.toString(mirrorElements));
        }

        public InvalidMirrorException(@NotNull List<? extends PsiElement> stubElements, @NotNull List<? extends PsiElement> mirrorElements) {
            this("stub:" + stubElements + "; mirror:" + mirrorElements);
        }
    }
}

