/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.BinaryFileDecompiler;
import com.intellij.openapi.project.DefaultProjectFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.compiled.ClassFileDecompilers;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import org.jetbrains.annotations.NotNull;

public class ClassFileDecompiler
implements BinaryFileDecompiler {
    private static final Logger LOG = Logger.getInstance(ClassFileDecompiler.class);

    @NotNull
    public CharSequence decompile(@NotNull VirtualFile file2) {
        ClassFileDecompilers.Decompiler decompiler = ClassFileDecompilers.find((VirtualFile)file2);
        if (decompiler instanceof ClassFileDecompilers.Full) {
            PsiManager manager = PsiManager.getInstance((Project)DefaultProjectFactory.getInstance().getDefaultProject());
            return ((ClassFileDecompilers.Full)decompiler).createFileViewProvider(file2, manager, true).getContents();
        }
        if (decompiler instanceof ClassFileDecompilers.Light) {
            try {
                return ((ClassFileDecompilers.Light)decompiler).getText(file2);
            }
            catch (ClassFileDecompilers.Light.CannotDecompileException e) {
                LOG.warn("decompiler: " + decompiler.getClass(), (Throwable)e);
            }
        }
        return ClsFileImpl.decompile(file2);
    }
}

