/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl.id;

import com.intellij.lang.cacheBuilder.CacheBuilderRegistry;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.impl.CustomSyntaxTableFileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.cache.impl.id.FileTypeIdIndexer;
import com.intellij.psi.impl.cache.impl.id.IdIndexEntry;
import com.intellij.psi.impl.cache.impl.id.IdTableBuilding;
import com.intellij.util.SystemProperties;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.InlineKeyDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class IdIndex
extends FileBasedIndexExtension<IdIndexEntry, Integer> {
    @NonNls
    public static final ID<IdIndexEntry, Integer> NAME = ID.create((String)"IdIndex");
    private final FileBasedIndex.InputFilter myInputFilter = new FileBasedIndex.InputFilter(){

        public boolean acceptInput(@NotNull VirtualFile file2) {
            return IdIndex.isIndexable(file2.getFileType());
        }
    };
    public static final boolean ourSnapshotMappingsEnabled = SystemProperties.getBooleanProperty((String)"idea.index.snapshot.mappings.enabled", (boolean)true);
    private final DataExternalizer<Integer> myValueExternalizer = new DataExternalizer<Integer>(){

        public void save(@NotNull DataOutput out, Integer value) throws IOException {
            out.write((int)(value & 0xFF));
        }

        public Integer read(@NotNull DataInput in) throws IOException {
            return in.readByte() & 0xFF;
        }
    };
    private final KeyDescriptor<IdIndexEntry> myKeyDescriptor = new InlineKeyDescriptor<IdIndexEntry>(){

        public IdIndexEntry fromInt(int n) {
            return new IdIndexEntry(n);
        }

        public int toInt(IdIndexEntry idIndexEntry) {
            return idIndexEntry.getWordHashCode();
        }
    };
    private final DataIndexer<IdIndexEntry, Integer, FileContent> myIndexer = new DataIndexer<IdIndexEntry, Integer, FileContent>(){

        @NotNull
        public Map<IdIndexEntry, Integer> map(@NotNull FileContent inputData) {
            FileTypeIdIndexer indexer = IdTableBuilding.getFileTypeIndexer(inputData.getFileType());
            if (indexer != null) {
                return indexer.map(inputData);
            }
            return Collections.emptyMap();
        }
    };

    public int getVersion() {
        return 16 + (ourSnapshotMappingsEnabled ? 255 : 0);
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    @NotNull
    public ID<IdIndexEntry, Integer> getName() {
        return NAME;
    }

    @NotNull
    public DataIndexer<IdIndexEntry, Integer, FileContent> getIndexer() {
        return this.myIndexer;
    }

    @NotNull
    public DataExternalizer<Integer> getValueExternalizer() {
        return this.myValueExternalizer;
    }

    @NotNull
    public KeyDescriptor<IdIndexEntry> getKeyDescriptor() {
        return this.myKeyDescriptor;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return this.myInputFilter;
    }

    public static boolean isIndexable(FileType fileType) {
        return fileType instanceof LanguageFileType || fileType instanceof CustomSyntaxTableFileType || IdTableBuilding.isIdIndexerRegistered(fileType) || CacheBuilderRegistry.getInstance().getCacheBuilder(fileType) != null;
    }

    public boolean hasSnapshotMapping() {
        return true;
    }
}

