/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.impl.cache.impl.id.IdIndex;
import com.intellij.psi.impl.cache.impl.id.IdIndexEntry;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class IndexCacheManagerImpl
implements CacheManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.cache.impl.IndexCacheManagerImpl");
    private final Project myProject;
    private final PsiManager myPsiManager;

    public IndexCacheManagerImpl(PsiManager psiManager) {
        this.myPsiManager = psiManager;
        this.myProject = psiManager.getProject();
    }

    @Override
    @NotNull
    public PsiFile[] getFilesWithWord(@NotNull String word, short occurenceMask, @NotNull GlobalSearchScope scope, boolean caseSensitively) {
        if (this.myProject.isDefault()) {
            return PsiFile.EMPTY_ARRAY;
        }
        CommonProcessors.CollectProcessor processor2 = new CommonProcessors.CollectProcessor();
        this.processFilesWithWord((Processor<PsiFile>)processor2, word, occurenceMask, scope, caseSensitively);
        return processor2.getResults().isEmpty() ? PsiFile.EMPTY_ARRAY : (PsiFile[])processor2.toArray((Object[])PsiFile.EMPTY_ARRAY);
    }

    @Override
    @NotNull
    public VirtualFile[] getVirtualFilesWithWord(@NotNull String word, short occurenceMask, @NotNull GlobalSearchScope scope, boolean caseSensitively) {
        if (this.myProject.isDefault()) {
            return VirtualFile.EMPTY_ARRAY;
        }
        ArrayList vFiles = new ArrayList(5);
        this.collectVirtualFilesWithWord((Processor<VirtualFile>)new CommonProcessors.CollectProcessor(vFiles), word, occurenceMask, scope, caseSensitively);
        return vFiles.isEmpty() ? VirtualFile.EMPTY_ARRAY : vFiles.toArray(new VirtualFile[vFiles.size()]);
    }

    private boolean collectVirtualFilesWithWord(final @NotNull Processor<VirtualFile> fileProcessor, final @NotNull String word, final short occurrenceMask, final @NotNull GlobalSearchScope scope, final boolean caseSensitively) {
        if (this.myProject.isDefault()) {
            return true;
        }
        try {
            return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                public Boolean compute() {
                    return FileBasedIndex.getInstance().processValues(IdIndex.NAME, (Object)new IdIndexEntry(word, caseSensitively), null, (FileBasedIndex.ValueProcessor)new FileBasedIndex.ValueProcessor<Integer>(){
                        final FileIndexFacade index;
                        {
                            this.index = FileIndexFacade.getInstance((Project)IndexCacheManagerImpl.this.myProject);
                        }

                        public boolean process(VirtualFile file2, Integer value) {
                            ProgressIndicatorProvider.checkCanceled();
                            int mask = value;
                            return (mask & occurrenceMask) == 0 || !this.index.shouldBeFound(scope, file2) || fileProcessor.process((Object)file2);
                        }
                    }, scope);
                }
            });
        }
        catch (IndexNotReadyException e) {
            throw new ProcessCanceledException();
        }
    }

    @Override
    public boolean processFilesWithWord(final @NotNull Processor<PsiFile> psiFileProcessor, @NotNull String word, short occurrenceMask, @NotNull GlobalSearchScope scope, boolean caseSensitively) {
        ArrayList vFiles = new ArrayList(5);
        this.collectVirtualFilesWithWord((Processor<VirtualFile>)new CommonProcessors.CollectProcessor(vFiles), word, occurrenceMask, scope, caseSensitively);
        if (vFiles.isEmpty()) {
            return true;
        }
        ReadActionProcessor<VirtualFile> virtualFileProcessor = new ReadActionProcessor<VirtualFile>(){

            public boolean processInReadAction(VirtualFile virtualFile) {
                if (virtualFile.isValid()) {
                    PsiFile psiFile = IndexCacheManagerImpl.this.myPsiManager.findFile(virtualFile);
                    return psiFile == null || psiFileProcessor.process((Object)psiFile);
                }
                return true;
            }
        };
        for (VirtualFile vFile : vFiles) {
            ProgressIndicatorProvider.checkCanceled();
            if (virtualFileProcessor.process((Object)vFile)) continue;
            return false;
        }
        return true;
    }
}

