/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpressionType;
import com.intellij.psi.PsiLambdaParameterType;
import com.intellij.psi.PsiMethodReferenceType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeMapper;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TypeCorrector
extends PsiTypeMapper {
    private final Map<PsiClassType, PsiClassType> myResultMap = ContainerUtil.newIdentityHashMap();
    private final GlobalSearchScope myResolveScope;

    TypeCorrector(GlobalSearchScope resolveScope) {
        this.myResolveScope = resolveScope;
    }

    @Override
    public PsiType visitType(PsiType type) {
        if (type instanceof PsiLambdaParameterType || type instanceof PsiLambdaExpressionType || type instanceof PsiMethodReferenceType) {
            return type;
        }
        return super.visitType(type);
    }

    @Nullable
    public <T extends PsiType> T correctType(@NotNull T type) {
        PsiClass mappedClass;
        PsiClassType.ClassResolveResult classResolveResult;
        PsiClass psiClass;
        PsiClassType classType;
        if (type instanceof PsiClassType && (classType = (PsiClassType)type).getParameterCount() == 0 && (psiClass = (classResolveResult = classType.resolveGenerics()).getElement()) != null && classResolveResult.getSubstitutor() == PsiSubstitutor.EMPTY && ((mappedClass = this.mapClass(psiClass)) == null || mappedClass == psiClass)) {
            return (T)classType;
        }
        return (T)((PsiType)type.accept((PsiTypeVisitor)this));
    }

    @Override
    public PsiType visitClassType(PsiClassType classType) {
        PsiClassType alreadyComputed = this.myResultMap.get(classType);
        if (alreadyComputed != null) {
            return alreadyComputed;
        }
        PsiClassType.ClassResolveResult classResolveResult = classType.resolveGenerics();
        PsiClass psiClass = classResolveResult.getElement();
        PsiSubstitutor substitutor = classResolveResult.getSubstitutor();
        if (psiClass == null) {
            return classType;
        }
        PsiUtilCore.ensureValid((PsiElement)psiClass);
        PsiClass mappedClass = this.mapClass(psiClass);
        if (mappedClass == null) {
            return classType;
        }
        PsiCorrectedClassType mappedType = new PsiCorrectedClassType(classType.getLanguageLevel(), classType, new CorrectedResolveResult(psiClass, mappedClass, substitutor, classResolveResult));
        this.myResultMap.put(classType, (PsiClassType)mappedType);
        return mappedType;
    }

    @Nullable
    private PsiClass mapClass(@NotNull PsiClass psiClass) {
        String qualifiedName = psiClass.getQualifiedName();
        if (qualifiedName == null) {
            return psiClass;
        }
        PsiFile file2 = psiClass.getContainingFile();
        if (file2 == null || !file2.getViewProvider().isPhysical()) {
            return psiClass;
        }
        VirtualFile vFile = file2.getVirtualFile();
        if (vFile == null) {
            return psiClass;
        }
        FileIndexFacade index = FileIndexFacade.getInstance((Project)file2.getProject());
        if (!(index.isInSource(vFile) || index.isInLibrarySource(vFile) || index.isInLibraryClasses(vFile))) {
            return psiClass;
        }
        return JavaPsiFacade.getInstance((Project)psiClass.getProject()).findClass(qualifiedName, this.myResolveScope);
    }

    @NotNull
    private PsiSubstitutor mapSubstitutor(PsiClass originalClass, PsiClass mappedClass, PsiSubstitutor substitutor) {
        PsiClass originalContaining;
        PsiTypeParameter[] originalTypeParameters;
        PsiTypeParameter[] typeParameters = mappedClass.getTypeParameters();
        if (typeParameters.length != (originalTypeParameters = originalClass.getTypeParameters()).length) {
            if (originalTypeParameters.length == 0) {
                return JavaPsiFacade.getElementFactory((Project)mappedClass.getProject()).createRawSubstitutor((PsiTypeParameterListOwner)mappedClass);
            }
            return substitutor;
        }
        Map substitutionMap = substitutor.getSubstitutionMap();
        PsiSubstitutor mappedSubstitutor = PsiSubstitutor.EMPTY;
        for (int i = 0; i < originalTypeParameters.length; ++i) {
            if (!substitutionMap.containsKey(originalTypeParameters[i])) continue;
            PsiType originalSubstitute = substitutor.substitute(originalTypeParameters[i]);
            if (originalSubstitute != null) {
                PsiType substitute = this.mapType(originalSubstitute);
                if (substitute == null) {
                    return substitutor;
                }
                mappedSubstitutor = mappedSubstitutor.put(typeParameters[i], substitute);
                continue;
            }
            mappedSubstitutor = mappedSubstitutor.put(typeParameters[i], null);
        }
        if (mappedClass.hasModifierProperty("static")) {
            return mappedSubstitutor;
        }
        PsiClass mappedContaining = mappedClass.getContainingClass();
        if (mappedContaining != null != ((originalContaining = originalClass.getContainingClass()) != null)) {
            return substitutor;
        }
        if (mappedContaining != null) {
            return mappedSubstitutor.putAll(this.mapSubstitutor(originalContaining, mappedContaining, substitutor));
        }
        return mappedSubstitutor;
    }

    private class CorrectedResolveResult
    implements PsiClassType.ClassResolveResult {
        private final PsiClass myPsiClass;
        private final PsiClass myMappedClass;
        private final PsiSubstitutor mySubstitutor;
        private final PsiClassType.ClassResolveResult myClassResolveResult;
        private volatile PsiSubstitutor myLazySubstitutor;

        public CorrectedResolveResult(PsiClass psiClass, PsiClass mappedClass, PsiSubstitutor substitutor, PsiClassType.ClassResolveResult classResolveResult) {
            this.myPsiClass = psiClass;
            this.myMappedClass = mappedClass;
            this.mySubstitutor = substitutor;
            this.myClassResolveResult = classResolveResult;
        }

        @NotNull
        public PsiSubstitutor getSubstitutor() {
            PsiSubstitutor result = this.myLazySubstitutor;
            if (result == null) {
                this.myLazySubstitutor = result = TypeCorrector.this.mapSubstitutor(this.myPsiClass, this.myMappedClass, this.mySubstitutor);
            }
            return result;
        }

        public PsiClass getElement() {
            return this.myMappedClass;
        }

        public boolean isPackagePrefixPackageReference() {
            return this.myClassResolveResult.isPackagePrefixPackageReference();
        }

        public boolean isAccessible() {
            return this.myClassResolveResult.isAccessible();
        }

        public boolean isStaticsScopeCorrect() {
            return this.myClassResolveResult.isStaticsScopeCorrect();
        }

        public PsiElement getCurrentFileResolveScope() {
            return this.myClassResolveResult.getCurrentFileResolveScope();
        }

        public boolean isValidResult() {
            return this.myClassResolveResult.isValidResult();
        }
    }

    private class PsiCorrectedClassType
    extends PsiClassType.Stub {
        private final PsiClassType myDelegate;
        private final CorrectedResolveResult myResolveResult;

        public PsiCorrectedClassType(LanguageLevel languageLevel, PsiClassType delegate, CorrectedResolveResult resolveResult) {
            super(languageLevel, delegate.getAnnotationProvider());
            this.myDelegate = delegate;
            this.myResolveResult = resolveResult;
        }

        @NotNull
        public String getCanonicalText(boolean annotated) {
            return this.myDelegate.getCanonicalText();
        }

        @NotNull
        public PsiClass resolve() {
            return this.myResolveResult.myMappedClass;
        }

        public String getClassName() {
            return this.myDelegate.getClassName();
        }

        @NotNull
        public PsiType[] getParameters() {
            return (PsiType[])ContainerUtil.map2Array((Object[])this.myDelegate.getParameters(), PsiType.class, (Function)new Function<PsiType, PsiType>(){

                public PsiType fun(PsiType type) {
                    if (type == null) {
                        LOG.error(PsiCorrectedClassType.this.myDelegate + " of " + PsiCorrectedClassType.this.myDelegate.getClass() + "; substitutor=" + PsiCorrectedClassType.this.myDelegate.resolveGenerics().getSubstitutor());
                        return null;
                    }
                    return TypeCorrector.this.mapType(type);
                }
            });
        }

        public int getParameterCount() {
            return this.myDelegate.getParameters().length;
        }

        @NotNull
        public PsiClassType.ClassResolveResult resolveGenerics() {
            return this.myResolveResult;
        }

        @NotNull
        public PsiClassType rawType() {
            PsiClass psiClass = this.resolve();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)psiClass.getProject());
            return factory.createType(psiClass, factory.createRawSubstitutor((PsiTypeParameterListOwner)psiClass));
        }

        @NotNull
        public GlobalSearchScope getResolveScope() {
            return TypeCorrector.this.myResolveScope;
        }

        @NotNull
        public LanguageLevel getLanguageLevel() {
            return this.myLanguageLevel;
        }

        @NotNull
        public PsiClassType setLanguageLevel(@NotNull LanguageLevel languageLevel) {
            return new PsiCorrectedClassType(languageLevel, this.myDelegate, this.myResolveResult);
        }

        @NotNull
        public String getPresentableText() {
            return this.myDelegate.getPresentableText();
        }

        @NotNull
        public String getInternalCanonicalText() {
            return this.myDelegate.getInternalCanonicalText();
        }

        public boolean isValid() {
            return this.myDelegate.isValid() && this.resolve().isValid();
        }

        public boolean equalsToText(@NotNull @NonNls String text) {
            return this.myDelegate.equalsToText(text);
        }
    }
}

