/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.java.parser.DeclarationParser;
import com.intellij.lang.java.parser.JavaParser;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.GeneratedMarkerVisitor;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.JavaDummyElement;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiJavaParserFacadeImpl
implements PsiJavaParserFacade {
    protected final PsiManager myManager;
    private static final String DUMMY_FILE_NAME = "_Dummy_." + JavaFileType.INSTANCE.getDefaultExtension();
    private static final JavaParserUtil.ParserWrapper ANNOTATION = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getDeclarationParser().parseAnnotation(builder);
        }
    };
    private static final JavaParserUtil.ParserWrapper PARAMETER = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getDeclarationParser().parseParameter(builder, true, false);
        }
    };
    private static final JavaParserUtil.ParserWrapper RESOURCE = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getDeclarationParser().parseResource(builder);
        }
    };
    private static final JavaParserUtil.ParserWrapper TYPE = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getReferenceParser().parseType(builder, 23);
        }
    };
    public static final JavaParserUtil.ParserWrapper REFERENCE = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getReferenceParser().parseJavaCodeReference(builder, false, true, false, false);
        }
    };
    public static final JavaParserUtil.ParserWrapper DIAMOND_REF = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getReferenceParser().parseJavaCodeReference(builder, false, true, false, true);
        }
    };
    public static final JavaParserUtil.ParserWrapper STATIC_IMPORT_REF = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getReferenceParser().parseImportCodeReference(builder, true);
        }
    };
    private static final JavaParserUtil.ParserWrapper TYPE_PARAMETER = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getReferenceParser().parseTypeParameter(builder);
        }
    };
    private static final JavaParserUtil.ParserWrapper DECLARATION = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getDeclarationParser().parse(builder, DeclarationParser.Context.CLASS);
        }
    };
    private static final JavaParserUtil.ParserWrapper CODE_BLOCK = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getStatementParser().parseCodeBlockDeep(builder, true);
        }
    };
    private static final JavaParserUtil.ParserWrapper STATEMENT = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getStatementParser().parseStatement(builder);
        }
    };
    private static final JavaParserUtil.ParserWrapper EXPRESSION = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getExpressionParser().parse(builder);
        }
    };
    private static final JavaParserUtil.ParserWrapper ENUM_CONSTANT = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getDeclarationParser().parseEnumConstant(builder);
        }
    };
    private static final Map<String, PsiPrimitiveType> PRIMITIVE_TYPES = new HashMap();

    public PsiJavaParserFacadeImpl(PsiManager manager) {
        this.myManager = manager;
    }

    @NotNull
    public PsiAnnotation createAnnotationFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        DummyHolder holder = DummyHolderFactory.createHolder(this.myManager, new JavaDummyElement(text, ANNOTATION, PsiJavaParserFacadeImpl.level(context)), context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiAnnotation)) {
            throw new IncorrectOperationException("Incorrect annotation '" + text + "'");
        }
        return (PsiAnnotation)element;
    }

    @NotNull
    public PsiDocTag createDocTagFromText(@NotNull String text) throws IncorrectOperationException {
        return this.createDocCommentFromText(StringUtil.join((String[])new String[]{"/**\n", text, "\n */"})).getTags()[0];
    }

    @NotNull
    public PsiDocComment createDocCommentFromText(@NotNull String docCommentText) throws IncorrectOperationException {
        return this.createDocCommentFromText(docCommentText, null);
    }

    @NotNull
    public PsiDocComment createDocCommentFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        PsiMethod method = this.createMethodFromText(text.trim() + "void m();", context);
        PsiDocComment comment = method.getDocComment();
        if (comment == null) {
            throw new IncorrectOperationException("Incorrect comment '" + text + "'");
        }
        return comment;
    }

    @NotNull
    public PsiClass createClassFromText(@NotNull String body, @Nullable PsiElement context) throws IncorrectOperationException {
        PsiJavaFile aFile = this.createDummyJavaFile(StringUtil.join((String[])new String[]{"class _Dummy_ {\n", body, "\n}"}));
        PsiClass[] classes = aFile.getClasses();
        if (classes.length != 1) {
            throw new IncorrectOperationException("Incorrect class '" + body + "'");
        }
        return classes[0];
    }

    @NotNull
    public PsiField createFieldFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        DummyHolder holder = DummyHolderFactory.createHolder(this.myManager, new JavaDummyElement(text, DECLARATION, PsiJavaParserFacadeImpl.level(context)), context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiField)) {
            throw new IncorrectOperationException("Incorrect field '" + text + "'");
        }
        return (PsiField)element;
    }

    @NotNull
    public PsiMethod createMethodFromText(@NotNull String text, @Nullable PsiElement context, LanguageLevel level) throws IncorrectOperationException {
        DummyHolder holder = DummyHolderFactory.createHolder(this.myManager, new JavaDummyElement(text, DECLARATION, level), context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiMethod)) {
            throw PsiJavaParserFacadeImpl.newException("Incorrect method '" + text + "'", holder);
        }
        return (PsiMethod)element;
    }

    @NotNull
    public final PsiMethod createMethodFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        LanguageLevel level = LanguageLevelProjectExtension.getInstance((Project)this.myManager.getProject()).getLanguageLevel();
        return this.createMethodFromText(text, context, level);
    }

    @NotNull
    public PsiParameter createParameterFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        DummyHolder holder = DummyHolderFactory.createHolder(this.myManager, new JavaDummyElement(text, PARAMETER, PsiJavaParserFacadeImpl.level(context)), context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiParameter)) {
            throw new IncorrectOperationException("Incorrect parameter '" + text + "'");
        }
        return (PsiParameter)element;
    }

    @NotNull
    public PsiResourceVariable createResourceFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        DummyHolder holder = DummyHolderFactory.createHolder(this.myManager, new JavaDummyElement(text, RESOURCE, PsiJavaParserFacadeImpl.level(context)), context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiResourceVariable)) {
            throw new IncorrectOperationException("Incorrect resource '" + text + "'");
        }
        return (PsiResourceVariable)element;
    }

    @NotNull
    public PsiType createTypeFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        return this.createTypeInner(text, context, false);
    }

    @NotNull
    public PsiTypeElement createTypeElementFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        LanguageLevel level = PsiJavaParserFacadeImpl.level(context);
        DummyHolder holder = DummyHolderFactory.createHolder(this.myManager, new JavaDummyElement(text, TYPE, level), context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiTypeElement)) {
            throw new IncorrectOperationException("Incorrect type '" + text + "' (" + level + ")");
        }
        return (PsiTypeElement)element;
    }

    protected PsiType createTypeInner(String text, @Nullable PsiElement context, boolean markAsCopy) throws IncorrectOperationException {
        PsiPrimitiveType primitiveType = PRIMITIVE_TYPES.get(text);
        if (primitiveType != null) {
            return primitiveType;
        }
        PsiTypeElement element = this.createTypeElementFromText(text, context);
        if (markAsCopy) {
            GeneratedMarkerVisitor.markGenerated((PsiElement)element);
        }
        return element.getType();
    }

    @NotNull
    public PsiJavaCodeReferenceElement createReferenceFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        boolean mayHaveDiamonds;
        boolean isStaticImport = context instanceof PsiImportStaticStatement && !((PsiImportStaticStatement)context).isOnDemand();
        boolean bl = mayHaveDiamonds = context instanceof PsiNewExpression && PsiUtil.getLanguageLevel((PsiElement)context).isAtLeast(LanguageLevel.JDK_1_7);
        JavaParserUtil.ParserWrapper wrapper = isStaticImport ? STATIC_IMPORT_REF : (mayHaveDiamonds ? DIAMOND_REF : REFERENCE);
        DummyHolder holder = DummyHolderFactory.createHolder(this.myManager, new JavaDummyElement(text, wrapper, PsiJavaParserFacadeImpl.level(context)), context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiJavaCodeReferenceElement)) {
            throw new IncorrectOperationException("Incorrect reference '" + text + "'");
        }
        return (PsiJavaCodeReferenceElement)element;
    }

    @NotNull
    public PsiCodeBlock createCodeBlockFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        DummyHolder holder = DummyHolderFactory.createHolder(this.myManager, new JavaDummyElement(text, CODE_BLOCK, PsiJavaParserFacadeImpl.level(context), true), context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiCodeBlock)) {
            throw new IncorrectOperationException("Incorrect code block '" + text + "'");
        }
        return (PsiCodeBlock)element;
    }

    @NotNull
    public PsiStatement createStatementFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        DummyHolder holder = DummyHolderFactory.createHolder(this.myManager, new JavaDummyElement(text, STATEMENT, PsiJavaParserFacadeImpl.level(context)), context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiStatement)) {
            throw new IncorrectOperationException("Incorrect statement '" + text + "'");
        }
        return (PsiStatement)element;
    }

    @NotNull
    public PsiExpression createExpressionFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        DummyHolder holder = DummyHolderFactory.createHolder(this.myManager, new JavaDummyElement(text, EXPRESSION, PsiJavaParserFacadeImpl.level(context)), context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiExpression)) {
            throw new IncorrectOperationException("Incorrect expression '" + text + "'");
        }
        return (PsiExpression)element;
    }

    protected PsiJavaFile createDummyJavaFile(@NonNls String text) {
        JavaFileType type = JavaFileType.INSTANCE;
        return (PsiJavaFile)PsiFileFactory.getInstance((Project)this.myManager.getProject()).createFileFromText(DUMMY_FILE_NAME, (FileType)type, (CharSequence)text);
    }

    @NotNull
    public PsiTypeParameter createTypeParameterFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        DummyHolder holder = DummyHolderFactory.createHolder(this.myManager, new JavaDummyElement(text, TYPE_PARAMETER, PsiJavaParserFacadeImpl.level(context)), context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiTypeParameter)) {
            throw new IncorrectOperationException("Incorrect type parameter '" + text + "'");
        }
        return (PsiTypeParameter)element;
    }

    @NotNull
    public PsiComment createCommentFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        PsiJavaFile aFile = this.createDummyJavaFile(text);
        for (PsiElement aChildren : aFile.getChildren()) {
            if (!(aChildren instanceof PsiComment)) continue;
            if (!aChildren.getText().equals(text)) break;
            PsiComment comment = (PsiComment)aChildren;
            DummyHolderFactory.createHolder(this.myManager, (TreeElement)SourceTreeToPsiMap.psiElementToTree((PsiElement)comment), context);
            return comment;
        }
        throw new IncorrectOperationException("Incorrect comment '" + text + "'");
    }

    @NotNull
    public PsiEnumConstant createEnumConstantFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        DummyHolder holder = DummyHolderFactory.createHolder(this.myManager, new JavaDummyElement(text, ENUM_CONSTANT, PsiJavaParserFacadeImpl.level(context)), context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiEnumConstant)) {
            throw new IncorrectOperationException("Incorrect enum constant '" + text + "'");
        }
        return (PsiEnumConstant)element;
    }

    @NotNull
    public PsiType createPrimitiveType(@NotNull String text, @NotNull PsiAnnotation[] annotations) throws IncorrectOperationException {
        PsiPrimitiveType primitiveType = PsiJavaParserFacadeImpl.getPrimitiveType(text);
        if (primitiveType == null) {
            throw new IncorrectOperationException("Incorrect primitive type '" + text + "'");
        }
        return annotations.length == 0 ? primitiveType : new PsiPrimitiveType(text, annotations);
    }

    public static PsiPrimitiveType getPrimitiveType(String text) {
        return PRIMITIVE_TYPES.get(text);
    }

    protected static LanguageLevel level(@Nullable PsiElement context) {
        return context != null && context.isValid() ? PsiUtil.getLanguageLevel((PsiElement)context) : LanguageLevel.HIGHEST;
    }

    private static IncorrectOperationException newException(String msg, DummyHolder holder) {
        Throwable cause;
        FileElement root = holder.getTreeElement();
        if (root instanceof JavaDummyElement && (cause = ((JavaDummyElement)root).getParserError()) != null) {
            return new IncorrectOperationException(msg, cause);
        }
        return new IncorrectOperationException(msg);
    }

    static {
        PRIMITIVE_TYPES.put(PsiType.BYTE.getCanonicalText(), PsiType.BYTE);
        PRIMITIVE_TYPES.put(PsiType.CHAR.getCanonicalText(), PsiType.CHAR);
        PRIMITIVE_TYPES.put(PsiType.DOUBLE.getCanonicalText(), PsiType.DOUBLE);
        PRIMITIVE_TYPES.put(PsiType.FLOAT.getCanonicalText(), PsiType.FLOAT);
        PRIMITIVE_TYPES.put(PsiType.INT.getCanonicalText(), PsiType.INT);
        PRIMITIVE_TYPES.put(PsiType.LONG.getCanonicalText(), PsiType.LONG);
        PRIMITIVE_TYPES.put(PsiType.SHORT.getCanonicalText(), PsiType.SHORT);
        PRIMITIVE_TYPES.put(PsiType.BOOLEAN.getCanonicalText(), PsiType.BOOLEAN);
        PRIMITIVE_TYPES.put(PsiType.VOID.getCanonicalText(), PsiType.VOID);
        PRIMITIVE_TYPES.put(PsiType.NULL.getCanonicalText(), PsiType.NULL);
    }
}

