/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.FileViewProviderFactory;
import com.intellij.psi.LanguageFileViewProviders;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.GeneratedMarkerVisitor;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.PsiPlainTextFileImpl;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.text.CharSequenceSubSequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiFileFactoryImpl
extends PsiFileFactory {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.PsiFileFactoryImpl");
    private final PsiManager myManager;

    public PsiFileFactoryImpl(PsiManager manager) {
        this.myManager = manager;
    }

    @NotNull
    public PsiFile createFileFromText(@NotNull String name, @NotNull FileType fileType, @NotNull CharSequence text, long modificationStamp, boolean eventSystemEnabled) {
        return this.createFileFromText(name, fileType, text, modificationStamp, eventSystemEnabled, true);
    }

    public PsiFile createFileFromText(@NotNull String name, @NotNull Language language, @NotNull CharSequence text) {
        return this.createFileFromText(name, language, text, true, true);
    }

    public PsiFile createFileFromText(@NotNull String name, @NotNull Language language, @NotNull CharSequence text, boolean eventSystemEnabled, boolean markAsCopy) {
        return this.createFileFromText(name, language, text, eventSystemEnabled, markAsCopy, false);
    }

    public PsiFile createFileFromText(@NotNull String name, @NotNull Language language, @NotNull CharSequence text, boolean eventSystemEnabled, boolean markAsCopy, boolean noSizeLimit) {
        return this.createFileFromText(name, language, text, eventSystemEnabled, markAsCopy, noSizeLimit, null);
    }

    public PsiFile createFileFromText(@NotNull String name, @NotNull Language language, @NotNull CharSequence text, boolean eventSystemEnabled, boolean markAsCopy, boolean noSizeLimit, @Nullable VirtualFile original) {
        LightVirtualFile virtualFile = new LightVirtualFile(name, language, text);
        if (original != null) {
            virtualFile.setOriginalFile(original);
        }
        if (noSizeLimit) {
            SingleRootFileViewProvider.doNotCheckFileSizeLimit((VirtualFile)virtualFile);
        }
        return this.trySetupPsiForFile(virtualFile, language, eventSystemEnabled, markAsCopy);
    }

    @NotNull
    public PsiFile createFileFromText(@NotNull String name, @NotNull FileType fileType, @NotNull CharSequence text, long modificationStamp, boolean eventSystemEnabled, boolean markAsCopy) {
        Language language;
        PsiFile file2;
        LightVirtualFile virtualFile = new LightVirtualFile(name, fileType, text, modificationStamp);
        if (fileType instanceof LanguageFileType && (file2 = this.trySetupPsiForFile(virtualFile, language = LanguageSubstitutors.INSTANCE.substituteLanguage(((LanguageFileType)fileType).getLanguage(), (VirtualFile)virtualFile, this.myManager.getProject()), eventSystemEnabled, markAsCopy)) != null) {
            return file2;
        }
        SingleRootFileViewProvider singleRootFileViewProvider = new SingleRootFileViewProvider(this.myManager, (VirtualFile)virtualFile, eventSystemEnabled);
        PsiPlainTextFileImpl plainTextFile = new PsiPlainTextFileImpl(singleRootFileViewProvider);
        if (markAsCopy) {
            CodeEditUtil.setNodeGenerated((ASTNode)plainTextFile.getNode(), true);
        }
        return plainTextFile;
    }

    @Nullable
    public PsiFile trySetupPsiForFile(@NotNull LightVirtualFile virtualFile, @NotNull Language language, boolean physical, boolean markAsCopy) {
        PsiFile psiFile;
        ParserDefinition parserDefinition;
        FileViewProvider viewProvider;
        FileViewProviderFactory factory = (FileViewProviderFactory)LanguageFileViewProviders.INSTANCE.forLanguage(language);
        FileViewProvider fileViewProvider = viewProvider = factory != null ? factory.createFileViewProvider((VirtualFile)virtualFile, language, this.myManager, physical) : null;
        if (viewProvider == null) {
            viewProvider = new SingleRootFileViewProvider(this.myManager, (VirtualFile)virtualFile, physical);
        }
        if ((parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language = viewProvider.getBaseLanguage())) != null && (psiFile = viewProvider.getPsi(language)) != null) {
            if (markAsCopy) {
                if (psiFile.getNode() == null) {
                    throw new AssertionError((Object)("No node for file " + psiFile + "; language=" + language));
                }
                PsiFileFactoryImpl.markGenerated((PsiElement)psiFile);
            }
            return psiFile;
        }
        return null;
    }

    @NotNull
    public PsiFile createFileFromText(@NotNull String name, @NotNull FileType fileType, Language language, @NotNull Language targetLanguage, @NotNull CharSequence text, long modificationStamp, boolean physical, boolean markAsCopy) {
        PsiFile psiFile;
        FileViewProvider viewProvider;
        LightVirtualFile virtualFile = new LightVirtualFile(name, fileType, text, modificationStamp);
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
        FileViewProviderFactory factory = (FileViewProviderFactory)LanguageFileViewProviders.INSTANCE.forLanguage(language);
        FileViewProvider fileViewProvider = viewProvider = factory != null ? factory.createFileViewProvider((VirtualFile)virtualFile, language, this.myManager, physical) : null;
        if (viewProvider == null) {
            viewProvider = new SingleRootFileViewProvider(this.myManager, (VirtualFile)virtualFile, physical);
        }
        if (parserDefinition != null && (psiFile = viewProvider.getPsi(targetLanguage)) != null) {
            if (markAsCopy) {
                PsiFileFactoryImpl.markGenerated((PsiElement)psiFile);
            }
            return psiFile;
        }
        SingleRootFileViewProvider singleRootFileViewProvider = new SingleRootFileViewProvider(this.myManager, (VirtualFile)virtualFile, physical);
        PsiPlainTextFileImpl plainTextFile = new PsiPlainTextFileImpl(singleRootFileViewProvider);
        if (markAsCopy) {
            CodeEditUtil.setNodeGenerated((ASTNode)plainTextFile.getNode(), true);
        }
        return plainTextFile;
    }

    @NotNull
    public PsiFile createFileFromText(@NotNull String name, @NotNull FileType fileType, @NotNull CharSequence text) {
        return this.createFileFromText(name, fileType, text, LocalTimeCounter.currentTime(), false);
    }

    @NotNull
    public PsiFile createFileFromText(@NotNull String name, @NotNull String text) {
        FileType type = FileTypeRegistry.getInstance().getFileTypeByFileName(name);
        if (type.isBinary()) {
            throw new RuntimeException("Cannot create binary files from text: name " + name + ", file type " + type);
        }
        return this.createFileFromText(name, type, (CharSequence)text);
    }

    public PsiFile createFileFromText(FileType fileType, String fileName, CharSequence chars, int startOffset, int endOffset) {
        LOG.assertTrue(!fileType.isBinary());
        Object text = startOffset == 0 && endOffset == chars.length() ? chars : new CharSequenceSubSequence(chars, startOffset, endOffset);
        return this.createFileFromText(fileName, fileType, (CharSequence)text);
    }

    @Nullable
    public PsiFile createFileFromText(@NotNull CharSequence chars, @NotNull PsiFile original) {
        PsiFile file2 = this.createFileFromText(original.getName(), original.getLanguage(), chars, false, true);
        if (file2 != null) {
            file2.putUserData(ORIGINAL_FILE, (Object)original);
        }
        return file2;
    }

    @Nullable
    public PsiElement createElementFromText(@Nullable String text, @NotNull Language language, @NotNull IElementType type, @Nullable PsiElement context) {
        if (text == null) {
            return null;
        }
        DummyHolder result = DummyHolderFactory.createHolder(this.myManager, language, context);
        FileElement holder = result.getTreeElement();
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
        if (parserDefinition == null) {
            throw new AssertionError((Object)("No parser definition for " + language));
        }
        Project project2 = this.myManager.getProject();
        Lexer lexer = parserDefinition.createLexer(project2);
        PsiBuilder builder = PsiBuilderFactory.getInstance().createBuilder(project2, (ASTNode)holder, lexer, language, (CharSequence)text);
        ASTNode node = parserDefinition.createParser(project2).parse(type, builder);
        holder.rawAddChildren((TreeElement)node);
        PsiFileFactoryImpl.markGenerated((PsiElement)result);
        return node.getPsi();
    }

    public static void markGenerated(PsiElement element) {
        TreeElement node = (TreeElement)element.getNode();
        assert (node != null);
        node.acceptTree(new GeneratedMarkerVisitor());
    }
}

