/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lang.java.lexer.JavaLexer;
import com.intellij.lang.java.parser.JavaParser;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettingsFacade;
import com.intellij.psi.impl.GeneratedMarkerVisitor;
import com.intellij.psi.impl.JavaPsiImplementationHelper;
import com.intellij.psi.impl.PsiJavaParserFacadeImpl;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiSubstitutorImpl;
import com.intellij.psi.impl.light.LightClassReference;
import com.intellij.psi.impl.light.LightClassReferenceExpression;
import com.intellij.psi.impl.light.LightIdentifier;
import com.intellij.psi.impl.light.LightKeyword;
import com.intellij.psi.impl.light.LightPackageReference;
import com.intellij.psi.impl.light.LightPackageReferenceExpression;
import com.intellij.psi.impl.light.LightTypeElement;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.JavaDummyElement;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.PsiExtensibleClass;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiElementFactoryImpl
extends PsiJavaParserFacadeImpl
implements PsiElementFactory {
    private PsiClass myArrayClass;
    private PsiClass myArrayClass15;
    private final ConcurrentMap<GlobalSearchScope, PsiClassType> myCachedObjectType = ContainerUtil.newConcurrentMap();
    private static final JavaParserUtil.ParserWrapper CATCH_SECTION = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getStatementParser().parseCatchBlock(builder);
        }
    };

    public PsiElementFactoryImpl(PsiManagerEx manager) {
        super(manager);
        manager.registerRunnableToRunOnChange(new Runnable(){

            @Override
            public void run() {
                PsiElementFactoryImpl.this.myCachedObjectType.clear();
            }
        });
    }

    @NotNull
    public PsiClass getArrayClass(@NotNull LanguageLevel languageLevel) {
        if (!languageLevel.isAtLeast(LanguageLevel.JDK_1_5)) {
            if (this.myArrayClass == null) {
                String body = "public class __Array__{\n public final int length;\n public Object clone() {}\n}";
                this.myArrayClass = ((PsiExtensibleClass)this.createClassFromText("public class __Array__{\n public final int length;\n public Object clone() {}\n}", null)).getOwnInnerClasses().get(0);
                PsiElementFactoryImpl.ensureNonWritable(this.myArrayClass);
            }
            return this.myArrayClass;
        }
        if (this.myArrayClass15 == null) {
            String body = "public class __Array__<T>{\n public final int length;\n public T[] clone() {}\n}";
            this.myArrayClass15 = ((PsiExtensibleClass)this.createClassFromText("public class __Array__<T>{\n public final int length;\n public T[] clone() {}\n}", null)).getOwnInnerClasses().get(0);
            PsiElementFactoryImpl.ensureNonWritable(this.myArrayClass15);
        }
        return this.myArrayClass15;
    }

    private static void ensureNonWritable(PsiClass arrayClass) {
        try {
            arrayClass.getContainingFile().getViewProvider().getVirtualFile().setWritable(false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @NotNull
    public PsiClassType getArrayClassType(@NotNull PsiType componentType, @NotNull LanguageLevel languageLevel) {
        PsiClass arrayClass = this.getArrayClass(languageLevel);
        PsiTypeParameter[] typeParameters = arrayClass.getTypeParameters();
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        if (typeParameters.length == 1) {
            substitutor = substitutor.put(typeParameters[0], componentType);
        }
        return this.createType(arrayClass, substitutor);
    }

    @NotNull
    public PsiClassType createType(@NotNull PsiClass resolve, @NotNull PsiSubstitutor substitutor) {
        return new PsiImmediateClassType(resolve, substitutor);
    }

    @NotNull
    public PsiClassType createType(@NotNull PsiClass resolve, @NotNull PsiSubstitutor substitutor, @Nullable LanguageLevel languageLevel) {
        return new PsiImmediateClassType(resolve, substitutor, languageLevel);
    }

    @NotNull
    public PsiClassType createType(@NotNull PsiClass resolve, @NotNull PsiSubstitutor substitutor, @Nullable LanguageLevel languageLevel, @NotNull PsiAnnotation[] annotations) {
        return new PsiImmediateClassType(resolve, substitutor, languageLevel, annotations);
    }

    @NotNull
    public PsiClass createClass(@NotNull String name) throws IncorrectOperationException {
        return this.createClassInner("class", name);
    }

    @NotNull
    public PsiClass createInterface(@NotNull String name) throws IncorrectOperationException {
        return this.createClassInner("interface", name);
    }

    @NotNull
    public PsiClass createEnum(@NotNull String name) throws IncorrectOperationException {
        return this.createClassInner("enum", name);
    }

    @NotNull
    public PsiClass createAnnotationType(@NotNull @NonNls String name) throws IncorrectOperationException {
        return this.createClassInner("@interface", name);
    }

    private PsiClass createClassInner(@NonNls String type, @NonNls String name) {
        PsiUtil.checkIsIdentifier((PsiManager)this.myManager, (String)name);
        PsiJavaFile aFile = this.createDummyJavaFile("public " + type + " " + name + " { }");
        PsiClass[] classes = aFile.getClasses();
        if (classes.length != 1) {
            throw new IncorrectOperationException("Incorrect " + type + " name \"" + name + "\".");
        }
        return classes[0];
    }

    @NotNull
    public PsiTypeElement createTypeElement(@NotNull PsiType psiType) {
        LightTypeElement element = new LightTypeElement(this.myManager, psiType);
        CodeEditUtil.setNodeGenerated(element.getNode(), true);
        return element;
    }

    @NotNull
    public PsiJavaCodeReferenceElement createReferenceElementByType(@NotNull PsiClassType type) {
        if (type instanceof PsiClassReferenceType) {
            return ((PsiClassReferenceType)type).getReference();
        }
        PsiClassType.ClassResolveResult resolveResult = type.resolveGenerics();
        PsiClass refClass = resolveResult.getElement();
        assert (refClass != null) : type;
        return new LightClassReference(this.myManager, type.getCanonicalText(true), refClass, resolveResult.getSubstitutor());
    }

    @NotNull
    public PsiTypeParameterList createTypeParameterList() {
        PsiTypeParameterList parameterList = this.createMethodFromText("void foo()", null).getTypeParameterList();
        assert (parameterList != null);
        return parameterList;
    }

    @NotNull
    public PsiTypeParameter createTypeParameter(String name, PsiClassType[] superTypes) {
        StringBuilder builder = new StringBuilder();
        builder.append("public <").append(name);
        if (superTypes.length > 1 || superTypes.length == 1 && !superTypes[0].equalsToText("java.lang.Object")) {
            builder.append(" extends ");
            for (PsiClassType type : superTypes) {
                if (type.equalsToText("java.lang.Object")) continue;
                builder.append(type.getCanonicalText(true)).append('&');
            }
            builder.delete(builder.length() - 1, builder.length());
        }
        builder.append("> void foo(){}");
        try {
            return this.createMethodFromText(builder.toString(), null).getTypeParameters()[0];
        }
        catch (RuntimeException e) {
            throw new IncorrectOperationException("type parameter text: " + builder.toString());
        }
    }

    @NotNull
    public PsiField createField(@NotNull String name, @NotNull PsiType type) throws IncorrectOperationException {
        PsiUtil.checkIsIdentifier((PsiManager)this.myManager, (String)name);
        if (PsiType.NULL.equals((Object)type)) {
            throw new IncorrectOperationException("Cannot create field with type \"null\".");
        }
        String text = "class _Dummy_ { private " + type.getCanonicalText(true) + " " + name + "; }";
        PsiJavaFile aFile = this.createDummyJavaFile(text);
        PsiClass[] classes = aFile.getClasses();
        if (classes.length < 1) {
            throw new IncorrectOperationException("Class was not created " + text);
        }
        PsiClass psiClass = classes[0];
        PsiField[] fields = psiClass.getFields();
        if (fields.length < 1) {
            throw new IncorrectOperationException("Field was not created " + text);
        }
        PsiField field = fields[0];
        field = (PsiField)JavaCodeStyleManager.getInstance((Project)this.myManager.getProject()).shortenClassReferences((PsiElement)field);
        return (PsiField)CodeStyleManager.getInstance((Project)this.myManager.getProject()).reformat((PsiElement)field);
    }

    @NotNull
    public PsiMethod createMethod(@NotNull String name, PsiType returnType) throws IncorrectOperationException {
        PsiUtil.checkIsIdentifier((PsiManager)this.myManager, (String)name);
        if (PsiType.NULL.equals((Object)returnType)) {
            throw new IncorrectOperationException("Cannot create method with type \"null\".");
        }
        String canonicalText = returnType.getCanonicalText(true);
        PsiJavaFile aFile = this.createDummyJavaFile("class _Dummy_ { public " + canonicalText + " " + name + "() {} }");
        PsiClass[] classes = aFile.getClasses();
        if (classes.length < 1) {
            throw new IncorrectOperationException("Class was not created. Method name: " + name + "; return type: " + canonicalText);
        }
        PsiMethod[] methods = classes[0].getMethods();
        if (methods.length < 1) {
            throw new IncorrectOperationException("Method was not created. Method name: " + name + "; return type: " + canonicalText);
        }
        PsiMethod method = methods[0];
        method = (PsiMethod)JavaCodeStyleManager.getInstance((Project)this.myManager.getProject()).shortenClassReferences((PsiElement)method);
        return (PsiMethod)CodeStyleManager.getInstance((Project)this.myManager.getProject()).reformat((PsiElement)method);
    }

    @NotNull
    public PsiMethod createMethod(@NotNull @NonNls String name, PsiType returnType, PsiElement context) throws IncorrectOperationException {
        return this.createMethodFromText("public " + returnType.getCanonicalText(true) + " " + name + "() {}", context);
    }

    @NotNull
    public PsiMethod createConstructor() {
        return this.createConstructor("_Dummy_");
    }

    @NotNull
    public PsiMethod createConstructor(@NotNull @NonNls String name) {
        PsiJavaFile aFile = this.createDummyJavaFile("class " + name + " { public " + name + "() {} }");
        PsiMethod method = aFile.getClasses()[0].getMethods()[0];
        return (PsiMethod)CodeStyleManager.getInstance((Project)this.myManager.getProject()).reformat((PsiElement)method);
    }

    public PsiMethod createConstructor(@NotNull @NonNls String name, PsiElement context) {
        return this.createMethodFromText(name + "() {}", context);
    }

    @NotNull
    public PsiClassInitializer createClassInitializer() throws IncorrectOperationException {
        PsiJavaFile aFile = this.createDummyJavaFile("class _Dummy_ { {} }");
        PsiClassInitializer classInitializer = aFile.getClasses()[0].getInitializers()[0];
        return (PsiClassInitializer)CodeStyleManager.getInstance((Project)this.myManager.getProject()).reformat((PsiElement)classInitializer);
    }

    @NotNull
    public PsiParameter createParameter(@NotNull String name, @NotNull PsiType type) throws IncorrectOperationException {
        PsiUtil.checkIsIdentifier((PsiManager)this.myManager, (String)name);
        if (PsiType.NULL.equals((Object)type)) {
            throw new IncorrectOperationException("Cannot create parameter with type \"null\".");
        }
        String text = type.getCanonicalText(true) + " " + name;
        PsiParameter parameter = this.createParameterFromText(text, null);
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)this.myManager.getProject());
        PsiUtil.setModifierProperty((PsiModifierListOwner)parameter, (String)"final", (boolean)JavaCodeStyleSettingsFacade.getInstance((Project)this.myManager.getProject()).isGenerateFinalParameters());
        GeneratedMarkerVisitor.markGenerated((PsiElement)parameter);
        parameter = (PsiParameter)JavaCodeStyleManager.getInstance((Project)this.myManager.getProject()).shortenClassReferences((PsiElement)parameter);
        return (PsiParameter)codeStyleManager.reformat((PsiElement)parameter);
    }

    public PsiParameter createParameter(@NotNull @NonNls String name, PsiType type, PsiElement context) throws IncorrectOperationException {
        PsiMethod psiMethod = this.createMethodFromText("void f(" + type.getCanonicalText(true) + " " + name + ") {}", context);
        PsiParameter[] parameters = psiMethod.getParameterList().getParameters();
        return parameters[0];
    }

    @NotNull
    public PsiCodeBlock createCodeBlock() {
        PsiCodeBlock block = this.createCodeBlockFromText("{}", null);
        return (PsiCodeBlock)CodeStyleManager.getInstance((Project)this.myManager.getProject()).reformat((PsiElement)block);
    }

    @NotNull
    public PsiClassType createType(@NotNull PsiClass aClass) {
        return new PsiImmediateClassType(aClass, aClass instanceof PsiTypeParameter ? PsiSubstitutor.EMPTY : this.createRawSubstitutor((PsiTypeParameterListOwner)aClass));
    }

    @NotNull
    public PsiClassType createType(@NotNull PsiJavaCodeReferenceElement classReference) {
        return new PsiClassReferenceType(classReference, null);
    }

    @NotNull
    public PsiClassType createType(@NotNull PsiClass aClass, PsiType parameter) {
        PsiTypeParameter[] typeParameters = aClass.getTypeParameters();
        assert (typeParameters.length == 1) : aClass;
        return this.createType(aClass, PsiSubstitutor.EMPTY.put(typeParameters[0], parameter));
    }

    @NotNull
    public PsiClassType createType(@NotNull PsiClass aClass, PsiType ... parameters) {
        return this.createType(aClass, PsiSubstitutor.EMPTY.putAll(aClass, parameters));
    }

    @NotNull
    public PsiSubstitutor createRawSubstitutor(@NotNull PsiTypeParameterListOwner owner) {
        HashMap substitutorMap = null;
        for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)owner)) {
            if (substitutorMap == null) {
                substitutorMap = new HashMap();
            }
            substitutorMap.put(parameter, null);
        }
        return PsiSubstitutorImpl.createSubstitutor(substitutorMap);
    }

    @NotNull
    public PsiSubstitutor createRawSubstitutor(@NotNull PsiSubstitutor baseSubstitutor, @NotNull PsiTypeParameter[] typeParameters) {
        HashMap substitutorMap = null;
        for (PsiTypeParameter parameter : typeParameters) {
            if (substitutorMap == null) {
                substitutorMap = new HashMap();
            }
            substitutorMap.put(parameter, null);
        }
        return PsiSubstitutorImpl.createSubstitutor(substitutorMap).putAll(baseSubstitutor);
    }

    @NotNull
    public PsiElement createDummyHolder(@NotNull String text, @NotNull IElementType type, @Nullable PsiElement context) {
        DummyHolder result = DummyHolderFactory.createHolder(this.myManager, context);
        FileElement holder = result.getTreeElement();
        Language language = type.getLanguage();
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
        assert (parserDefinition != null) : "No parser definition for language " + language;
        Project project2 = this.myManager.getProject();
        Lexer lexer = parserDefinition.createLexer(project2);
        PsiBuilder builder = PsiBuilderFactory.getInstance().createBuilder(project2, (ASTNode)holder, lexer, language, (CharSequence)text);
        ASTNode node = parserDefinition.createParser(project2).parse(type, builder);
        holder.rawAddChildren((TreeElement)node);
        PsiElement psi = node.getPsi();
        assert (psi != null) : text;
        return psi;
    }

    @NotNull
    public PsiSubstitutor createSubstitutor(@NotNull Map<PsiTypeParameter, PsiType> map) {
        return PsiSubstitutorImpl.createSubstitutor(map);
    }

    @Nullable
    public PsiPrimitiveType createPrimitiveType(@NotNull String text) {
        return PsiJavaParserFacadeImpl.getPrimitiveType(text);
    }

    @NotNull
    public PsiClassType createTypeByFQClassName(@NotNull String qName) {
        return this.createTypeByFQClassName(qName, GlobalSearchScope.allScope((Project)this.myManager.getProject()));
    }

    @NotNull
    public PsiClassType createTypeByFQClassName(@NotNull String qName, @NotNull GlobalSearchScope resolveScope) {
        if ("java.lang.Object".equals(qName)) {
            Object cachedObjectType = (PsiClassType)this.myCachedObjectType.get(resolveScope);
            if (cachedObjectType != null) {
                return cachedObjectType;
            }
            PsiClass aClass = JavaPsiFacade.getInstance((Project)this.myManager.getProject()).findClass("java.lang.Object", resolveScope);
            if (aClass != null) {
                cachedObjectType = new PsiImmediateClassType(aClass, PsiSubstitutor.EMPTY);
                cachedObjectType = (PsiClassType)ConcurrencyUtil.cacheOrGet(this.myCachedObjectType, (Object)resolveScope, (Object)cachedObjectType);
                return cachedObjectType;
            }
        }
        return new PsiClassReferenceType(this.createReferenceElementByFQClassName(qName, resolveScope), null);
    }

    @NotNull
    public PsiJavaCodeReferenceElement createClassReferenceElement(@NotNull PsiClass aClass) {
        String text = aClass instanceof PsiAnonymousClass ? ((PsiAnonymousClass)aClass).getBaseClassType().getPresentableText() : aClass.getName();
        return new LightClassReference(this.myManager, text, aClass);
    }

    @NotNull
    public PsiJavaCodeReferenceElement createReferenceElementByFQClassName(@NotNull String qName, @NotNull GlobalSearchScope resolveScope) {
        String shortName = PsiNameHelper.getShortClassName((String)qName);
        return new LightClassReference(this.myManager, shortName, qName, resolveScope);
    }

    @NotNull
    public PsiJavaCodeReferenceElement createFQClassNameReferenceElement(@NotNull String qName, @NotNull GlobalSearchScope resolveScope) {
        return new LightClassReference(this.myManager, qName, qName, resolveScope);
    }

    @NotNull
    public PsiJavaCodeReferenceElement createPackageReferenceElement(@NotNull PsiPackage aPackage) throws IncorrectOperationException {
        if (aPackage.getQualifiedName().isEmpty()) {
            throw new IncorrectOperationException("Cannot create reference to default package.");
        }
        return new LightPackageReference(this.myManager, aPackage);
    }

    @NotNull
    public PsiPackageStatement createPackageStatement(@NotNull String name) throws IncorrectOperationException {
        PsiJavaFile aFile = this.createDummyJavaFile("package " + name + ";");
        PsiPackageStatement stmt = aFile.getPackageStatement();
        if (stmt == null) {
            throw new IncorrectOperationException("Incorrect package name: " + name);
        }
        return stmt;
    }

    @NotNull
    public PsiImportStaticStatement createImportStaticStatement(@NotNull PsiClass aClass, @NotNull String memberName) throws IncorrectOperationException {
        if (aClass instanceof PsiAnonymousClass) {
            throw new IncorrectOperationException("Cannot create import statement for anonymous class.");
        }
        if (aClass.getParent() instanceof PsiDeclarationStatement) {
            throw new IncorrectOperationException("Cannot create import statement for local class.");
        }
        PsiJavaFile aFile = this.createDummyJavaFile("import static " + aClass.getQualifiedName() + "." + memberName + ";");
        PsiImportStatementBase statement2 = PsiElementFactoryImpl.extractImport(aFile, true);
        return (PsiImportStaticStatement)CodeStyleManager.getInstance((Project)this.myManager.getProject()).reformat((PsiElement)statement2);
    }

    @NotNull
    public PsiParameterList createParameterList(@NotNull String[] names, @NotNull PsiType[] types) throws IncorrectOperationException {
        StringBuilder builder = new StringBuilder();
        builder.append("void method(");
        for (int i = 0; i < names.length; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(types[i].getCanonicalText(true)).append(' ').append(names[i]);
        }
        builder.append(");");
        return this.createMethodFromText(builder.toString(), null).getParameterList();
    }

    @NotNull
    public PsiReferenceList createReferenceList(@NotNull PsiJavaCodeReferenceElement[] references) throws IncorrectOperationException {
        StringBuilder builder = new StringBuilder();
        builder.append("void method()");
        if (references.length > 0) {
            builder.append(" throws ");
            for (int i = 0; i < references.length; ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(references[i].getCanonicalText());
            }
        }
        builder.append(';');
        return this.createMethodFromText(builder.toString(), null).getThrowsList();
    }

    @NotNull
    public PsiJavaCodeReferenceElement createPackageReferenceElement(@NotNull String packageName) throws IncorrectOperationException {
        if (packageName.isEmpty()) {
            throw new IncorrectOperationException("Cannot create reference to default package.");
        }
        return new LightPackageReference(this.myManager, packageName);
    }

    @NotNull
    public PsiReferenceExpression createReferenceExpression(@NotNull PsiClass aClass) throws IncorrectOperationException {
        String text = aClass instanceof PsiAnonymousClass ? ((PsiAnonymousClass)aClass).getBaseClassType().getPresentableText() : aClass.getName();
        return new LightClassReferenceExpression(this.myManager, text, aClass);
    }

    @NotNull
    public PsiReferenceExpression createReferenceExpression(@NotNull PsiPackage aPackage) throws IncorrectOperationException {
        if (aPackage.getQualifiedName().isEmpty()) {
            throw new IncorrectOperationException("Cannot create reference to default package.");
        }
        return new LightPackageReferenceExpression(this.myManager, aPackage);
    }

    @NotNull
    public PsiIdentifier createIdentifier(@NotNull String text) throws IncorrectOperationException {
        PsiUtil.checkIsIdentifier((PsiManager)this.myManager, (String)text);
        return new LightIdentifier(this.myManager, text);
    }

    @NotNull
    public PsiKeyword createKeyword(@NotNull String text) throws IncorrectOperationException {
        if (!PsiNameHelper.getInstance((Project)this.myManager.getProject()).isKeyword(text)) {
            throw new IncorrectOperationException("\"" + text + "\" is not a keyword.");
        }
        return new LightKeyword(this.myManager, text);
    }

    @NotNull
    public PsiKeyword createKeyword(@NotNull @NonNls String keyword, PsiElement context) throws IncorrectOperationException {
        if (!JavaLexer.isKeyword(keyword, PsiUtil.getLanguageLevel((PsiElement)context))) {
            throw new IncorrectOperationException("\"" + keyword + "\" is not a keyword.");
        }
        return new LightKeyword(this.myManager, keyword);
    }

    @NotNull
    public PsiImportStatement createImportStatement(@NotNull PsiClass aClass) throws IncorrectOperationException {
        if (aClass instanceof PsiAnonymousClass) {
            throw new IncorrectOperationException("Cannot create import statement for anonymous class.");
        }
        if (aClass.getParent() instanceof PsiDeclarationStatement) {
            throw new IncorrectOperationException("Cannot create import statement for local class.");
        }
        PsiJavaFile aFile = this.createDummyJavaFile("import " + aClass.getQualifiedName() + ";");
        PsiImportStatementBase statement2 = PsiElementFactoryImpl.extractImport(aFile, false);
        return (PsiImportStatement)CodeStyleManager.getInstance((Project)this.myManager.getProject()).reformat((PsiElement)statement2);
    }

    @NotNull
    public PsiImportStatement createImportStatementOnDemand(@NotNull String packageName) throws IncorrectOperationException {
        if (packageName.isEmpty()) {
            throw new IncorrectOperationException("Cannot create import statement for default package.");
        }
        if (!PsiNameHelper.getInstance((Project)this.myManager.getProject()).isQualifiedName(packageName)) {
            throw new IncorrectOperationException("Incorrect package name: \"" + packageName + "\".");
        }
        PsiJavaFile aFile = this.createDummyJavaFile("import " + packageName + ".*;");
        PsiImportStatementBase statement2 = PsiElementFactoryImpl.extractImport(aFile, false);
        return (PsiImportStatement)CodeStyleManager.getInstance((Project)this.myManager.getProject()).reformat((PsiElement)statement2);
    }

    @NotNull
    public PsiDeclarationStatement createVariableDeclarationStatement(@NonNls @NotNull String name, @NotNull PsiType type, @Nullable PsiExpression initializer) throws IncorrectOperationException {
        return this.createVariableDeclarationStatement(name, type, initializer, null);
    }

    @NotNull
    public PsiDeclarationStatement createVariableDeclarationStatement(@NonNls @NotNull String name, @NotNull PsiType type, @Nullable PsiExpression initializer, @Nullable PsiElement context) throws IncorrectOperationException {
        if (!this.isIdentifier(name)) {
            throw new IncorrectOperationException("\"" + name + "\" is not an identifier.");
        }
        if (PsiType.NULL.equals((Object)type)) {
            throw new IncorrectOperationException("Cannot create variable with type \"null\".");
        }
        String text = "X " + name + (initializer != null ? " = x" : "") + ";";
        PsiDeclarationStatement statement2 = (PsiDeclarationStatement)this.createStatementFromText(text, context);
        PsiVariable variable = (PsiVariable)statement2.getDeclaredElements()[0];
        PsiElementFactoryImpl.replace((PsiElement)variable.getTypeElement(), (PsiElement)this.createTypeElement(type), text);
        boolean generateFinalLocals = JavaCodeStyleSettingsFacade.getInstance((Project)this.myManager.getProject()).isGenerateFinalLocals();
        PsiUtil.setModifierProperty((PsiModifierListOwner)variable, (String)"final", (boolean)generateFinalLocals);
        if (initializer != null) {
            PsiElementFactoryImpl.replace((PsiElement)variable.getInitializer(), (PsiElement)initializer, text);
        }
        GeneratedMarkerVisitor.markGenerated((PsiElement)statement2);
        return statement2;
    }

    private static void replace(@Nullable PsiElement original, @NotNull PsiElement replacement, @NotNull String message) {
        assert (original != null) : message;
        original.replace(replacement);
    }

    @NotNull
    public PsiDocTag createParamTag(@NotNull String parameterName, @NonNls String description) throws IncorrectOperationException {
        StringBuilder builder = new StringBuilder();
        builder.append(" * @param ");
        builder.append(parameterName);
        builder.append(" ");
        String[] strings = description.split("\\n");
        for (int i = 0; i < strings.length; ++i) {
            if (i > 0) {
                builder.append("\n * ");
            }
            builder.append(strings[i]);
        }
        return this.createDocTagFromText(builder.toString());
    }

    @Override
    @NotNull
    public PsiAnnotation createAnnotationFromText(@NotNull String annotationText, @Nullable PsiElement context) throws IncorrectOperationException {
        PsiAnnotation psiAnnotation = super.createAnnotationFromText(annotationText, context);
        GeneratedMarkerVisitor.markGenerated((PsiElement)psiAnnotation);
        return psiAnnotation;
    }

    @Override
    @NotNull
    public PsiCodeBlock createCodeBlockFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        PsiCodeBlock psiCodeBlock = super.createCodeBlockFromText(text, context);
        GeneratedMarkerVisitor.markGenerated((PsiElement)psiCodeBlock);
        return psiCodeBlock;
    }

    @Override
    @NotNull
    public PsiEnumConstant createEnumConstantFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        PsiEnumConstant enumConstant = super.createEnumConstantFromText(text, context);
        GeneratedMarkerVisitor.markGenerated((PsiElement)enumConstant);
        return enumConstant;
    }

    @Override
    @NotNull
    public PsiExpression createExpressionFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        PsiExpression expression = super.createExpressionFromText(text, context);
        GeneratedMarkerVisitor.markGenerated((PsiElement)expression);
        return expression;
    }

    @Override
    @NotNull
    public PsiField createFieldFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        PsiField psiField = super.createFieldFromText(text, context);
        GeneratedMarkerVisitor.markGenerated((PsiElement)psiField);
        return psiField;
    }

    @Override
    @NotNull
    public PsiParameter createParameterFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        PsiParameter parameter = super.createParameterFromText(text, context);
        GeneratedMarkerVisitor.markGenerated((PsiElement)parameter);
        return parameter;
    }

    @Override
    @NotNull
    public PsiStatement createStatementFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        PsiStatement statement2 = super.createStatementFromText(text, context);
        GeneratedMarkerVisitor.markGenerated((PsiElement)statement2);
        return statement2;
    }

    @Override
    @NotNull
    public PsiType createTypeFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        return this.createTypeInner(text, context, true);
    }

    @Override
    @NotNull
    public PsiTypeParameter createTypeParameterFromText(@NotNull String text, PsiElement context) throws IncorrectOperationException {
        PsiTypeParameter typeParameter = super.createTypeParameterFromText(text, context);
        GeneratedMarkerVisitor.markGenerated((PsiElement)typeParameter);
        return typeParameter;
    }

    @Override
    @NotNull
    public PsiMethod createMethodFromText(@NotNull String text, PsiElement context, LanguageLevel level) throws IncorrectOperationException {
        PsiMethod method = super.createMethodFromText(text, context, level);
        GeneratedMarkerVisitor.markGenerated((PsiElement)method);
        return method;
    }

    private static PsiImportStatementBase extractImport(PsiJavaFile aFile, boolean isStatic) {
        PsiImportStaticStatement[] statements;
        PsiImportList importList = aFile.getImportList();
        assert (importList != null) : aFile;
        Object[] objectArray = statements = isStatic ? importList.getImportStaticStatements() : importList.getImportStatements();
        assert (statements.length == 1) : aFile.getText();
        return statements[0];
    }

    @NotNull
    public PsiCatchSection createCatchSection(@NotNull PsiType exceptionType, @NotNull String exceptionName, @Nullable PsiElement context) throws IncorrectOperationException {
        if (!(exceptionType instanceof PsiClassType) && !(exceptionType instanceof PsiDisjunctionType)) {
            throw new IncorrectOperationException("Unexpected type:" + exceptionType);
        }
        String text = "catch (" + exceptionType.getCanonicalText(true) + " " + exceptionName + ") {}";
        DummyHolder holder = DummyHolderFactory.createHolder(this.myManager, new JavaDummyElement(text, CATCH_SECTION, PsiElementFactoryImpl.level(context)), context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiCatchSection)) {
            throw new IncorrectOperationException("Incorrect catch section '" + text + "'. Parsed element: " + element);
        }
        Project project2 = this.myManager.getProject();
        JavaPsiImplementationHelper helper = JavaPsiImplementationHelper.getInstance(project2);
        helper.setupCatchBlock(exceptionName, exceptionType, context, (PsiCatchSection)element);
        CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)project2);
        PsiCatchSection catchSection = (PsiCatchSection)styleManager.reformat(element);
        GeneratedMarkerVisitor.markGenerated((PsiElement)catchSection);
        return catchSection;
    }

    public boolean isValidClassName(@NotNull String name) {
        return this.isIdentifier(name);
    }

    public boolean isValidMethodName(@NotNull String name) {
        return this.isIdentifier(name);
    }

    public boolean isValidParameterName(@NotNull String name) {
        return this.isIdentifier(name);
    }

    public boolean isValidFieldName(@NotNull String name) {
        return this.isIdentifier(name);
    }

    public boolean isValidLocalVariableName(@NotNull String name) {
        return this.isIdentifier(name);
    }

    private boolean isIdentifier(@NotNull String name) {
        return PsiNameHelper.getInstance((Project)this.myManager.getProject()).isIdentifier(name);
    }
}

