/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.impl.JavaPsiFacadeEx;
import com.intellij.psi.impl.PsiConstantEvaluationHelperImpl;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.file.impl.JavaFileManager;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.JavaDummyHolder;
import com.intellij.psi.impl.source.JavaDummyHolderFactory;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaPsiFacadeImpl
extends JavaPsiFacadeEx {
    private static final Logger LOG = Logger.getInstance(JavaPsiFacadeImpl.class);
    private volatile PsiElementFinder[] myElementFinders;
    private final PsiConstantEvaluationHelper myConstantEvaluationHelper;
    private final ConcurrentMap<String, PsiPackage> myPackageCache = ContainerUtil.createConcurrentSoftValueMap();
    private final ConcurrentMap<GlobalSearchScope, Map<String, PsiClass>> myClassCache = ContainerUtil.createConcurrentWeakKeySoftValueMap();
    private final Project myProject;
    private final JavaFileManager myFileManager;

    public JavaPsiFacadeImpl(Project project2, PsiManager psiManager, JavaFileManager javaFileManager, MessageBus bus) {
        this.myProject = project2;
        this.myFileManager = javaFileManager;
        this.myConstantEvaluationHelper = new PsiConstantEvaluationHelperImpl();
        final PsiModificationTracker modificationTracker = psiManager.getModificationTracker();
        if (bus != null) {
            bus.connect().subscribe(PsiModificationTracker.TOPIC, (Object)new PsiModificationTracker.Listener(){
                private long lastTimeSeen = -1L;

                public void modificationCountChanged() {
                    JavaPsiFacadeImpl.this.myClassCache.clear();
                    long now = modificationTracker.getJavaStructureModificationCount();
                    if (this.lastTimeSeen != now) {
                        this.lastTimeSeen = now;
                        JavaPsiFacadeImpl.this.myPackageCache.clear();
                    }
                }
            });
        }
        DummyHolderFactory.setFactory(new JavaDummyHolderFactory());
    }

    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        PsiClass result;
        ProgressIndicatorProvider.checkCanceled();
        Map map = (Map)this.myClassCache.get(scope);
        if (map == null) {
            map = ContainerUtil.createConcurrentWeakValueMap();
            map = (Map)ConcurrencyUtil.cacheOrGet(this.myClassCache, (Object)scope, (Object)map);
        }
        if ((result = (PsiClass)map.get(qualifiedName)) == null && (result = this.doFindClass(qualifiedName, scope)) != null) {
            map.put(qualifiedName, result);
        }
        return result;
    }

    @Nullable
    private PsiClass doFindClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (this.shouldUseSlowResolve()) {
            PsiClass[] classes = this.findClassesInDumbMode(qualifiedName, scope);
            if (classes.length != 0) {
                return classes[0];
            }
            return null;
        }
        PsiElementFinder[] finders = this.finders();
        Condition<PsiClass> classesFilter = JavaPsiFacadeImpl.getFilterFromFinders(scope, finders);
        for (PsiElementFinder finder : finders) {
            PsiClass aClass = finder.findClass(qualifiedName, scope);
            if (aClass == null || classesFilter != null && !classesFilter.value((Object)aClass)) continue;
            return aClass;
        }
        return null;
    }

    @NotNull
    private PsiClass[] findClassesInDumbMode(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        String packageName = StringUtil.getPackageName((String)qualifiedName);
        PsiPackage pkg = this.findPackage(packageName);
        String className = StringUtil.getShortName((String)qualifiedName);
        if (pkg == null && packageName.length() < qualifiedName.length()) {
            PsiClass[] containingClasses = this.findClassesInDumbMode(packageName, scope);
            if (containingClasses.length == 1) {
                return PsiElementFinder.filterByName((String)className, (PsiClass[])containingClasses[0].getInnerClasses());
            }
            return PsiClass.EMPTY_ARRAY;
        }
        if (pkg == null) {
            return PsiClass.EMPTY_ARRAY;
        }
        return pkg.findClassByShortName(className, scope);
    }

    @NotNull
    public PsiClass[] findClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (this.shouldUseSlowResolve()) {
            return this.findClassesInDumbMode(qualifiedName, scope);
        }
        PsiElementFinder[] finders = this.finders();
        Condition<PsiClass> classesFilter = JavaPsiFacadeImpl.getFilterFromFinders(scope, finders);
        ArrayList result = null;
        for (PsiElementFinder finder : finders) {
            PsiClass[] finderClasses = finder.findClasses(qualifiedName, scope);
            if (finderClasses.length == 0) continue;
            if (result == null) {
                result = new ArrayList(finderClasses.length);
            }
            JavaPsiFacadeImpl.filterClassesAndAppend(finder, classesFilter, finderClasses, result);
        }
        return result == null || result.isEmpty() ? PsiClass.EMPTY_ARRAY : result.toArray(new PsiClass[result.size()]);
    }

    private static Condition<PsiClass> getFilterFromFinders(@NotNull GlobalSearchScope scope, @NotNull PsiElementFinder[] finders) {
        Condition filter = null;
        for (PsiElementFinder finder : finders) {
            Condition finderFilter = finder.getClassesFilter(scope);
            if (finderFilter == null) continue;
            filter = filter == null ? finderFilter : Conditions.and((Condition)filter, (Condition)finderFilter);
        }
        return filter;
    }

    private boolean shouldUseSlowResolve() {
        DumbService dumbService = DumbService.getInstance((Project)this.getProject());
        return dumbService.isDumb() && dumbService.isAlternativeResolveEnabled();
    }

    @NotNull
    private PsiElementFinder[] finders() {
        PsiElementFinder[] answer = this.myElementFinders;
        if (answer == null) {
            this.myElementFinders = answer = this.calcFinders();
        }
        return answer;
    }

    @NotNull
    protected PsiElementFinder[] calcFinders() {
        ArrayList elementFinders = new ArrayList();
        ContainerUtil.addAll(elementFinders, (Object[])this.myProject.getExtensions(PsiElementFinder.EP_NAME));
        return elementFinders.toArray(new PsiElementFinder[elementFinders.size()]);
    }

    @NotNull
    public PsiConstantEvaluationHelper getConstantEvaluationHelper() {
        return this.myConstantEvaluationHelper;
    }

    public PsiPackage findPackage(@NotNull String qualifiedName) {
        PsiPackage aPackage = (PsiPackage)this.myPackageCache.get(qualifiedName);
        if (aPackage != null) {
            return aPackage;
        }
        for (PsiElementFinder finder : this.filteredFinders()) {
            aPackage = finder.findPackage(qualifiedName);
            if (aPackage == null) continue;
            return (PsiPackage)ConcurrencyUtil.cacheOrGet(this.myPackageCache, (Object)qualifiedName, (Object)aPackage);
        }
        return null;
    }

    @NotNull
    private PsiElementFinder[] filteredFinders() {
        DumbService dumbService = DumbService.getInstance((Project)this.getProject());
        Object[] finders = this.finders();
        if (dumbService.isDumb()) {
            List list = dumbService.filterByDumbAwareness(finders);
            finders = list.toArray(new PsiElementFinder[list.size()]);
        }
        return finders;
    }

    @NotNull
    public PsiJavaParserFacade getParserFacade() {
        return this.getElementFactory();
    }

    @NotNull
    public PsiResolveHelper getResolveHelper() {
        return PsiResolveHelper.SERVICE.getInstance((Project)this.myProject);
    }

    @NotNull
    public PsiNameHelper getNameHelper() {
        return PsiNameHelper.getInstance((Project)this.myProject);
    }

    @NotNull
    public Set<String> getClassNames(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        THashSet result = new THashSet();
        for (PsiElementFinder finder : this.filteredFinders()) {
            result.addAll(finder.getClassNames(psiPackage, scope));
        }
        return result;
    }

    @NotNull
    public PsiClass[] getClasses(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        PsiElementFinder[] finders = this.filteredFinders();
        Condition<PsiClass> classesFilter = JavaPsiFacadeImpl.getFilterFromFinders(scope, finders);
        ArrayList result = null;
        for (PsiElementFinder finder : finders) {
            PsiClass[] classes = finder.getClasses(psiPackage, scope);
            if (classes.length == 0) continue;
            if (result == null) {
                result = new ArrayList(classes.length);
            }
            JavaPsiFacadeImpl.filterClassesAndAppend(finder, classesFilter, classes, result);
        }
        return result == null ? PsiClass.EMPTY_ARRAY : result.toArray(new PsiClass[result.size()]);
    }

    private static void filterClassesAndAppend(PsiElementFinder finder, @Nullable Condition<PsiClass> classesFilter, @NotNull PsiClass[] classes, @NotNull List<PsiClass> result) {
        for (PsiClass psiClass : classes) {
            if (psiClass == null) {
                LOG.error("Finder " + finder + " returned null PsiClass");
                continue;
            }
            if (classesFilter != null && !classesFilter.value((Object)psiClass)) continue;
            result.add(psiClass);
        }
    }

    @NotNull
    public PsiFile[] getPackageFiles(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        PsiDirectory[] directories;
        Condition filter = null;
        for (PsiElementFinder finder : this.filteredFinders()) {
            Condition finderFilter = finder.getPackageFilesFilter(psiPackage, scope);
            if (finderFilter == null) continue;
            filter = filter == null ? finderFilter : Conditions.and((Condition)filter, (Condition)finderFilter);
        }
        LinkedHashSet<PsiFile> result = new LinkedHashSet<PsiFile>();
        for (PsiDirectory psiDirectory : directories = psiPackage.getDirectories(scope)) {
            for (PsiFile file2 : psiDirectory.getFiles()) {
                if (filter != null && !filter.value((Object)file2)) continue;
                result.add(file2);
            }
        }
        for (PsiDirectory psiDirectory : this.filteredFinders()) {
            Collections.addAll(result, psiDirectory.getPackageFiles(psiPackage, scope));
        }
        return result.toArray(new PsiFile[result.size()]);
    }

    public boolean processPackageDirectories(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope, @NotNull Processor<PsiDirectory> consumer, boolean includeLibrarySources) {
        for (PsiElementFinder finder : this.filteredFinders()) {
            if (finder.processPackageDirectories(psiPackage, scope, consumer, includeLibrarySources)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public PsiPackage[] getSubPackages(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        LinkedHashMap<String, PsiPackage> result = new LinkedHashMap<String, PsiPackage>();
        for (PsiElementFinder finder : this.filteredFinders()) {
            PsiPackage[] packages;
            for (PsiPackage aPackage : packages = finder.getSubPackages(psiPackage, scope)) {
                if (result.get(aPackage.getName()) != null) continue;
                result.put(aPackage.getName(), aPackage);
            }
        }
        return result.values().toArray(new PsiPackage[result.size()]);
    }

    public boolean isPartOfPackagePrefix(@NotNull String packageName) {
        Collection<String> packagePrefixes = this.myFileManager.getNonTrivialPackagePrefixes();
        for (String subpackageName : packagePrefixes) {
            if (!PsiNameHelper.isSubpackageOf((String)subpackageName, (String)packageName)) continue;
            return true;
        }
        return false;
    }

    public boolean isInPackage(@NotNull PsiElement element, @NotNull PsiPackage aPackage) {
        PsiFile file2 = FileContextUtil.getContextFile(element);
        if (file2 instanceof JavaDummyHolder) {
            return ((JavaDummyHolder)file2).isInPackage(aPackage);
        }
        if (file2 instanceof PsiJavaFile) {
            String packageName = ((PsiJavaFile)file2).getPackageName();
            return packageName.equals(aPackage.getQualifiedName());
        }
        return false;
    }

    public boolean arePackagesTheSame(@NotNull PsiElement element1, @NotNull PsiElement element2) {
        PsiFile file2;
        PsiFile file1 = FileContextUtil.getContextFile(element1);
        if (Comparing.equal((Object)file1, (Object)(file2 = FileContextUtil.getContextFile(element2)))) {
            return true;
        }
        if (file1 instanceof JavaDummyHolder && file2 instanceof JavaDummyHolder) {
            return true;
        }
        if (file1 instanceof JavaDummyHolder || file2 instanceof JavaDummyHolder) {
            JavaDummyHolder dummyHolder = (JavaDummyHolder)(file1 instanceof JavaDummyHolder ? file1 : file2);
            PsiFile other = file1 instanceof JavaDummyHolder ? file2 : file1;
            return dummyHolder.isSamePackage((PsiElement)other);
        }
        if (!(file1 instanceof PsiClassOwner)) {
            return false;
        }
        if (!(file2 instanceof PsiClassOwner)) {
            return false;
        }
        String package1 = ((PsiClassOwner)file1).getPackageName();
        String package2 = ((PsiClassOwner)file2).getPackageName();
        return Comparing.equal((String)package1, (String)package2);
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public PsiElementFactory getElementFactory() {
        return PsiElementFactory.SERVICE.getInstance((Project)this.myProject);
    }

    @Override
    public void setAssertOnFileLoadingFilter(@NotNull VirtualFileFilter filter, Disposable parentDisposable) {
        ((PsiManagerImpl)PsiManager.getInstance((Project)this.myProject)).setAssertOnFileLoadingFilter(filter, parentDisposable);
    }

    public void clearFindersCache() {
        this.myElementFinders = null;
    }
}

