/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.ConstantExpressionVisitor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaConstantExpressionEvaluator
extends JavaRecursiveElementWalkingVisitor {
    private final Factory<ConcurrentMap<PsiElement, Object>> myMapFactory;
    private final Project myProject;
    private static final Key<CachedValue<ConcurrentMap<PsiElement, Object>>> CONSTANT_VALUE_WO_OVERFLOW_MAP_KEY = Key.create((String)"CONSTANT_VALUE_WO_OVERFLOW_MAP_KEY");
    private static final Key<CachedValue<ConcurrentMap<PsiElement, Object>>> CONSTANT_VALUE_WITH_OVERFLOW_MAP_KEY = Key.create((String)"CONSTANT_VALUE_WITH_OVERFLOW_MAP_KEY");
    private static final Object NO_VALUE = ObjectUtils.NULL;
    private final ConstantExpressionVisitor myConstantExpressionVisitor;
    private static final CachedValueProvider<ConcurrentMap<PsiElement, Object>> PROVIDER = new CachedValueProvider<ConcurrentMap<PsiElement, Object>>(){

        public CachedValueProvider.Result<ConcurrentMap<PsiElement, Object>> compute() {
            ConcurrentMap value = ContainerUtil.createConcurrentSoftMap();
            return CachedValueProvider.Result.create((Object)value, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        }
    };

    private JavaConstantExpressionEvaluator(Set<PsiVariable> visitedVars, final boolean throwExceptionOnOverflow, @NotNull Project project2, final PsiConstantEvaluationHelper.AuxEvaluator auxEvaluator) {
        this.myMapFactory = auxEvaluator == null ? new Factory<ConcurrentMap<PsiElement, Object>>(){

            public ConcurrentMap<PsiElement, Object> create() {
                Key key = throwExceptionOnOverflow ? CONSTANT_VALUE_WITH_OVERFLOW_MAP_KEY : CONSTANT_VALUE_WO_OVERFLOW_MAP_KEY;
                return (ConcurrentMap)CachedValuesManager.getManager((Project)JavaConstantExpressionEvaluator.this.myProject).getCachedValue((UserDataHolder)JavaConstantExpressionEvaluator.this.myProject, key, PROVIDER, false);
            }
        } : new Factory<ConcurrentMap<PsiElement, Object>>(){

            public ConcurrentMap<PsiElement, Object> create() {
                return auxEvaluator.getCacheMap(throwExceptionOnOverflow);
            }
        };
        this.myProject = project2;
        this.myConstantExpressionVisitor = new ConstantExpressionVisitor(visitedVars, throwExceptionOnOverflow, auxEvaluator);
    }

    protected void elementFinished(@NotNull PsiElement element) {
        Object value = this.getCached(element);
        if (value == null) {
            Object result = this.myConstantExpressionVisitor.handle(element);
            this.cache(element, result);
        }
    }

    public void visitElement(PsiElement element) {
        Object value = this.getCached(element);
        if (value == null) {
            super.visitElement(element);
        } else {
            ConstantExpressionVisitor.store(element, value == NO_VALUE ? null : value);
        }
    }

    private Object getCached(@NotNull PsiElement element) {
        return this.map().get(element);
    }

    private Object cache(@NotNull PsiElement element, @Nullable Object value) {
        value = ConcurrencyUtil.cacheOrGet(this.map(), (Object)element, (Object)(value == null ? NO_VALUE : value));
        if (value == NO_VALUE) {
            value = null;
        }
        return value;
    }

    @NotNull
    private ConcurrentMap<PsiElement, Object> map() {
        return (ConcurrentMap)this.myMapFactory.create();
    }

    public static Object computeConstantExpression(@Nullable PsiExpression expression, @Nullable Set<PsiVariable> visitedVars, boolean throwExceptionOnOverflow) {
        return JavaConstantExpressionEvaluator.computeConstantExpression(expression, visitedVars, throwExceptionOnOverflow, null);
    }

    public static Object computeConstantExpression(@Nullable PsiExpression expression, @Nullable Set<PsiVariable> visitedVars, boolean throwExceptionOnOverflow, PsiConstantEvaluationHelper.AuxEvaluator auxEvaluator) {
        if (expression == null) {
            return null;
        }
        if (expression instanceof PsiLiteralExpression) {
            return ((PsiLiteralExpression)expression).getValue();
        }
        JavaConstantExpressionEvaluator evaluator = new JavaConstantExpressionEvaluator(visitedVars, throwExceptionOnOverflow, expression.getProject(), auxEvaluator);
        if (expression instanceof PsiCompiledElement) {
            if (expression instanceof PsiPrefixExpression) {
                PsiExpression operand = ((PsiPrefixExpression)expression).getOperand();
                if (operand == null) {
                    return null;
                }
                Object value = evaluator.myConstantExpressionVisitor.handle((PsiElement)operand);
                ConstantExpressionVisitor.store((PsiElement)operand, value);
            }
            return evaluator.myConstantExpressionVisitor.handle((PsiElement)expression);
        }
        expression.accept((PsiElementVisitor)evaluator);
        Object cached = evaluator.getCached((PsiElement)expression);
        return cached == NO_VALUE ? null : cached;
    }

    public static Object computeConstantExpression(@Nullable PsiExpression expression, boolean throwExceptionOnOverflow) {
        return JavaConstantExpressionEvaluator.computeConstantExpression(expression, null, throwExceptionOnOverflow);
    }
}

