/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.impl.InheritanceImplUtil;
import com.intellij.psi.impl.ScopedClassHierarchy;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceBound;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.JavaClassSupers;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaClassSupersImpl
extends JavaClassSupers {
    @Nullable
    public PsiSubstitutor getSuperClassSubstitutor(@NotNull PsiClass superClass, @NotNull PsiClass derivedClass, @NotNull GlobalSearchScope scope, @NotNull PsiSubstitutor derivedSubstitutor) {
        PsiType lowerBound;
        if (InheritanceImplUtil.hasObjectQualifiedName(superClass)) {
            return PsiSubstitutor.EMPTY;
        }
        List<PsiType> bounds = null;
        if (superClass instanceof InferenceVariable) {
            bounds = ((InferenceVariable)superClass).getBounds(InferenceBound.LOWER);
        } else if (superClass instanceof PsiTypeParameter && (lowerBound = (PsiType)superClass.getUserData(InferenceSession.LOWER_BOUND)) != null) {
            bounds = Collections.singletonList(lowerBound);
        }
        if (bounds != null) {
            for (PsiType lowerBound2 : bounds) {
                PsiSubstitutor substitutor;
                if (lowerBound2 == null || (substitutor = JavaClassSupersImpl.processLowerBound(lowerBound2, derivedClass, scope, derivedSubstitutor)) == null) continue;
                return substitutor;
            }
        }
        return derivedClass instanceof PsiTypeParameter ? JavaClassSupersImpl.processTypeParameter((PsiTypeParameter)derivedClass, scope, superClass, (Set<PsiTypeParameter>)ContainerUtil.newTroveSet(), derivedSubstitutor) : JavaClassSupersImpl.getSuperSubstitutorWithCaching(superClass, derivedClass, scope, derivedSubstitutor);
    }

    private static PsiSubstitutor processLowerBound(@NotNull PsiType lowerBound, @NotNull PsiClass derivedClass, @NotNull GlobalSearchScope scope, @NotNull PsiSubstitutor derivedSubstitutor) {
        if (lowerBound instanceof PsiClassType) {
            PsiClassType.ClassResolveResult result = ((PsiClassType)lowerBound).resolveGenerics();
            PsiClass boundClass = result.getElement();
            if (boundClass != null) {
                if (boundClass.equals(derivedClass)) {
                    return derivedSubstitutor;
                }
                PsiSubstitutor substitutor = JavaClassSupersImpl.getSuperSubstitutorWithCaching(boundClass, derivedClass, scope, result.getSubstitutor());
                if (substitutor != null) {
                    return JavaClassSupersImpl.composeSubstitutors(derivedSubstitutor, substitutor, boundClass);
                }
            }
        } else if (lowerBound instanceof PsiIntersectionType) {
            for (PsiType bound : ((PsiIntersectionType)lowerBound).getConjuncts()) {
                PsiSubstitutor substitutor = JavaClassSupersImpl.processLowerBound(bound, derivedClass, scope, derivedSubstitutor);
                if (substitutor == null) continue;
                return substitutor;
            }
        }
        return null;
    }

    @Nullable
    private static PsiSubstitutor getSuperSubstitutorWithCaching(@NotNull PsiClass superClass, @NotNull PsiClass derivedClass, @NotNull GlobalSearchScope resolveScope, @NotNull PsiSubstitutor derivedSubstitutor) {
        PsiSubstitutor substitutor = ScopedClassHierarchy.getSuperClassSubstitutor(derivedClass, resolveScope, superClass);
        if (substitutor == null) {
            return null;
        }
        if (PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)derivedClass, (PsiSubstitutor)derivedSubstitutor)) {
            return JavaClassSupersImpl.createRawSubstitutor(superClass);
        }
        return JavaClassSupersImpl.composeSubstitutors(derivedSubstitutor, substitutor, superClass);
    }

    @NotNull
    static PsiSubstitutor createRawSubstitutor(@NotNull PsiClass superClass) {
        return JavaPsiFacade.getElementFactory((Project)superClass.getProject()).createRawSubstitutor((PsiTypeParameterListOwner)superClass);
    }

    @NotNull
    private static PsiSubstitutor composeSubstitutors(PsiSubstitutor outer, PsiSubstitutor inner, PsiClass onClass) {
        PsiSubstitutor answer = PsiSubstitutor.EMPTY;
        Map outerMap = outer.getSubstitutionMap();
        Map innerMap = inner.getSubstitutionMap();
        for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)onClass)) {
            if (!outerMap.containsKey(parameter) && !innerMap.containsKey(parameter)) continue;
            answer = answer.put(parameter, outer.substitute(inner.substitute(parameter)));
        }
        return answer;
    }

    @Nullable
    private static PsiSubstitutor processTypeParameter(PsiTypeParameter parameter, GlobalSearchScope scope, PsiClass superClass, Set<PsiTypeParameter> visited, PsiSubstitutor derivedSubstitutor) {
        if (parameter.getManager().areElementsEquivalent((PsiElement)parameter, (PsiElement)superClass)) {
            return PsiSubstitutor.EMPTY;
        }
        if (!visited.add(parameter)) {
            return null;
        }
        for (PsiClassType type : parameter.getExtendsListTypes()) {
            PsiSubstitutor answer;
            PsiClassType.ClassResolveResult result = type.resolveGenerics();
            PsiClass psiClass = result.getElement();
            if (psiClass == null) continue;
            if (psiClass instanceof PsiTypeParameter) {
                answer = JavaClassSupersImpl.processTypeParameter((PsiTypeParameter)psiClass, scope, superClass, visited, derivedSubstitutor);
                if (answer == null) continue;
                return answer;
            }
            answer = JavaClassSupersImpl.getSuperSubstitutorWithCaching(superClass, psiClass, scope, result.getSubstitutor());
            if (answer == null) continue;
            return JavaClassSupersImpl.composeSubstitutors(derivedSubstitutor, answer, superClass);
        }
        return null;
    }
}

