/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.xml;

import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.ReadOnlyBlockContainer;
import com.intellij.formatting.Spacing;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.formatter.xml.AbstractSyntheticBlock;
import com.intellij.psi.formatter.xml.AbstractXmlBlock;
import com.intellij.psi.formatter.xml.AnotherLanguageBlockWrapper;
import com.intellij.psi.formatter.xml.ReadOnlyBlock;
import com.intellij.psi.formatter.xml.XmlBlock;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SyntheticBlock
extends AbstractSyntheticBlock
implements Block,
ReadOnlyBlockContainer {
    private final List<Block> mySubBlocks;
    private final Indent myChildIndent;

    public SyntheticBlock(List<Block> subBlocks, Block parent, Indent indent, XmlFormattingPolicy policy, Indent childIndent) {
        super(subBlocks, parent, policy, indent);
        this.mySubBlocks = subBlocks;
        this.myChildIndent = childIndent;
    }

    @NotNull
    public TextRange getTextRange() {
        return SyntheticBlock.calculateTextRange(this.mySubBlocks);
    }

    @NotNull
    public List<Block> getSubBlocks() {
        return this.mySubBlocks;
    }

    public Spacing getSpacing(Block child1, @NotNull Block child2) {
        boolean saveSpacesBetweenTagAndText;
        PsiElement psi1;
        ASTNode prev;
        if (child1 instanceof ReadOnlyBlock || child2 instanceof ReadOnlyBlock) {
            return Spacing.getReadOnlySpacing();
        }
        if (!(child1 instanceof AbstractXmlBlock) || !(child2 instanceof AbstractXmlBlock)) {
            return null;
        }
        ASTNode node1 = ((AbstractBlock)child1).getNode();
        ASTNode node2 = ((AbstractBlock)child2).getNode();
        IElementType type1 = node1.getElementType();
        IElementType type2 = node2.getElementType();
        if (type2 == XmlElementType.XML_COMMENT) {
            return Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)0, (boolean)true, (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if (type1 == XmlElementType.XML_COMMENT && (prev = node1.getTreePrev()) != null) {
            node1 = prev;
            type1 = prev.getElementType();
        }
        boolean firstIsText = this.isTextFragment(node1);
        boolean secondIsText = this.isTextFragment(node2);
        if (((AbstractXmlBlock)child1).isPreserveSpace() && ((AbstractXmlBlock)child2).isPreserveSpace()) {
            return Spacing.getReadOnlySpacing();
        }
        if (type1 == XmlTokenType.XML_CDATA_START || type2 == XmlTokenType.XML_CDATA_END) {
            if (this.myXmlFormattingPolicy.getKeepWhiteSpacesInsideCDATA()) {
                return Spacing.getReadOnlySpacing();
            }
            if (type1 == XmlTokenType.XML_CDATA_START && type2 == XmlTokenType.XML_CDATA_END) {
                return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaks(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
            }
            if (type1 == XmlTokenType.XML_CDATA_START && child2 instanceof AnotherLanguageBlockWrapper || type2 == XmlTokenType.XML_CDATA_END && child1 instanceof AnotherLanguageBlockWrapper) {
                return Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaks(), (int)0);
            }
        }
        boolean firstIsTag = node1.getPsi() instanceof XmlTag && !firstIsText;
        boolean secondIsTag = node2.getPsi() instanceof XmlTag && !secondIsText;
        boolean firstIsEntityRef = this.isEntityRef(node1);
        boolean secondIsEntityRef = this.isEntityRef(node2);
        if (this.isSpaceInText(firstIsTag, secondIsTag, firstIsText, secondIsText) && this.keepWhiteSpaces()) {
            return Spacing.getReadOnlySpacing();
        }
        if (firstIsEntityRef || secondIsEntityRef) {
            return Spacing.createSafeSpacing((boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaks(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if (type1 == XmlElementType.XML_ATTRIBUTE && (type2 == XmlTokenType.XML_TAG_END || type2 == XmlTokenType.XML_EMPTY_ELEMENT_END) && (psi1 = node1.getPsi()) instanceof XmlAttribute && this.myXmlFormattingPolicy.insertLineBreakAfterLastAttribute((XmlAttribute)psi1)) {
            return Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaks(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if (type2 == XmlTokenType.XML_EMPTY_ELEMENT_END && this.myXmlFormattingPolicy.addSpaceIntoEmptyTag()) {
            return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaks(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if (secondIsTag && this.myXmlFormattingPolicy.keepWhiteSpacesInsideTag((XmlTag)node2.getPsi()) && node2.textContains('\n')) {
            return Spacing.getReadOnlySpacing();
        }
        if (SyntheticBlock.isXmlTagName(type1, type2)) {
            int spaces = this.shouldAddSpaceAroundTagName(node1, node2) ? 1 : 0;
            return Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaks(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if (type2 == XmlElementType.XML_ATTRIBUTE) {
            int minLineFeeds = 0;
            if (type1 == XmlTokenType.XML_NAME) {
                PsiElement psi2 = node2.getPsi();
                minLineFeeds = psi2 instanceof XmlAttribute && this.myXmlFormattingPolicy.insertLineBreakBeforeFirstAttribute((XmlAttribute)psi2) ? 1 : 0;
            }
            return Spacing.createSpacing((int)1, (int)1, (int)minLineFeeds, (boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaks(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if (((AbstractXmlBlock)child1).isTextElement() && ((AbstractXmlBlock)child2).isTextElement()) {
            return Spacing.createSafeSpacing((boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaksInText(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if (firstIsTag && this.insertLineFeedAfter((XmlTag)node1.getPsi())) {
            return Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)true, (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if ((firstIsText || firstIsTag) && secondIsTag) {
            if (((AbstractXmlBlock)child2).insertLineBreakBeforeTag()) {
                return Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)(((AbstractXmlBlock)child2).getBlankLinesBeforeTag() + 1), (boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaks(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
            }
            if (((AbstractXmlBlock)child2).removeLineBreakBeforeTag()) {
                return Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)0, (boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaks(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
            }
        }
        boolean bl = saveSpacesBetweenTagAndText = this.myXmlFormattingPolicy.shouldSaveSpacesBetweenTagAndText() && child1.getTextRange().getEndOffset() < child2.getTextRange().getStartOffset();
        if (firstIsTag && secondIsText) {
            if (((AbstractXmlBlock)child1).isTextElement() || saveSpacesBetweenTagAndText) {
                return Spacing.createSafeSpacing((boolean)true, (int)this.myXmlFormattingPolicy.getKeepBlankLines());
            }
            return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)true, (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if (firstIsText && secondIsTag) {
            if (((AbstractXmlBlock)child2).isTextElement() || saveSpacesBetweenTagAndText) {
                return Spacing.createSafeSpacing((boolean)true, (int)this.myXmlFormattingPolicy.getKeepBlankLines());
            }
            return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)true, (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if (firstIsTag && secondIsTag) {
            return Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)0, (boolean)true, (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        return Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)0, (boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaksInText(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
    }

    private boolean isEntityRef(ASTNode node) {
        return node.getElementType() == XmlElementType.XML_ENTITY_REF;
    }

    private boolean shouldAddSpaceAroundTagName(ASTNode node1, ASTNode node2) {
        if (node1.getElementType() == XmlTokenType.XML_START_TAG_START && node1.textContains('%')) {
            return true;
        }
        if (node2.getElementType() == XmlTokenType.XML_EMPTY_ELEMENT_END && node2.textContains('%')) {
            return true;
        }
        return this.myXmlFormattingPolicy.getShouldAddSpaceAroundTagName();
    }

    private boolean isSpaceInText(boolean firstIsTag, boolean secondIsTag, boolean firstIsText, boolean secondIsText) {
        return firstIsText && secondIsText || firstIsTag && secondIsTag || firstIsTag && secondIsText || firstIsText && secondIsTag;
    }

    private boolean keepWhiteSpaces() {
        return this.myXmlFormattingPolicy.keepWhiteSpacesInsideTag(this.getTag()) || this.myXmlFormattingPolicy.getShouldKeepWhiteSpaces();
    }

    protected boolean isTextFragment(ASTNode node) {
        ASTNode parent = node.getTreeParent();
        return parent != null && parent.getElementType() == XmlElementType.XML_TEXT || node.getElementType() == XmlTokenType.XML_DATA_CHARACTERS;
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        Block prevBlock;
        if (this.isOuterLanguageBlock()) {
            return ChildAttributes.DELEGATE_TO_NEXT_CHILD;
        }
        List<Block> subBlocks = this.getSubBlocks();
        int prevBlockIndex = newChildIndex - 1;
        if (prevBlockIndex >= 0 && prevBlockIndex < subBlocks.size() && this.isAttributeBlock(prevBlock = subBlocks.get(newChildIndex - 1))) {
            return new ChildAttributes(this.myChildIndent, prevBlock.getAlignment());
        }
        return new ChildAttributes(this.myChildIndent, null);
    }

    private boolean isAttributeBlock(Block block) {
        if (block instanceof XmlBlock) {
            return ((XmlBlock)block).getNode().getElementType() == XmlElementType.XML_ATTRIBUTE;
        }
        return false;
    }

    @Override
    public boolean isIncomplete() {
        return this.getSubBlocks().get(this.getSubBlocks().size() - 1).isIncomplete();
    }

    public boolean endsWithAttribute() {
        return this.isAttributeBlock(this.getSubBlocks().get(this.getSubBlocks().size() - 1));
    }

    public Indent getChildIndent() {
        return this.myChildIndent;
    }
}

