/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.impl.source.codeStyle.ShiftIndentInsideHelper;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LeafBlock
implements ASTBlock {
    private int myStartOffset = -1;
    private final ASTNode myNode;
    private final Wrap myWrap;
    private final Alignment myAlignment;
    private static final ArrayList<Block> EMPTY_SUB_BLOCKS = new ArrayList();
    private final Indent myIndent;

    public LeafBlock(ASTNode node, Wrap wrap, Alignment alignment, Indent indent) {
        this.myNode = node;
        this.myWrap = wrap;
        this.myAlignment = alignment;
        this.myIndent = indent;
    }

    public ASTNode getNode() {
        return this.myNode;
    }

    @NotNull
    public TextRange getTextRange() {
        if (this.myStartOffset != -1) {
            return new TextRange(this.myStartOffset, this.myStartOffset + this.myNode.getTextLength());
        }
        return this.myNode.getTextRange();
    }

    @NotNull
    public List<Block> getSubBlocks() {
        return EMPTY_SUB_BLOCKS;
    }

    public Wrap getWrap() {
        return this.myWrap;
    }

    public Indent getIndent() {
        return this.myIndent;
    }

    public Alignment getAlignment() {
        return this.myAlignment;
    }

    public Spacing getSpacing(Block child1, @NotNull Block child2) {
        return null;
    }

    public ASTNode getTreeNode() {
        return this.myNode;
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        return new ChildAttributes(this.getIndent(), null);
    }

    public boolean isIncomplete() {
        return false;
    }

    public boolean isLeaf() {
        return ShiftIndentInsideHelper.mayShiftIndentInside(this.myNode);
    }

    public void setStartOffset(int startOffset) {
        this.myStartOffset = startOffset;
    }
}

