/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.openapi.editor.DefaultLineWrapPositionStrategy;
import com.intellij.openapi.editor.Document;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

public class JavaLineWrapPositionStrategy
extends DefaultLineWrapPositionStrategy {
    protected boolean canUseOffset(@NotNull Document document, int offset, boolean virtual) {
        CharSequence chars = document.getCharsSequence();
        char charAtOffset = chars.charAt(offset);
        if (charAtOffset == '.' && (offset > 0 && chars.charAt(offset - 1) == '.' || offset + 1 < chars.length() && chars.charAt(offset + 1) == '.')) {
            return false;
        }
        return !JavaLineWrapPositionStrategy.isInsideJDLinkTag(document, offset) && !JavaLineWrapPositionStrategy.isInsideHrefTag(document, offset);
    }

    private static boolean isInsideHrefTag(Document document, int offset) {
        return JavaLineWrapPositionStrategy.isInsideTag(document, offset, "<a", ">");
    }

    private static boolean isInsideJDLinkTag(Document document, int offset) {
        return JavaLineWrapPositionStrategy.isInsideTag(document, offset, "{@link", "}");
    }

    private static boolean isInsideTag(Document document, int offset, String tagStart, String tagEnd) {
        int offsetInChunk;
        CharSequence textChunkAroundOffset;
        int tagStartIndex;
        CharSequence sequence = document.getCharsSequence();
        int lineNumber = document.getLineNumber(offset);
        int lineStartOffset = document.getLineStartOffset(lineNumber);
        int lineEndOffset = document.getLineEndOffset(lineNumber);
        int searchStartOffset = lineStartOffset;
        int searchEndOffset = lineEndOffset;
        if (lineEndOffset - lineStartOffset > 200) {
            searchStartOffset = Math.max(offset - 100, lineStartOffset);
            searchEndOffset = Math.min(offset + 100, lineEndOffset);
        }
        if ((tagStartIndex = CharArrayUtil.lastIndexOf((CharSequence)(textChunkAroundOffset = sequence.subSequence(searchStartOffset, searchEndOffset)), (String)tagStart, (int)(offsetInChunk = offset - searchStartOffset))) > 0) {
            int nearestTagEndIndex = CharArrayUtil.indexOf((CharSequence)textChunkAroundOffset, (CharSequence)tagEnd, (int)tagStartIndex);
            return nearestTagEndIndex > offsetInChunk;
        }
        return false;
    }
}

