/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.tree.IElementType;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JavaFormatterUtil {
    private static final Set<IElementType> ASSIGNMENT_ELEMENT_TYPES = new HashSet<IElementType>(Arrays.asList(JavaElementType.ASSIGNMENT_EXPRESSION, JavaElementType.LOCAL_VARIABLE, JavaElementType.FIELD));

    private JavaFormatterUtil() {
    }

    public static boolean isAssignment(ASTNode node) {
        return ASSIGNMENT_ELEMENT_TYPES.contains(node.getElementType());
    }

    public static boolean areSamePriorityBinaryExpressions(ASTNode node1, ASTNode node2) {
        if (node1 == null || node2 == null) {
            return false;
        }
        if (!(node1 instanceof PsiPolyadicExpression) || !(node2 instanceof PsiPolyadicExpression)) {
            return false;
        }
        PsiPolyadicExpression expression1 = (PsiPolyadicExpression)node1;
        PsiPolyadicExpression expression2 = (PsiPolyadicExpression)node2;
        return expression1.getOperationTokenType() == expression2.getOperationTokenType();
    }

    public static boolean hasMultilineArguments(@NotNull PsiExpression[] arguments) {
        for (PsiExpression argument : arguments) {
            ASTNode node = argument.getNode();
            if (!node.textContains('\n')) continue;
            return true;
        }
        return false;
    }

    public static boolean isMultilineExceptArguments(@NotNull PsiExpression[] arguments) {
        for (PsiExpression argument : arguments) {
            ASTNode beforeArgument = argument.getNode().getTreePrev();
            if (!JavaFormatterUtil.isWhiteSpaceWithLineFeed(beforeArgument)) continue;
            return true;
        }
        PsiExpression lastArgument = arguments[arguments.length - 1];
        ASTNode afterLastArgument = lastArgument.getNode().getTreeNext();
        return JavaFormatterUtil.isWhiteSpaceWithLineFeed(afterLastArgument);
    }

    private static boolean isWhiteSpaceWithLineFeed(@NotNull ASTNode node) {
        return node instanceof PsiWhiteSpace && node.textContains('\n');
    }

    @NotNull
    public static WrapType getWrapType(int wrap) {
        switch (wrap) {
            case 2: {
                return WrapType.ALWAYS;
            }
            case 1: {
                return WrapType.NORMAL;
            }
            case 0: {
                return WrapType.NONE;
            }
        }
        return WrapType.CHOP_DOWN_IF_LONG;
    }
}

