/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.alignment.AlignmentStrategy;
import com.intellij.lang.ASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.java.AbstractJavaBlock;
import com.intellij.psi.formatter.java.LeafBlock;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.StdTokenSets;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class BlockContainingJavaBlock
extends AbstractJavaBlock {
    private static final TokenSet TYPES_OF_STATEMENTS_WITH_OPTIONAL_BRACES = TokenSet.create((IElementType[])new IElementType[]{JavaElementType.IF_STATEMENT, JavaElementType.WHILE_STATEMENT, JavaElementType.FOR_STATEMENT});
    private static final int BEFORE_FIRST = 0;
    private static final int BEFORE_BLOCK = 1;
    private static final int AFTER_ELSE = 2;
    private final List<Indent> myIndentsBefore = new ArrayList<Indent>();

    public BlockContainingJavaBlock(ASTNode node, Wrap wrap, Alignment alignment, Indent indent, CommonCodeStyleSettings settings, JavaCodeStyleSettings javaSettings) {
        super(node, wrap, alignment, indent, settings, javaSettings);
    }

    public BlockContainingJavaBlock(ASTNode child, Indent indent, AlignmentStrategy strategy, CommonCodeStyleSettings settings, JavaCodeStyleSettings javaSettings) {
        super(child, null, strategy, indent, settings, javaSettings);
    }

    @Override
    protected List<Block> buildChildren() {
        ArrayList<Block> result = new ArrayList<Block>();
        Alignment childAlignment = this.createChildAlignment();
        Wrap childWrap = this.createChildWrap();
        this.buildChildren(result, childAlignment, childWrap);
        for (Block block : result) {
            if (!(block instanceof AbstractJavaBlock)) continue;
            ((AbstractJavaBlock)block).setParentBlock(this);
        }
        return result;
    }

    private void buildChildren(ArrayList<Block> result, Alignment childAlignment, Wrap childWrap) {
        ASTNode child = this.myNode.getFirstChildNode();
        ASTNode prevChild = null;
        int state = 0;
        while (child != null) {
            if (!FormatterUtil.containsWhiteSpacesOnly(child) && child.getTextLength() > 0) {
                Indent indent = this.calcIndent(child, state);
                this.myIndentsBefore.add(this.calcIndentBefore(child, state));
                state = BlockContainingJavaBlock.calcNewState(child, state);
                if (prevChild != null && this.myNode.getElementType() == JavaElementType.METHOD && ElementType.JAVA_COMMENT_BIT_SET.contains(prevChild.getElementType()) && !ElementType.JAVA_COMMENT_BIT_SET.contains(child.getElementType())) {
                    prevChild = child;
                    child = this.composeCodeBlock(result, child, Indent.getNoneIndent(), 0, null);
                } else {
                    prevChild = child;
                    Alignment simpleMethodBraceAlignment = this.myAlignmentStrategy.getAlignment(child.getElementType());
                    Alignment toUse = childAlignment != null ? childAlignment : simpleMethodBraceAlignment;
                    child = this.processChild(result, child, toUse, childWrap, indent);
                }
                for (int i = this.myIndentsBefore.size(); i < result.size(); ++i) {
                    this.myIndentsBefore.add(Indent.getContinuationIndent((boolean)this.myIndentSettings.USE_RELATIVE_INDENTS));
                }
            }
            if (child == null) continue;
            child = child.getTreeNext();
        }
    }

    private static int calcNewState(ASTNode child, int state) {
        if (state == 0) {
            if (child.getElementType() == JavaTokenType.ELSE_KEYWORD) {
                return 2;
            }
            if (StdTokenSets.COMMENT_BIT_SET.contains(child.getElementType())) {
                return 0;
            }
            if (child.getElementType() == JavaElementType.CATCH_SECTION) {
                return 0;
            }
        } else if (state == 1) {
            if (child.getElementType() == JavaTokenType.ELSE_KEYWORD) {
                return 2;
            }
            if (child.getElementType() == JavaElementType.BLOCK_STATEMENT) {
                return 0;
            }
            if (child.getElementType() == JavaElementType.CODE_BLOCK) {
                return 0;
            }
        }
        return 1;
    }

    private Indent calcIndent(ASTNode child, int state) {
        if (state == 2 && child.getElementType() == JavaElementType.IF_STATEMENT) {
            if (this.mySettings.SPECIAL_ELSE_IF_TREATMENT) {
                return Indent.getNoneIndent();
            }
            return this.getCodeBlockInternalIndent(1);
        }
        if (BlockContainingJavaBlock.isSimpleStatement(child)) {
            return BlockContainingJavaBlock.createNormalIndent(1);
        }
        if (child.getElementType() == JavaTokenType.ELSE_KEYWORD) {
            return Indent.getNoneIndent();
        }
        if (state == 0 || child.getElementType() == JavaTokenType.WHILE_KEYWORD) {
            return Indent.getNoneIndent();
        }
        if (BlockContainingJavaBlock.isPartOfCodeBlock(child)) {
            return this.getCodeBlockExternalIndent();
        }
        if (BlockContainingJavaBlock.isSimpleStatement(child) || StdTokenSets.COMMENT_BIT_SET.contains(child.getElementType())) {
            return this.getCodeBlockInternalIndent(1);
        }
        if (BlockContainingJavaBlock.isNodeParentMethod(child) && (child.getElementType() == JavaElementType.TYPE || child.getElementType() == JavaTokenType.IDENTIFIER || child.getElementType() == JavaElementType.THROWS_LIST || child.getElementType() == JavaElementType.TYPE_PARAMETER_LIST)) {
            return Indent.getNoneIndent();
        }
        return Indent.getContinuationIndent((boolean)this.myIndentSettings.USE_RELATIVE_INDENTS);
    }

    private static boolean isNodeParentMethod(@NotNull ASTNode node) {
        return node.getTreeParent() != null && node.getTreeParent().getElementType() == JavaElementType.METHOD;
    }

    private Indent calcIndentBefore(ASTNode child, int state) {
        if (state == 2) {
            if (!this.mySettings.SPECIAL_ELSE_IF_TREATMENT) {
                return this.getCodeBlockInternalIndent(1);
            }
            return this.getCodeBlockExternalIndent();
        }
        if (state == 1 && (BlockContainingJavaBlock.isSimpleStatement(child) || child.getElementType() == JavaElementType.BLOCK_STATEMENT)) {
            return this.getCodeBlockInternalIndent(0);
        }
        if (state == 0) {
            return this.getCodeBlockExternalIndent();
        }
        if (child.getElementType() == JavaTokenType.ELSE_KEYWORD) {
            return this.getCodeBlockExternalIndent();
        }
        if (child.getPsi() instanceof PsiTypeElement) {
            return Indent.getNoneIndent();
        }
        return Indent.getContinuationIndent((boolean)this.myIndentSettings.USE_RELATIVE_INDENTS);
    }

    private static boolean isSimpleStatement(ASTNode child) {
        if (child.getElementType() == JavaElementType.BLOCK_STATEMENT) {
            return false;
        }
        if (!(child.getPsi() instanceof PsiStatement)) {
            return false;
        }
        return BlockContainingJavaBlock.isStatement(child, child.getTreeParent());
    }

    private static boolean isPartOfCodeBlock(ASTNode child) {
        if (child == null) {
            return false;
        }
        if (child.getElementType() == JavaElementType.BLOCK_STATEMENT) {
            return true;
        }
        if (child.getElementType() == JavaElementType.CODE_BLOCK) {
            return true;
        }
        if (FormatterUtil.containsWhiteSpacesOnly(child)) {
            return BlockContainingJavaBlock.isPartOfCodeBlock(child.getTreeNext());
        }
        if (child.getElementType() == JavaTokenType.END_OF_LINE_COMMENT) {
            return BlockContainingJavaBlock.isPartOfCodeBlock(child.getTreeNext());
        }
        return child.getElementType() == JavaDocElementType.DOC_COMMENT;
    }

    @Override
    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        Alignment prev;
        if (this.isAfter(newChildIndex, new IElementType[]{JavaDocElementType.DOC_COMMENT})) {
            return new ChildAttributes(Indent.getNoneIndent(), null);
        }
        if (this.myNode.getElementType() == JavaElementType.FOR_STATEMENT && this.mySettings.ALIGN_MULTILINE_FOR && this.isInsideForParens(newChildIndex) && (prev = this.getUsedAlignment(newChildIndex)) != null) {
            return new ChildAttributes(null, prev);
        }
        if (newChildIndex == 0) {
            return new ChildAttributes(this.getCodeBlockExternalIndent(), null);
        }
        boolean useExternalIndent = false;
        if (newChildIndex == this.getSubBlocks().size()) {
            useExternalIndent = true;
        } else if (TYPES_OF_STATEMENTS_WITH_OPTIONAL_BRACES.contains(this.myNode.getElementType())) {
            Block prevBlock = this.getSubBlocks().get(newChildIndex - 1);
            Block nextBlock = this.getSubBlocks().get(newChildIndex);
            if (prevBlock instanceof ASTBlock && nextBlock instanceof ASTBlock) {
                ASTNode prevNode = ((ASTBlock)prevBlock).getNode();
                ASTNode nextNode = ((ASTBlock)nextBlock).getNode();
                if (prevNode != null && nextNode != null && prevNode.getElementType() == JavaTokenType.RPARENTH && nextNode.getElementType() != JavaTokenType.LBRACE) {
                    useExternalIndent = true;
                }
            }
        }
        if (useExternalIndent) {
            return new ChildAttributes(this.getCodeBlockChildExternalIndent(newChildIndex), null);
        }
        return new ChildAttributes(this.myIndentsBefore.get(newChildIndex), this.getUsedAlignment(newChildIndex));
    }

    private boolean isInsideForParens(int newChildIndex) {
        List<Block> subBlocks = this.getSubBlocks();
        for (int i = 0; i < newChildIndex; ++i) {
            if (i >= subBlocks.size()) {
                return false;
            }
            Block block = subBlocks.get(i);
            if (!(block instanceof LeafBlock) || ((LeafBlock)block).getTreeNode().getElementType() != JavaTokenType.RPARENTH) continue;
            return false;
        }
        return true;
    }
}

