/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.common;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.formatter.common.InjectedLanguageBlockBuilder;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultInjectedLanguageBlockBuilder
extends InjectedLanguageBlockBuilder {
    @NotNull
    private final CodeStyleSettings mySettings;

    public DefaultInjectedLanguageBlockBuilder(@NotNull CodeStyleSettings settings) {
        this.mySettings = settings;
    }

    @Override
    @NotNull
    public CodeStyleSettings getSettings() {
        return this.mySettings;
    }

    @Override
    public boolean canProcessFragment(String text, ASTNode injectionHost) {
        return true;
    }

    @Override
    public Block createBlockBeforeInjection(ASTNode node, Wrap wrap, Alignment alignment, Indent indent, TextRange range) {
        return new GlueBlock(node, wrap, alignment, indent, range);
    }

    @Override
    public Block createBlockAfterInjection(ASTNode node, Wrap wrap, Alignment alignment, Indent indent, TextRange range) {
        return new GlueBlock(node, wrap, alignment, Indent.getNoneIndent(), range);
    }

    private static class GlueBlock
    extends AbstractBlock {
        @NotNull
        private final Indent myIndent;
        @NotNull
        private final TextRange myRange;

        private GlueBlock(@NotNull ASTNode node, @Nullable Wrap wrap, @Nullable Alignment alignment, @NotNull Indent indent, @NotNull TextRange range) {
            super(node, wrap, alignment);
            this.myIndent = indent;
            this.myRange = range;
        }

        @Override
        @NotNull
        public TextRange getTextRange() {
            return this.myRange;
        }

        @Override
        protected List<Block> buildChildren() {
            return AbstractBlock.EMPTY;
        }

        @Override
        @NotNull
        public Indent getIndent() {
            return this.myIndent;
        }

        @Nullable
        public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
            return null;
        }

        public boolean isLeaf() {
            return true;
        }
    }
}

