/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.common;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.common.DefaultInjectedLanguageBlockBuilder;
import com.intellij.psi.formatter.common.SettingsAwareBlock;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBlock
implements ASTBlock {
    public static final List<Block> EMPTY = Collections.emptyList();
    @NotNull
    protected final ASTNode myNode;
    @Nullable
    protected final Wrap myWrap;
    @Nullable
    protected final Alignment myAlignment;
    private List<Block> mySubBlocks;
    private Boolean myIncomplete;
    private boolean myBuildIndentsOnly = false;

    protected AbstractBlock(@NotNull ASTNode node, @Nullable Wrap wrap, @Nullable Alignment alignment) {
        this.myNode = node;
        this.myWrap = wrap;
        this.myAlignment = alignment;
    }

    @NotNull
    public TextRange getTextRange() {
        return this.myNode.getTextRange();
    }

    @NotNull
    public List<Block> getSubBlocks() {
        if (this.mySubBlocks == null) {
            List<Block> list = this.buildChildren();
            if (list.isEmpty()) {
                list = this.buildInjectedBlocks();
            }
            this.mySubBlocks = !list.isEmpty() ? list : EMPTY;
        }
        return this.mySubBlocks;
    }

    public void setBuildIndentsOnly(boolean value) {
        this.myBuildIndentsOnly = value;
    }

    protected boolean isBuildIndentsOnly() {
        return this.myBuildIndentsOnly;
    }

    @NotNull
    private List<Block> buildInjectedBlocks() {
        if (this.myBuildIndentsOnly) {
            return EMPTY;
        }
        if (!(this instanceof SettingsAwareBlock)) {
            return EMPTY;
        }
        PsiElement psi = this.myNode.getPsi();
        if (psi == null) {
            return EMPTY;
        }
        PsiFile file2 = psi.getContainingFile();
        if (file2 == null) {
            return EMPTY;
        }
        if (InjectedLanguageUtil.getCachedInjectedDocuments(file2).isEmpty()) {
            return EMPTY;
        }
        TextRange blockRange = this.myNode.getTextRange();
        ConcurrentList<DocumentWindow> documentWindows = InjectedLanguageUtil.getCachedInjectedDocuments(file2);
        for (DocumentWindow documentWindow : documentWindows) {
            PsiFile injected;
            int endOffset;
            int startOffset = documentWindow.injectedToHost(0);
            if (!blockRange.containsRange(startOffset, endOffset = startOffset + documentWindow.getTextLength()) || (injected = PsiDocumentManager.getInstance((Project)psi.getProject()).getCachedPsiFile((Document)documentWindow)) == null) continue;
            ArrayList result = ContainerUtilRt.newArrayList();
            DefaultInjectedLanguageBlockBuilder builder = new DefaultInjectedLanguageBlockBuilder(((SettingsAwareBlock)((Object)this)).getSettings());
            builder.addInjectedBlocks(result, this.myNode, this.getWrap(), this.getAlignment(), this.getIndent());
            return result;
        }
        return EMPTY;
    }

    protected abstract List<Block> buildChildren();

    @Nullable
    public Wrap getWrap() {
        return this.myWrap;
    }

    public Indent getIndent() {
        return null;
    }

    @Nullable
    public Alignment getAlignment() {
        return this.myAlignment;
    }

    @NotNull
    public ASTNode getNode() {
        return this.myNode;
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        return new ChildAttributes(this.getChildIndent(), this.getFirstChildAlignment());
    }

    @Nullable
    private Alignment getFirstChildAlignment() {
        List<Block> subBlocks = this.getSubBlocks();
        for (Block subBlock : subBlocks) {
            Alignment alignment = subBlock.getAlignment();
            if (alignment == null) continue;
            return alignment;
        }
        return null;
    }

    @Nullable
    protected Indent getChildIndent() {
        return null;
    }

    public boolean isIncomplete() {
        if (this.myIncomplete == null) {
            this.myIncomplete = FormatterUtil.isIncomplete(this.getNode());
        }
        return this.myIncomplete;
    }

    public String toString() {
        return this.myNode.getText() + " " + this.getTextRange();
    }
}

