/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter;

import com.intellij.psi.formatter.AbstractWhiteSpaceFormattingStrategy;
import com.intellij.util.text.CharArrayUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class StaticTextWhiteSpaceDefinitionStrategy
extends AbstractWhiteSpaceFormattingStrategy {
    private final Set<CharSequence> myWhiteSpaces = new HashSet<CharSequence>();

    public StaticTextWhiteSpaceDefinitionStrategy(CharSequence ... whiteSpaces) {
        this.myWhiteSpaces.addAll(Arrays.asList(whiteSpaces));
    }

    @Override
    public int check(@NotNull CharSequence text, int start, int end) {
        for (CharSequence whiteSpace : this.myWhiteSpaces) {
            if (CharArrayUtil.indexOf((CharSequence)text, (CharSequence)whiteSpace, (int)start, (int)end) != start) continue;
            return start + whiteSpace.length();
        }
        return start;
    }
}

