/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.WhiteSpaceFormattingStrategy;
import com.intellij.psi.impl.source.tree.LeafElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CompositeWhiteSpaceFormattingStrategy
implements WhiteSpaceFormattingStrategy {
    private final List<WhiteSpaceFormattingStrategy> myStrategies = new ArrayList<WhiteSpaceFormattingStrategy>();
    private boolean myReplaceDefaultStrategy;

    public CompositeWhiteSpaceFormattingStrategy(@NotNull Collection<WhiteSpaceFormattingStrategy> strategies) throws IllegalArgumentException {
        for (WhiteSpaceFormattingStrategy strategy : strategies) {
            this.addStrategy(strategy);
        }
    }

    @Override
    public int check(@NotNull CharSequence text, int start, int end) {
        int offset = start;
        while (offset < end) {
            WhiteSpaceFormattingStrategy strategy;
            int oldOffset = offset;
            Iterator<WhiteSpaceFormattingStrategy> iterator = this.myStrategies.iterator();
            while (iterator.hasNext() && (offset = (strategy = iterator.next()).check(text, offset, end)) <= oldOffset) {
            }
            if (offset != oldOffset) continue;
            return start;
        }
        return offset;
    }

    @Override
    public boolean replaceDefaultStrategy() {
        return this.myReplaceDefaultStrategy;
    }

    public void addStrategy(@NotNull WhiteSpaceFormattingStrategy strategy) throws IllegalArgumentException {
        if (this.myReplaceDefaultStrategy && strategy.replaceDefaultStrategy()) {
            throw new IllegalArgumentException(String.format("Can't combine strategy '%s' with already registered strategies (%s). Reason: given strategy is marked to replace all existing strategies but strategy with such characteristics is already registered", strategy, this.myStrategies));
        }
        this.myStrategies.add(strategy);
        this.myReplaceDefaultStrategy |= strategy.replaceDefaultStrategy();
    }

    @Override
    @NotNull
    public CharSequence adjustWhiteSpaceIfNecessary(@NotNull CharSequence whiteSpaceText, @NotNull CharSequence text, int startOffset, int endOffset, CodeStyleSettings codeStyleSettings, ASTNode nodeAfter) {
        CharSequence result = whiteSpaceText;
        for (WhiteSpaceFormattingStrategy strategy : this.myStrategies) {
            result = strategy.adjustWhiteSpaceIfNecessary(result, text, startOffset, endOffset, codeStyleSettings, nodeAfter);
        }
        return result;
    }

    @Override
    public CharSequence adjustWhiteSpaceIfNecessary(@NotNull CharSequence whiteSpaceText, @NotNull PsiElement startElement, int startOffset, int endOffset, CodeStyleSettings codeStyleSettings) {
        CharSequence result = whiteSpaceText;
        for (WhiteSpaceFormattingStrategy strategy : this.myStrategies) {
            result = strategy.adjustWhiteSpaceIfNecessary(result, startElement, startOffset, endOffset, codeStyleSettings);
        }
        return result;
    }

    @Override
    public boolean containsWhitespacesOnly(@NotNull ASTNode node) {
        for (WhiteSpaceFormattingStrategy strategy : this.myStrategies) {
            if (!strategy.containsWhitespacesOnly(node)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean addWhitespace(@NotNull ASTNode treePrev, @NotNull LeafElement whiteSpaceElement) {
        return false;
    }
}

