/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.filters.getters;

import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.psi.filters.getters.XmlAttributeValueGetter;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.util.HtmlUtil;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlAttributeValueGetter
extends XmlAttributeValueGetter {
    private final boolean myCaseSensitive;

    public HtmlAttributeValueGetter(boolean _caseSensitive) {
        this.myCaseSensitive = _caseSensitive;
    }

    @Override
    @Nullable
    @NonNls
    protected String[] addSpecificCompletions(XmlAttribute attribute) {
        String namespace;
        String name = attribute.getName();
        XmlTag tag = attribute.getParent();
        if (tag == null) {
            return null;
        }
        String tagName = tag.getName();
        if (!this.myCaseSensitive) {
            name = name.toLowerCase();
            tagName = tagName.toLowerCase();
        }
        if ("http://www.w3.org/1999/xhtml".equals(namespace = tag.getNamespace()) || "http://www.w3.org/1999/html".equals(namespace)) {
            if ("target".equals(name)) {
                return new String[]{"_blank", "_top", "_self", "_parent"};
            }
            if ("enctype".equals(name)) {
                return new String[]{"multipart/form-data", "application/x-www-form-urlencoded"};
            }
            if ("rel".equals(name) || "rev".equals(name)) {
                return new String[]{"alternate", "author", "bookmark", "help", "icon", "license", "next", "nofollow", "noreferrer", "prefetch", "prev", "search", "stylesheet", "tag", "start", "contents", "index", "glossary", "copyright", "chapter", "section", "subsection", "appendix", "script", "import", "apple-touch-icon", "apple-touch-icon-precomposed", "apple-touch-startup-image"};
            }
            if ("media".equals(name)) {
                return new String[]{"all", "braille", "embossed", "handheld", "print", "projection", "screen", "speech", "tty", "tv"};
            }
            if ("language".equals(name)) {
                return new String[]{"JavaScript", "VBScript", "JScript", "JavaScript1.2", "JavaScript1.3", "JavaScript1.4", "JavaScript1.5"};
            }
            if ("type".equals(name) && "link".equals(tagName)) {
                return new String[]{"text/css", "text/html", "text/plain", "text/xml"};
            }
            if ("http-equiv".equals(name) && "meta".equals(tagName)) {
                return HtmlUtil.RFC2616_HEADERS;
            }
            if ("content".equals(name) && "meta".equals(tagName) && this.getAttribute(tag, "name") == null) {
                return HtmlUtil.CONTENT_TYPES;
            }
            if ("accept".equals(name) && "input".equals(tagName)) {
                return HtmlUtil.CONTENT_TYPES;
            }
            if ("accept-charset".equals(name) || "charset".equals(name)) {
                Charset[] charSets = CharsetToolkit.getAvailableCharsets();
                String[] names = new String[charSets.length];
                for (int i = 0; i < names.length; ++i) {
                    names[i] = charSets[i].toString();
                }
                return names;
            }
        }
        return null;
    }

    @Nullable
    private XmlAttribute getAttribute(@NotNull XmlTag tag, @NotNull String attributeName) {
        if (this.myCaseSensitive) {
            return tag.getAttribute(attributeName);
        }
        for (XmlAttribute xmlAttribute : tag.getAttributes()) {
            if (!attributeName.equalsIgnoreCase(xmlAttribute.getName())) continue;
            return xmlAttribute;
        }
        return null;
    }
}

