/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.filters.getters;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInsight.completion.CompletionContext;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.filters.ContextGetter;
import com.intellij.psi.util.PsiTreeUtil;
import gnu.trove.THashSet;
import org.jetbrains.annotations.NotNull;

public class ExpectedTypesGetter
implements ContextGetter {
    @NotNull
    public PsiType[] get(PsiElement context, CompletionContext completionContext) {
        return ExpectedTypesGetter.getExpectedTypes(context, false);
    }

    public static PsiType[] getExpectedTypes(PsiElement context, boolean defaultTypes) {
        PsiExpression expression = (PsiExpression)PsiTreeUtil.getContextOfType((PsiElement)context, PsiExpression.class, (boolean)true);
        if (expression == null) {
            return PsiType.EMPTY_ARRAY;
        }
        return ExpectedTypesGetter.extractTypes(ExpectedTypesProvider.getExpectedTypes(expression, true), defaultTypes);
    }

    public static PsiType[] extractTypes(ExpectedTypeInfo[] infos, boolean defaultTypes) {
        THashSet result = new THashSet(infos.length);
        for (ExpectedTypeInfo info : infos) {
            PsiType type = info.getType();
            PsiType defaultType = info.getDefaultType();
            if (!defaultTypes && !defaultType.equals(type)) {
                result.add(type);
            }
            result.add(defaultType);
        }
        return result.toArray(PsiType.createArray((int)result.size()));
    }
}

