/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.extractor.ui;

import com.intellij.application.options.codeStyle.OptionTableWithPreviewPanel;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.extractor.ui.CodeStyleSettingsNameProvider;
import com.intellij.psi.codeStyle.extractor.values.Value;
import com.intellij.psi.codeStyle.presentation.CodeStyleSettingPresentation;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TreeTableSpeedSearch;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableCellRenderer;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.ClientPropertyHolder;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtractedSettingsDialog
extends DialogWrapper {
    protected CodeStyleSettingsNameProvider myNameProvider;
    protected List<Value> myValues;
    protected DefaultMutableTreeNode myRoot;
    private static ValueRenderer myValueRenderer = new ValueRenderer();
    private static ValueEditor myValueEditor = new ValueEditor();
    final TreeCellRenderer myTitleRenderer = new CellRenderer();

    public ExtractedSettingsDialog(@Nullable Project project2, @NotNull CodeStyleSettingsNameProvider nameProvider, @NotNull List<Value> values) {
        super(project2, false);
        this.myNameProvider = nameProvider;
        this.myValues = values;
        this.setModal(true);
        this.init();
        this.setTitle("Extracted Code Style Settings");
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JComponent result = this.buildExtractedSettingsTree();
        return result;
    }

    public boolean valueIsSelectedInTree(@NotNull Value value) {
        if (this.myRoot == null) {
            return false;
        }
        return this.valueIsSelectedInTree(this.myRoot, value);
    }

    protected boolean valueIsSelectedInTree(@NotNull TreeNode startNode, @NotNull Value value) {
        Enumeration<? extends TreeNode> children2 = startNode.children();
        while (children2.hasMoreElements()) {
            TreeNode child = children2.nextElement();
            if (child instanceof SettingsTreeNode) {
                SettingsTreeNode settingsChild = (SettingsTreeNode)child;
                if (settingsChild.accepted && value.equals((Object)settingsChild.myValue)) {
                    return true;
                }
                if (!this.valueIsSelectedInTree(settingsChild, value)) continue;
                return true;
            }
            if (!(child instanceof TreeNode) || !this.valueIsSelectedInTree(child, value)) continue;
            return true;
        }
        return false;
    }

    protected static ColumnInfo getTitleColumnInfo() {
        return new ColumnInfo("TITLE"){

            @Nullable
            public Object valueOf(Object o) {
                if (o instanceof SettingsTreeNode) {
                    return ((SettingsTreeNode)o).getTitle();
                }
                return o.toString();
            }

            public Class getColumnClass() {
                return TreeTableModel.class;
            }
        };
    }

    protected static ColumnInfo getValueColumnInfo() {
        return new ColumnInfo("VALUE"){

            @Nullable
            public Object valueOf(Object o) {
                if (o instanceof SettingsTreeNode) {
                    return ((SettingsTreeNode)o).getValueString();
                }
                return null;
            }

            public TableCellRenderer getRenderer(Object o) {
                return myValueRenderer;
            }

            public TableCellEditor getEditor(Object o) {
                return myValueEditor;
            }

            public boolean isCellEditable(Object o) {
                return o instanceof SettingsTreeNode;
            }
        };
    }

    protected JComponent buildExtractedSettingsTree() {
        HashSet unusedValues = ContainerUtil.newHashSet(this.myValues);
        this.myRoot = new DefaultMutableTreeNode();
        for (Map.Entry<LanguageCodeStyleSettingsProvider.SettingsType, Map<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>>> typeEntry : this.myNameProvider.mySettings.entrySet()) {
            DefaultMutableTreeNode settingsNode = null;
            for (Map.Entry<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>> groupEntry : typeEntry.getValue().entrySet()) {
                CodeStyleSettingPresentation headRep;
                CodeStyleSettingPresentation.SettingsGroup group = groupEntry.getKey();
                List<CodeStyleSettingPresentation> representations = groupEntry.getValue();
                List<CodeStyleSettingPresentation> children2 = ContainerUtil.emptyList();
                DefaultMutableTreeNode groupNode = null;
                if (group.name == null && !representations.isEmpty()) {
                    Value myValue;
                    if (representations.size() > 1) {
                        children2 = representations.subList(1, representations.size());
                    }
                    if ((myValue = CodeStyleSettingsNameProvider.getValue(headRep = representations.get(0), this.myValues)) == null) {
                        groupNode = new SettingsTreeNode(headRep.getUiName());
                    } else {
                        groupNode = new SettingsTreeNode(headRep.getUiName());
                        groupNode.add(new SettingsTreeNode(headRep.getValueUiName(myValue.value), headRep, true, myValue));
                        unusedValues.remove(myValue);
                    }
                } else {
                    children2 = representations;
                }
                headRep = children2.iterator();
                while (headRep.hasNext()) {
                    CodeStyleSettingPresentation representation = headRep.next();
                    Value myValue = CodeStyleSettingsNameProvider.getValue(representation, this.myValues);
                    if (myValue == null) continue;
                    if (groupNode == null) {
                        groupNode = new SettingsTreeNode(group.name);
                    }
                    groupNode.add(new SettingsTreeNode(representation.getValueUiName(myValue.value), representation, false, myValue));
                    unusedValues.remove(myValue);
                }
                if (groupNode == null || groupNode.isLeaf()) continue;
                if (settingsNode == null) {
                    settingsNode = new SettingsTreeNode(CodeStyleSettingsNameProvider.getSettingsTypeName(typeEntry.getKey()));
                }
                settingsNode.add(groupNode);
            }
            if (settingsNode == null) continue;
            this.myRoot.add(settingsNode);
        }
        final ColumnInfo[] COLUMNS = new ColumnInfo[]{ExtractedSettingsDialog.getTitleColumnInfo(), ExtractedSettingsDialog.getValueColumnInfo()};
        ListTreeTableModel model = new ListTreeTableModel((TreeNode)this.myRoot, COLUMNS);
        TreeTable treeTable = new TreeTable((TreeTableModel)model){

            public TreeTableCellRenderer createTableRenderer(TreeTableModel treeTableModel) {
                TreeTableCellRenderer tableRenderer = super.createTableRenderer(treeTableModel);
                UIUtil.setLineStyleAngled((ClientPropertyHolder)tableRenderer);
                tableRenderer.setRootVisible(false);
                tableRenderer.setShowsRootHandles(true);
                return tableRenderer;
            }

            public TableCellRenderer getCellRenderer(int row, int column) {
                TreePath treePath = this.getTree().getPathForRow(row);
                if (treePath == null) {
                    return super.getCellRenderer(row, column);
                }
                Object node = treePath.getLastPathComponent();
                TableCellRenderer renderer = COLUMNS[column].getRenderer(node);
                return renderer == null ? super.getCellRenderer(row, column) : renderer;
            }

            public TableCellEditor getCellEditor(int row, int column) {
                TreePath treePath = this.getTree().getPathForRow(row);
                if (treePath == null) {
                    return super.getCellEditor(row, column);
                }
                Object node = treePath.getLastPathComponent();
                TableCellEditor editor = COLUMNS[column].getEditor(node);
                return editor == null ? super.getCellEditor(row, column) : editor;
            }
        };
        new TreeTableSpeedSearch(treeTable).setComparator(new SpeedSearchComparator(false));
        treeTable.setRootVisible(false);
        TreeTableTree tree = treeTable.getTree();
        tree.setCellRenderer(this.myTitleRenderer);
        tree.setShowsRootHandles(true);
        treeTable.setSelectionMode(0);
        treeTable.setTableHeader(null);
        OptionTableWithPreviewPanel.expandTree((JTree)tree);
        treeTable.getColumnModel().getSelectionModel().setAnchorSelectionIndex(1);
        treeTable.getColumnModel().getSelectionModel().setLeadSelectionIndex(1);
        int maxWidth = tree.getPreferredScrollableViewportSize().width + 10;
        TableColumn titleColumn = treeTable.getColumnModel().getColumn(0);
        titleColumn.setPreferredWidth(maxWidth);
        titleColumn.setMinWidth(maxWidth);
        titleColumn.setMaxWidth(maxWidth);
        titleColumn.setResizable(false);
        Dimension valueSize = new JLabel(ApplicationBundle.message((String)"option.table.sizing.text", (Object[])new Object[0])).getPreferredSize();
        treeTable.setPreferredScrollableViewportSize(new Dimension(maxWidth + valueSize.width + 10, 20));
        treeTable.setBackground(UIUtil.getPanelBackground());
        treeTable.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        Dimension screenSize = treeTable.getToolkit().getScreenSize();
        JBScrollPane scroller = new JBScrollPane((Component)treeTable){

            public Dimension getMinimumSize() {
                return super.getPreferredSize();
            }
        };
        Dimension preferredSize = new Dimension(Math.min(screenSize.width / 2, treeTable.getPreferredSize().width), Math.min(screenSize.height / 2, treeTable.getPreferredSize().height));
        this.getRootPane().setPreferredSize(preferredSize);
        return scroller;
    }

    public static class CellRenderer
    implements TreeCellRenderer {
        private final JLabel myLabel = new JLabel();

        @Override
        @NotNull
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value instanceof SettingsTreeNode) {
                SettingsTreeNode node = (SettingsTreeNode)value;
                this.myLabel.setText(node.getTitle());
                this.myLabel.setFont(node.isGroupOrTypeNode() ? this.myLabel.getFont().deriveFont(1) : this.myLabel.getFont().deriveFont(0));
            } else {
                this.myLabel.setText(value.toString());
                this.myLabel.setFont(this.myLabel.getFont().deriveFont(1));
            }
            Color foreground = selected ? UIUtil.getTableSelectionForeground() : UIUtil.getTableForeground();
            this.myLabel.setForeground(foreground);
            return this.myLabel;
        }
    }

    protected static class ValueEditor
    extends AbstractTableCellEditor {
        private final JLabel myLabel = new JLabel();
        private final JCheckBox myCheckBox = new JCheckBox();
        private final JPanel myPanel = new JPanel((LayoutManager)new HorizontalLayout(0));
        private SettingsTreeNode myCurrentNode;
        private TreeTable myCurrentTree;
        final ActionListener itemChoiceListener;

        protected void updateAncestorsUi(boolean accepted, SettingsTreeNode node) {
            TreeNode parent = node.getParent();
            if (parent != null && parent instanceof SettingsTreeNode) {
                SettingsTreeNode settingsParent = (SettingsTreeNode)parent;
                settingsParent.accepted = false;
                if (!accepted) {
                    this.updateAncestorsUi(false, settingsParent);
                } else {
                    Enumeration<? extends TreeNode> children2 = parent.children();
                    while (children2.hasMoreElements()) {
                        TreeNode child = children2.nextElement();
                        if (!(child instanceof SettingsTreeNode) || ((SettingsTreeNode)child).accepted) continue;
                        return;
                    }
                    settingsParent.accepted = true;
                    this.updateAncestorsUi(true, settingsParent);
                }
            }
        }

        protected void updateChildrenUi(SettingsTreeNode node) {
            Enumeration<TreeNode> children2 = node.children();
            while (children2.hasMoreElements()) {
                TreeNode child = children2.nextElement();
                if (!(child instanceof SettingsTreeNode)) continue;
                SettingsTreeNode settingsChild = (SettingsTreeNode)child;
                settingsChild.accepted = node.accepted;
                this.updateChildrenUi(settingsChild);
            }
        }

        public ValueEditor() {
            this.myPanel.add(this.myLabel);
            this.myPanel.add(this.myCheckBox);
            this.itemChoiceListener = new ActionListener(){

                @Override
                public void actionPerformed(@NotNull ActionEvent e) {
                    if (myCurrentNode != null) {
                        boolean wasChanged = ((ValueEditor)this).myCurrentNode.accepted != myCheckBox.isSelected();
                        ((ValueEditor)this).myCurrentNode.accepted = myCheckBox.isSelected();
                        if (wasChanged) {
                            this.updateAncestorsUi(((ValueEditor)this).myCurrentNode.accepted, myCurrentNode);
                            this.updateChildrenUi(myCurrentNode);
                        }
                        if (myCurrentTree != null) {
                            myCurrentTree.repaint();
                        }
                    }
                }
            };
            this.myCheckBox.addActionListener(this.itemChoiceListener);
        }

        public Object getCellEditorValue() {
            return this.myCheckBox.isSelected();
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)((TreeTable)table).getTree().getPathForRow(row).getLastPathComponent();
            if (treeNode instanceof SettingsTreeNode) {
                this.myCurrentTree = (TreeTable)table;
                this.myCurrentNode = (SettingsTreeNode)treeNode;
                this.myLabel.setText(this.myCurrentNode.getValueString());
                this.myCheckBox.setSelected(this.myCurrentNode.accepted);
            }
            return this.myPanel;
        }
    }

    protected static class ValueRenderer
    implements TableCellRenderer {
        private final JLabel myLabel = new JLabel();
        private final JCheckBox myCheckBox = new JCheckBox();
        private final JPanel myPanel = new JPanel((LayoutManager)new HorizontalLayout(0));

        protected ValueRenderer() {
            this.myPanel.add(this.myLabel);
            this.myPanel.add(this.myCheckBox);
        }

        @Override
        @NotNull
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (table instanceof TreeTable) {
                table.setEnabled(true);
                DefaultMutableTreeNode valueNode = (DefaultMutableTreeNode)((TreeTable)table).getTree().getPathForRow(row).getLastPathComponent();
                if (valueNode instanceof SettingsTreeNode) {
                    SettingsTreeNode settingsNode = (SettingsTreeNode)valueNode;
                    this.myLabel.setText(settingsNode.getValueString());
                    this.myCheckBox.setEnabled(true);
                    this.myCheckBox.setSelected(settingsNode.accepted);
                } else {
                    this.myLabel.setBackground(table.getBackground());
                    this.myCheckBox.setEnabled(false);
                }
            }
            return this.myPanel;
        }
    }

    public static class SettingsTreeNode
    extends DefaultMutableTreeNode {
        protected CodeStyleSettingPresentation myRepresentation;
        protected boolean accepted = true;
        protected final String valueString;
        protected final boolean isGroupNode;
        protected final String customTitle;
        protected Value myValue;

        public SettingsTreeNode(String valueString, CodeStyleSettingPresentation representation, boolean isGroupNode, Value value) {
            this(valueString, representation, isGroupNode, null, value);
        }

        public SettingsTreeNode(String valueString, CodeStyleSettingPresentation representation, boolean isGroupNode, String customTitle, Value value) {
            this.valueString = valueString;
            this.myRepresentation = representation;
            this.isGroupNode = isGroupNode;
            this.customTitle = customTitle;
            this.myValue = value;
        }

        public SettingsTreeNode(String title) {
            this(title, null, true, null);
        }

        public boolean isGroupOrTypeNode() {
            return this.isGroupNode;
        }

        @NotNull
        public String getTitle() {
            return this.customTitle != null ? this.customTitle : (this.myRepresentation == null ? this.valueString : this.myRepresentation.getUiName());
        }

        @Nullable
        public String getValueString() {
            return this.myRepresentation == null ? null : this.valueString;
        }
    }
}

