/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.autodetect;

import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.EditorNotificationInfo;
import com.intellij.psi.codeStyle.FileIndentOptionsProvider;
import com.intellij.psi.codeStyle.ProviderForCommittedDocument;
import com.intellij.psi.codeStyle.autodetect.IndentOptionsDetectorImpl;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.WeakList;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DetectableIndentOptionsProvider
extends FileIndentOptionsProvider
implements ProviderForCommittedDocument {
    private boolean myIsEnabledInTest;
    private final List<VirtualFile> myAcceptedFiles = new WeakList();
    private final List<VirtualFile> myDisabledFiles = new WeakList();

    @Nullable
    public CommonCodeStyleSettings.IndentOptions getIndentOptions(@NotNull CodeStyleSettings settings, @NotNull PsiFile file2) {
        return DetectableIndentOptionsProvider.isDocumentCommitted(file2) && this.isEnabled(settings, file2) ? new IndentOptionsDetectorImpl(file2).getIndentOptions() : null;
    }

    private static boolean isDocumentCommitted(@NotNull PsiFile file2) {
        PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)file2.getProject());
        Document document = manager.getDocument(file2);
        return document != null && manager.isCommitted(document);
    }

    public boolean useOnFullReformat() {
        return false;
    }

    public void setEnabledInTest(boolean isEnabledInTest) {
        this.myIsEnabledInTest = isEnabledInTest;
    }

    private boolean isEnabled(@NotNull CodeStyleSettings settings, @NotNull PsiFile file2) {
        if (file2 instanceof PsiCompiledFile) {
            return false;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return this.myIsEnabledInTest;
        }
        VirtualFile vFile = file2.getVirtualFile();
        if (vFile == null || vFile instanceof LightVirtualFile || this.myDisabledFiles.contains(vFile)) {
            return false;
        }
        return LanguageFormatting.INSTANCE.forContext((PsiElement)file2) != null && settings.AUTODETECT_INDENTS;
    }

    @Nullable
    public static DetectableIndentOptionsProvider getInstance() {
        return (DetectableIndentOptionsProvider)((Object)FileIndentOptionsProvider.EP_NAME.findExtension(DetectableIndentOptionsProvider.class));
    }

    @Nullable
    public EditorNotificationInfo getNotificationInfo(final @NotNull Project project2, final @NotNull VirtualFile file2, @NotNull FileEditor fileEditor, @NotNull CommonCodeStyleSettings.IndentOptions userOptions, @NotNull CommonCodeStyleSettings.IndentOptions detectedOptions) {
        Editor editor;
        final NotificationLabels labels = DetectableIndentOptionsProvider.getNotificationLabels(userOptions, detectedOptions);
        Editor editor2 = editor = fileEditor instanceof TextEditor ? ((TextEditor)fileEditor).getEditor() : null;
        if (labels == null || editor == null) {
            return null;
        }
        EditorNotificationInfo.ActionLabelData okAction = new EditorNotificationInfo.ActionLabelData(ApplicationBundle.message((String)"code.style.indents.detector.accept", (Object[])new Object[0]), new Runnable(){

            @Override
            public void run() {
                DetectableIndentOptionsProvider.this.setAccepted(file2);
            }
        });
        EditorNotificationInfo.ActionLabelData disableForSingleFile = new EditorNotificationInfo.ActionLabelData(labels.revertToOldSettingsLabel, new Runnable(){

            @Override
            public void run() {
                DetectableIndentOptionsProvider.this.disableForFile(file2);
                if (editor instanceof EditorEx) {
                    ((EditorEx)editor).reinitSettings();
                }
            }
        });
        EditorNotificationInfo.ActionLabelData showSettings = new EditorNotificationInfo.ActionLabelData(ApplicationBundle.message((String)"code.style.indents.detector.show.settings", (Object[])new Object[0]), new Runnable(){

            @Override
            public void run() {
                ShowSettingsUtilImpl.showSettingsDialog(project2, "preferences.sourceCode", "detect indent");
            }
        });
        final ArrayList actions = ContainerUtil.newArrayList((Object[])new EditorNotificationInfo.ActionLabelData[]{okAction, disableForSingleFile, showSettings});
        return new EditorNotificationInfo(){

            @NotNull
            public List<EditorNotificationInfo.ActionLabelData> getLabelAndActions() {
                return actions;
            }

            @NotNull
            public String getTitle() {
                return labels.title;
            }
        };
    }

    @Nullable
    private static NotificationLabels getNotificationLabels(@NotNull CommonCodeStyleSettings.IndentOptions userOptions, @NotNull CommonCodeStyleSettings.IndentOptions detectedOptions) {
        if (userOptions.USE_TAB_CHARACTER) {
            if (!detectedOptions.USE_TAB_CHARACTER) {
                return new NotificationLabels(ApplicationBundle.message((String)"code.style.space.indent.detected", (Object[])new Object[]{detectedOptions.INDENT_SIZE}), ApplicationBundle.message((String)"code.style.detector.use.tabs", (Object[])new Object[0]));
            }
        } else {
            String restoreToSpaces = ApplicationBundle.message((String)"code.style.detector.use.spaces", (Object[])new Object[]{userOptions.INDENT_SIZE});
            if (detectedOptions.USE_TAB_CHARACTER) {
                return new NotificationLabels(ApplicationBundle.message((String)"code.style.tab.usage.detected", (Object[])new Object[]{userOptions.INDENT_SIZE}), restoreToSpaces);
            }
            if (userOptions.INDENT_SIZE != detectedOptions.INDENT_SIZE) {
                return new NotificationLabels(ApplicationBundle.message((String)"code.style.different.indent.size.detected", (Object[])new Object[]{detectedOptions.INDENT_SIZE, userOptions.INDENT_SIZE}), restoreToSpaces);
            }
        }
        return null;
    }

    private void disableForFile(@NotNull VirtualFile file2) {
        this.myDisabledFiles.add(file2);
    }

    public void setAccepted(@NotNull VirtualFile file2) {
        this.myAcceptedFiles.add(file2);
    }

    public boolean isAcceptedWithoutWarning(@Nullable Project project2, @NotNull VirtualFile file2) {
        return !FileIndentOptionsProvider.isShowNotification() || this.myAcceptedFiles.contains(file2);
    }

    private static class NotificationLabels {
        public final String title;
        public final String revertToOldSettingsLabel;

        public NotificationLabels(@NotNull String title, @NotNull String revertToOldSettingsLabel) {
            this.title = title;
            this.revertToOldSettingsLabel = revertToOldSettingsLabel;
        }
    }
}

