/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement;

import com.intellij.lang.Language;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.psi.codeStyle.arrangement.FoldingHandler;
import com.intellij.psi.codeStyle.arrangement.FoldingInfo;
import com.intellij.psi.codeStyle.arrangement.Info;
import com.intellij.psi.codeStyle.arrangement.RangeHandler;
import com.intellij.psi.codeStyle.arrangement.RichTextHandler;
import com.intellij.psi.codeStyle.arrangement.engine.ArrangementEngine;
import com.intellij.psi.codeStyle.arrangement.group.ArrangementGroupingRule;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementSectionRule;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementAtomMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementExtendableSettings;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementRuleAliasToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.testFramework.fixtures.LightPlatformCodeInsightFixtureTestCase;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractRearrangerTest
extends LightPlatformCodeInsightFixtureTestCase {
    private static final RichTextHandler[] RICH_TEXT_HANDLERS = new RichTextHandler[]{new RangeHandler(), new FoldingHandler()};
    private static final Pattern ATTRIBUTE_PATTERN = Pattern.compile("([^\\s]+)=([^\\s]+)");
    protected FileType fileType;
    protected Language language;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        CodeStyleSettingsManager.getInstance((Project)this.myFixture.getProject()).setTemporarySettings(new CodeStyleSettings());
    }

    @Override
    protected void tearDown() throws Exception {
        CodeStyleSettingsManager.getInstance((Project)this.myFixture.getProject()).dropTemporarySettings();
        super.tearDown();
    }

    @NotNull
    protected CommonCodeStyleSettings getCommonSettings() {
        return CodeStyleSettingsManager.getInstance((Project)this.myFixture.getProject()).getCurrentSettings().getCommonSettings(this.language);
    }

    protected static ArrangementSectionRule section(StdArrangementMatchRule ... rules) {
        return AbstractRearrangerTest.section(null, null, rules);
    }

    protected static ArrangementSectionRule section(@Nullable String start, @Nullable String end, StdArrangementMatchRule ... rules) {
        return ArrangementSectionRule.create((String)start, (String)end, (StdArrangementMatchRule[])rules);
    }

    protected static StdArrangementRuleAliasToken alias(@NotNull String id, StdArrangementMatchRule ... rules) {
        return new StdArrangementRuleAliasToken(id, id, (List)ContainerUtil.newArrayList((Object[])rules));
    }

    @NotNull
    protected static ArrangementGroupingRule group(@NotNull ArrangementSettingsToken type) {
        return AbstractRearrangerTest.group(type, StdArrangementTokens.Order.KEEP);
    }

    @NotNull
    protected static ArrangementGroupingRule group(@NotNull ArrangementSettingsToken type, @NotNull ArrangementSettingsToken order) {
        return new ArrangementGroupingRule(type, order);
    }

    @NotNull
    protected static StdArrangementMatchRule rule(@NotNull ArrangementSettingsToken token) {
        return new StdArrangementMatchRule(new StdArrangementEntryMatcher((ArrangementMatchCondition)AbstractRearrangerTest.atom(token)));
    }

    @NotNull
    protected static StdArrangementMatchRule nameRule(@NotNull String nameFilter, ArrangementSettingsToken ... tokens) {
        if (tokens.length == 0) {
            return new StdArrangementMatchRule(new StdArrangementEntryMatcher((ArrangementMatchCondition)AbstractRearrangerTest.atom(nameFilter)));
        }
        ArrangementAtomMatchCondition[] conditions = new ArrangementAtomMatchCondition[tokens.length + 1];
        conditions[0] = AbstractRearrangerTest.atom(nameFilter);
        for (int i = 0; i < tokens.length; ++i) {
            conditions[i + 1] = AbstractRearrangerTest.atom(tokens[i]);
        }
        ArrangementMatchCondition compositeCondition = ArrangementUtil.combine((ArrangementMatchCondition[])conditions);
        return new StdArrangementMatchRule(new StdArrangementEntryMatcher(compositeCondition));
    }

    @NotNull
    protected static StdArrangementMatchRule rule(ArrangementSettingsToken ... conditions) {
        return AbstractRearrangerTest.rule(ContainerUtil.map((Object[])conditions, (Function)new Function<ArrangementSettingsToken, ArrangementAtomMatchCondition>(){

            public ArrangementAtomMatchCondition fun(ArrangementSettingsToken it) {
                return AbstractRearrangerTest.atom(it);
            }
        }));
    }

    @NotNull
    protected static StdArrangementMatchRule rule(@NotNull List<ArrangementAtomMatchCondition> conditions) {
        return AbstractRearrangerTest.rule(conditions.toArray(new ArrangementAtomMatchCondition[conditions.size()]));
    }

    @NotNull
    protected static StdArrangementMatchRule rule(ArrangementAtomMatchCondition ... conditions) {
        ArrangementMatchCondition compositeCondition = ArrangementUtil.combine((ArrangementMatchCondition[])conditions);
        return new StdArrangementMatchRule(new StdArrangementEntryMatcher(compositeCondition));
    }

    @NotNull
    protected static StdArrangementMatchRule ruleWithOrder(@NotNull ArrangementSettingsToken orderType, @NotNull StdArrangementMatchRule rule) {
        return new StdArrangementMatchRule(rule.getMatcher(), orderType);
    }

    @NotNull
    protected static ArrangementAtomMatchCondition atom(@NotNull ArrangementSettingsToken token) {
        return new ArrangementAtomMatchCondition(token);
    }

    protected static ArrangementAtomMatchCondition atom(@NotNull ArrangementSettingsToken token, boolean included) {
        return new ArrangementAtomMatchCondition(token, (Object)included);
    }

    @NotNull
    protected static ArrangementAtomMatchCondition atom(@NotNull String nameFilter) {
        return new ArrangementAtomMatchCondition((ArrangementSettingsToken)StdArrangementTokens.Regexp.NAME, (Object)nameFilter);
    }

    protected void doTest(@NotNull Map<String, ?> args) {
        String text = (String)args.get("initial");
        String expected = (String)args.get("expected");
        List<TextRange> ranges = (List<TextRange>)args.get("ranges");
        Info info = AbstractRearrangerTest.parse(text);
        if (!AbstractRearrangerTest.isEmpty(ranges) && !AbstractRearrangerTest.isEmpty(info.ranges)) {
            AbstractRearrangerTest.fail((String)("Duplicate ranges set: explicit: " + ranges + ", " + "derived: " + info.ranges + ", text:\n" + text));
        }
        if (AbstractRearrangerTest.isEmpty(info.ranges)) {
            info.ranges = !AbstractRearrangerTest.isEmpty(ranges) ? ranges : Arrays.asList(TextRange.from((int)0, (int)text.length()));
        }
        this.myFixture.configureByText(this.fileType, info.text);
        final FoldingModel foldingModel = this.myFixture.getEditor().getFoldingModel();
        for (final FoldingInfo foldingInfo : info.foldings) {
            foldingModel.runBatchFoldingOperation(new Runnable(){

                @Override
                public void run() {
                    FoldRegion region = foldingModel.addFoldRegion(foldingInfo.start, foldingInfo.end, foldingInfo.placeholder);
                    if (region != null) {
                        region.setExpanded(false);
                    }
                }
            });
        }
        List groupingRules = (List)args.get("groups");
        if (groupingRules == null) {
            groupingRules = Collections.emptyList();
        }
        List rules = (List)args.get("rules");
        List<ArrangementSectionRule> sectionRules = this.getSectionRules(rules);
        List aliases = (List)args.get("aliases");
        CommonCodeStyleSettings settings = CodeStyleSettingsManager.getInstance((Project)this.myFixture.getProject()).getCurrentSettings().getCommonSettings(this.language);
        StdArrangementSettings arrangementSettings = aliases == null ? new StdArrangementSettings(groupingRules, sectionRules) : new StdArrangementExtendableSettings(groupingRules, sectionRules, (Collection)aliases);
        settings.setArrangementSettings((ArrangementSettings)arrangementSettings);
        ArrangementEngine engine = (ArrangementEngine)ServiceManager.getService((Project)this.myFixture.getProject(), ArrangementEngine.class);
        engine.arrange(this.myFixture.getEditor(), this.myFixture.getFile(), info.ranges);
        info = AbstractRearrangerTest.parse(expected);
        AbstractRearrangerTest.assertEquals((String)info.text, (String)this.myFixture.getEditor().getDocument().getText());
        for (FoldingInfo it : info.foldings) {
            FoldRegion foldRegion = foldingModel.getCollapsedRegionAtOffset(it.start);
            AbstractRearrangerTest.assertNotNull((String)("Expected to find fold region at offset " + it.start), (Object)foldRegion);
            AbstractRearrangerTest.assertEquals((int)it.end, (int)foldRegion.getEndOffset());
        }
    }

    protected List<ArrangementSectionRule> getSectionRules(List<?> rules) {
        List sectionRules = Collections.emptyList();
        if (rules != null) {
            sectionRules = ContainerUtil.map(rules, (Function)new Function<Object, ArrangementSectionRule>(){

                public ArrangementSectionRule fun(Object o) {
                    return o instanceof ArrangementSectionRule ? (ArrangementSectionRule)o : ArrangementSectionRule.create((StdArrangementMatchRule[])new StdArrangementMatchRule[]{(StdArrangementMatchRule)o});
                }
            });
        }
        return sectionRules;
    }

    private static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    @NotNull
    private static Info parse(@NotNull String text) {
        Info result = new Info();
        StringBuilder buffer = new StringBuilder(text);
        int offset = 0;
        while (offset < buffer.length()) {
            RichTextHandler handler2 = null;
            int richTextMarkStart = -1;
            for (RichTextHandler h : RICH_TEXT_HANDLERS) {
                int i = buffer.indexOf("<" + h.getMarker(), offset);
                if (i < 0 || handler2 != null && i >= richTextMarkStart) continue;
                richTextMarkStart = i;
                handler2 = h;
            }
            if (handler2 == null) break;
            String marker = handler2.getMarker();
            int attrStart = richTextMarkStart + marker.length() + 1;
            int openingTagEnd = buffer.indexOf(">", richTextMarkStart);
            int openTagLength = openingTagEnd - richTextMarkStart + 1;
            Map<String, String> attributes = AbstractRearrangerTest.parseAttributes(buffer.substring(attrStart, openingTagEnd));
            String closingTag = "</" + marker + ">";
            int closingTagStart = buffer.indexOf(closingTag);
            assert (closingTagStart > 0);
            handler2.handle(result, attributes, richTextMarkStart, closingTagStart - openTagLength);
            buffer.delete(closingTagStart, closingTagStart + closingTag.length());
            buffer.delete(richTextMarkStart, openingTagEnd + 1);
            offset = closingTagStart - openTagLength;
        }
        result.text = buffer.toString();
        return result;
    }

    @NotNull
    private static Map<String, String> parseAttributes(@NotNull String text) {
        if (text.isEmpty()) {
            return Collections.emptyMap();
        }
        Matcher matcher = ATTRIBUTE_PATTERN.matcher(text);
        LinkedHashMap result = ContainerUtil.newLinkedHashMap();
        while (matcher.find()) {
            result.put(matcher.group(1), matcher.group(2));
        }
        return result;
    }
}

