/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.Bottom;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeVariable;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiTypeVisitorEx;
import com.intellij.psi.PsiWildcardType;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiTypeMapper
extends PsiTypeVisitorEx<PsiType> {
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.PsiTypeMapper");

    @Nullable
    public <T extends PsiType> T mapType(@NotNull T type) {
        return (T)((PsiType)type.accept((PsiTypeVisitor)this));
    }

    public PsiType visitArrayType(PsiArrayType type) {
        PsiType componentType = type.getComponentType();
        PsiType mappedComponent = this.mapType(componentType);
        if (mappedComponent == null) {
            return null;
        }
        if (mappedComponent == componentType) {
            return type;
        }
        return new PsiArrayType(mappedComponent, type.getAnnotationProvider());
    }

    public PsiType visitEllipsisType(PsiEllipsisType type) {
        PsiType componentType = type.getComponentType();
        PsiType mappedComponent = this.mapType(componentType);
        if (mappedComponent == null) {
            return null;
        }
        if (mappedComponent == componentType) {
            return type;
        }
        return new PsiEllipsisType(mappedComponent, type.getAnnotationProvider());
    }

    @Override
    public PsiType visitTypeVariable(PsiTypeVariable var) {
        return var;
    }

    @Override
    public PsiType visitBottom(Bottom bottom) {
        return bottom;
    }

    public PsiType visitCapturedWildcardType(PsiCapturedWildcardType type) {
        return type;
    }

    public abstract PsiType visitClassType(PsiClassType var1);

    public PsiType visitPrimitiveType(PsiPrimitiveType primitiveType) {
        return primitiveType;
    }

    public PsiType visitType(PsiType type) {
        LOG.error((Object)type);
        return null;
    }

    public PsiType visitWildcardType(PsiWildcardType wildcardType) {
        PsiType bound = wildcardType.getBound();
        PsiManager manager = wildcardType.getManager();
        if (bound == null) {
            return PsiWildcardType.createUnbounded((PsiManager)manager);
        }
        if ((bound = this.mapType(bound)) == null) {
            return null;
        }
        return wildcardType.isExtends() ? PsiWildcardType.createExtends((PsiManager)manager, (PsiType)bound) : PsiWildcardType.createSuper((PsiManager)manager, (PsiType)bound);
    }

    @Nullable
    public PsiType visitIntersectionType(PsiIntersectionType intersectionType) {
        List substituted = ContainerUtil.newSmartList();
        for (PsiType component : intersectionType.getConjuncts()) {
            PsiType mapped = this.mapType(component);
            if (mapped == null) {
                return null;
            }
            substituted.add(mapped);
        }
        return PsiIntersectionType.createIntersection((boolean)false, (PsiType[])substituted.toArray(new PsiType[substituted.size()]));
    }

    public PsiType visitDisjunctionType(PsiDisjunctionType disjunctionType) {
        List substituted = ContainerUtil.newSmartList();
        for (PsiType component : disjunctionType.getDisjunctions()) {
            PsiType mapped = this.mapType(component);
            if (mapped == null) {
                return null;
            }
            substituted.add(mapped);
        }
        return disjunctionType.newDisjunctionType(substituted);
    }

    public PsiType visitDiamondType(PsiDiamondType diamondType) {
        return diamondType;
    }
}

