/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.SharedPsiElementImplUtil;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.LocalTimeCounter;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DummyHolderViewProvider
extends UserDataHolderBase
implements FileViewProvider {
    private DummyHolder myHolder;
    private final PsiManager myManager;
    private final long myModificationStamp;
    private final LightVirtualFile myLightVirtualFile = new LightVirtualFile("DummyHolder");

    public DummyHolderViewProvider(@NotNull PsiManager manager) {
        this.myManager = manager;
        this.myModificationStamp = LocalTimeCounter.currentTime();
    }

    @NotNull
    public PsiManager getManager() {
        return this.myManager;
    }

    @Nullable
    public Document getDocument() {
        return FileDocumentManager.getInstance().getDocument(this.getVirtualFile());
    }

    @NotNull
    public CharSequence getContents() {
        return this.myHolder != null ? this.myHolder.getNode().getText() : "";
    }

    @NotNull
    public VirtualFile getVirtualFile() {
        return this.myLightVirtualFile;
    }

    @NotNull
    public Language getBaseLanguage() {
        return this.myHolder.getLanguage();
    }

    @NotNull
    public Set<Language> getLanguages() {
        return Collections.singleton(this.getBaseLanguage());
    }

    public PsiFile getPsi(@NotNull Language target) {
        ((PsiManagerEx)this.myManager).getFileManager().setViewProvider(this.getVirtualFile(), this);
        return target == this.getBaseLanguage() ? this.myHolder : null;
    }

    @NotNull
    public List<PsiFile> getAllFiles() {
        return Collections.singletonList(this.getPsi(this.getBaseLanguage()));
    }

    public void beforeContentsSynchronized() {
    }

    public void contentsSynchronized() {
    }

    public boolean isEventSystemEnabled() {
        return false;
    }

    public boolean isPhysical() {
        return false;
    }

    public long getModificationStamp() {
        return this.myModificationStamp;
    }

    public boolean supportsIncrementalReparse(@NotNull Language rootLanguage) {
        return true;
    }

    public void rootChanged(@NotNull PsiFile psiFile) {
    }

    public void setDummyHolder(@NotNull DummyHolder dummyHolder) {
        this.myHolder = dummyHolder;
        this.myLightVirtualFile.setFileType(dummyHolder.getFileType());
    }

    public FileViewProvider clone() {
        throw new RuntimeException("Clone is not supported for DummyHolderProviders. Use DummyHolder clone directly.");
    }

    public PsiReference findReferenceAt(int offset) {
        return SharedPsiElementImplUtil.findReferenceAt((PsiElement)this.getPsi(this.getBaseLanguage()), offset);
    }

    @Nullable
    public PsiElement findElementAt(int offset, @NotNull Language language) {
        return language == this.getBaseLanguage() ? this.findElementAt(offset) : null;
    }

    public PsiElement findElementAt(int offset, @NotNull Class<? extends Language> lang) {
        if (!lang.isAssignableFrom(this.getBaseLanguage().getClass())) {
            return null;
        }
        return this.findElementAt(offset);
    }

    public PsiReference findReferenceAt(int offsetInElement, @NotNull Language language) {
        return language == this.getBaseLanguage() ? this.findReferenceAt(offsetInElement) : null;
    }

    @NotNull
    public FileViewProvider createCopy(@NotNull VirtualFile copy) {
        throw new RuntimeException("Clone is not supported for DummyHolderProviders. Use DummyHolder clone directly.");
    }

    @NotNull
    public PsiFile getStubBindingRoot() {
        return this.getPsi(this.getBaseLanguage());
    }

    @NotNull
    public FileType getFileType() {
        return this.myLightVirtualFile.getFileType();
    }

    public PsiElement findElementAt(int offset) {
        LeafElement element = ((PsiFileImpl)this.getPsi(this.getBaseLanguage())).calcTreeElement().findLeafElementAt(offset);
        return element != null ? element.getPsi() : null;
    }
}

