/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.project.model.impl.module.content;

import com.intellij.openapi.roots.SourceFolder;
import com.intellij.project.model.impl.module.content.JpsContentEntry;
import com.intellij.project.model.impl.module.content.JpsContentFolderBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class JpsSourceFolder
extends JpsContentFolderBase
implements SourceFolder {
    private final JpsModuleSourceRoot mySourceRoot;

    public JpsSourceFolder(JpsModuleSourceRoot sourceRoot, JpsContentEntry contentEntry) {
        super(sourceRoot.getUrl(), contentEntry);
        this.mySourceRoot = sourceRoot;
    }

    public JpsModuleSourceRoot getSourceRoot() {
        return this.mySourceRoot;
    }

    public boolean isTestSource() {
        return this.mySourceRoot.getRootType() == JavaSourceRootType.TEST_SOURCE || this.mySourceRoot.getRootType() == JavaResourceRootType.TEST_RESOURCE;
    }

    @NotNull
    public String getPackagePrefix() {
        JavaSourceRootProperties properties = this.getJavaProperties();
        return properties != null ? ((JavaSourceRootProperties)properties.getData()).getPackagePrefix() : "";
    }

    @Nullable
    private JavaSourceRootProperties getJavaProperties() {
        if (this.mySourceRoot.getRootType() == JavaSourceRootType.SOURCE) {
            return (JavaSourceRootProperties)this.mySourceRoot.getProperties((JpsModuleSourceRootType)JavaSourceRootType.SOURCE);
        }
        if (this.mySourceRoot.getRootType() == JavaSourceRootType.TEST_SOURCE) {
            return (JavaSourceRootProperties)this.mySourceRoot.getProperties((JpsModuleSourceRootType)JavaSourceRootType.TEST_SOURCE);
        }
        return null;
    }

    public void setPackagePrefix(@NotNull String packagePrefix) {
        JavaSourceRootProperties properties = this.getJavaProperties();
        if (properties != null) {
            properties.setPackagePrefix(packagePrefix);
        }
    }

    @NotNull
    public JpsModuleSourceRootType<?> getRootType() {
        return this.mySourceRoot.getRootType();
    }

    @NotNull
    public JpsModuleSourceRoot getJpsElement() {
        return this.mySourceRoot;
    }
}

