/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui.inspectionsTree;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.ex.Descriptor;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.profile.codeInspection.ui.ToolDescriptors;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionConfigTreeNode
extends DefaultMutableTreeNode {
    private final ClearableLazyValue<Boolean> myProperSetting = new ClearableLazyValue<Boolean>(){

        @NotNull
        protected Boolean compute() {
            ToolDescriptors descriptors = InspectionConfigTreeNode.this.getDescriptors();
            if (descriptors != null) {
                Descriptor defaultDescriptor = descriptors.getDefaultDescriptor();
                return defaultDescriptor.getInspectionProfile().isProperSetting(defaultDescriptor.getToolWrapper().getShortName());
            }
            for (int i = 0; i < InspectionConfigTreeNode.this.getChildCount(); ++i) {
                InspectionConfigTreeNode node = (InspectionConfigTreeNode)InspectionConfigTreeNode.this.getChildAt(i);
                if (!node.isProperSetting()) continue;
                return true;
            }
            return false;
        }
    };

    public InspectionConfigTreeNode(@NotNull Object userObject) {
        super(userObject);
    }

    public HighlightDisplayKey getKey() {
        return this.getDefaultDescriptor().getKey();
    }

    @Nullable
    public Descriptor getDefaultDescriptor() {
        ToolDescriptors descriptors = this.getDescriptors();
        return descriptors == null ? null : descriptors.getDefaultDescriptor();
    }

    @Nullable
    public ToolDescriptors getDescriptors() {
        if (this.userObject instanceof String) {
            return null;
        }
        return (ToolDescriptors)this.userObject;
    }

    @Nullable
    public String getGroupName() {
        return this.userObject instanceof String ? (String)this.userObject : null;
    }

    @Nullable
    public String getScopeName() {
        ToolDescriptors descriptors = this.getDescriptors();
        return descriptors != null ? descriptors.getDefaultScopeToolState().getScopeName() : null;
    }

    public boolean isProperSetting() {
        return (Boolean)this.myProperSetting.getValue();
    }

    public void dropCache() {
        this.myProperSetting.drop();
    }

    @Override
    public String toString() {
        if (this.userObject instanceof ToolDescriptors) {
            return ((ToolDescriptors)this.userObject).getDefaultDescriptor().getText();
        }
        if (this.userObject instanceof Descriptor) {
            return ((Descriptor)this.userObject).getText();
        }
        return super.toString();
    }
}

