/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui.header;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.CheckboxAction;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.profile.codeInspection.ui.header.ManageButtonBuilder;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ManageButton
extends ComboBoxAction
implements DumbAware {
    private final ManageButtonBuilder myBuilder;

    public ManageButton(ManageButtonBuilder builder) {
        this.myBuilder = builder;
        this.getTemplatePresentation().setText("Manage");
        this.setSmallVariant(false);
    }

    public JComponent build() {
        return this.createCustomComponent(this.getTemplatePresentation());
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(JComponent button) {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new ShareWithTeamCheckBoxAction());
        group.addSeparator();
        group.add((AnAction)new CopyAction());
        group.add((AnAction)new RenameAction());
        group.add((AnAction)new DeleteAction());
        group.add((AnAction)new EditDescriptionAction(this.myBuilder.hasDescription()));
        group.add((AnAction)new ExportAction());
        group.addSeparator();
        group.add((AnAction)new ImportAction());
        return group;
    }

    private class ImportAction
    extends AnAction
    implements DumbAware {
        public ImportAction() {
            super("Import...");
        }

        public void actionPerformed(AnActionEvent e) {
            ManageButton.this.myBuilder.doImport();
        }
    }

    private class ExportAction
    extends AnAction
    implements DumbAware {
        public ExportAction() {
            super("Export...");
        }

        public void actionPerformed(AnActionEvent e) {
            ManageButton.this.myBuilder.export();
        }
    }

    private class EditDescriptionAction
    extends AnAction
    implements DumbAware {
        public EditDescriptionAction(boolean hasDescription) {
            super(hasDescription ? "Edit description" : "Add description");
        }

        public void actionPerformed(AnActionEvent e) {
            ManageButton.this.myBuilder.editDescription();
        }

        public void update(@NotNull AnActionEvent e) {
            e.getPresentation().setEnabledAndVisible(ManageButton.this.myBuilder.canEditDescription());
        }
    }

    private class DeleteAction
    extends AnAction
    implements DumbAware {
        public DeleteAction() {
            super("Delete");
        }

        public void actionPerformed(AnActionEvent e) {
            ManageButton.this.myBuilder.delete();
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabledAndVisible(ManageButton.this.myBuilder.canDelete());
        }
    }

    private class RenameAction
    extends AnAction
    implements DumbAware {
        public RenameAction() {
            super("Rename");
        }

        public void actionPerformed(AnActionEvent e) {
            ManageButton.this.myBuilder.rename();
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabledAndVisible(ManageButton.this.myBuilder.canRename());
        }
    }

    private class CopyAction
    extends AnAction
    implements DumbAware {
        public CopyAction() {
            super("Copy");
        }

        public void actionPerformed(AnActionEvent e) {
            ManageButton.this.myBuilder.copy();
        }
    }

    private class ShareWithTeamCheckBoxAction
    extends CheckboxAction
    implements DumbAware {
        public ShareWithTeamCheckBoxAction() {
            super("Copy to Project");
        }

        public boolean isSelected(AnActionEvent e) {
            return ManageButton.this.myBuilder.isProjectLevel();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            ManageButton.this.myBuilder.setIsProjectLevel(state);
        }
    }
}

