/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui.filter;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.actionSystem.ex.CheckboxAction;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.SeverityProvider;
import com.intellij.profile.codeInspection.ui.LevelChooserAction;
import com.intellij.profile.codeInspection.ui.SingleInspectionProfilePanel;
import com.intellij.profile.codeInspection.ui.filter.InspectionsFilter;
import com.intellij.ui.FilterComponent;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.SortedSet;
import org.jetbrains.annotations.NotNull;

public class InspectionFilterAction
extends DefaultActionGroup
implements Toggleable,
DumbAware {
    private static final int MIN_LANGUAGE_COUNT_TO_WRAP = 11;
    private final SeverityRegistrar mySeverityRegistrar;
    private final InspectionsFilter myInspectionsFilter;
    @NotNull
    private final FilterComponent myFilterComponent;
    private final String version = ApplicationInfo.getInstance().getMajorVersion() + (StringUtil.isEmptyOrSpaces((String)StringUtil.trimStart((String)ApplicationInfo.getInstance().getMinorVersion(), (String)"0")) ? "" : "." + ApplicationInfo.getInstance().getMinorVersion());
    private final String presentableVersion = ApplicationNamesInfo.getInstance().getProductName() + " " + this.version;

    public InspectionFilterAction(@NotNull InspectionProfileImpl profile, @NotNull InspectionsFilter inspectionsFilter, @NotNull Project project2, @NotNull FilterComponent filterComponent) {
        super("Filter Inspections", true);
        this.myInspectionsFilter = inspectionsFilter;
        this.myFilterComponent = filterComponent;
        this.mySeverityRegistrar = ((SeverityProvider)profile.getProfileManager()).getOwnSeverityRegistrar();
        this.getTemplatePresentation().setIcon(AllIcons.General.Filter);
        this.tune(profile, project2);
    }

    public void update(AnActionEvent e) {
        super.update(e);
        e.getPresentation().putClientProperty("selected", (Object)(!this.myInspectionsFilter.isEmptyFilter() ? 1 : 0));
    }

    private void tune(InspectionProfileImpl profile, Project project2) {
        this.addAction((AnAction)new ResetFilterAction());
        this.addSeparator();
        if (ApplicationNamesInfo.getInstance().getProductName().contains("IDEA")) {
            this.addAction(new ShowNewInspectionsAction());
        }
        this.addSeparator();
        this.addAction((AnAction)new ShowEnabledOrDisabledInspectionsAction(true));
        this.addAction((AnAction)new ShowEnabledOrDisabledInspectionsAction(false));
        this.addSeparator();
        SortedSet<HighlightSeverity> severities = LevelChooserAction.getSeverities(this.mySeverityRegistrar);
        for (HighlightSeverity highlightSeverity : severities) {
            this.add((AnAction)new ShowWithSpecifiedSeverityInspectionsAction(highlightSeverity));
        }
        this.addSeparator();
        HashSet languageIds = new HashSet();
        for (ScopeToolState scopeToolState : profile.getDefaultStates(project2)) {
            String languageId = scopeToolState.getTool().getLanguage();
            languageIds.add(languageId);
        }
        ArrayList<Language> arrayList = new ArrayList<Language>();
        for (String id : languageIds) {
            Language language;
            if (id == null || (language = Language.findLanguageByID((String)id)) == null) continue;
            arrayList.add(language);
        }
        if (!arrayList.isEmpty()) {
            DefaultActionGroup defaultActionGroup = new DefaultActionGroup("Filter by Language", arrayList.size() >= 11);
            this.add((AnAction)defaultActionGroup);
            Collections.sort(arrayList, new Comparator<Language>(){

                @Override
                public int compare(Language l1, Language l2) {
                    return l1.getDisplayName().compareTo(l2.getDisplayName());
                }
            });
            for (Language language : arrayList) {
                defaultActionGroup.add((AnAction)new LanguageFilterAction(language));
            }
            defaultActionGroup.add((AnAction)new LanguageFilterAction(null));
            this.addSeparator();
        }
        this.add((AnAction)new ShowAvailableOnlyOnAnalyzeInspectionsAction());
        this.add((AnAction)new ShowOnlyCleanupInspectionsAction());
    }

    private class ShowNewInspectionsAction
    extends AnAction {
        private ShowNewInspectionsAction() {
            super("Show New Inspections in " + InspectionFilterAction.this.presentableVersion, "Shows new inspections which are available since " + InspectionFilterAction.this.presentableVersion, AllIcons.Actions.Lightning);
        }

        public void actionPerformed(AnActionEvent e) {
            InspectionFilterAction.this.myFilterComponent.setFilter("\"New in " + InspectionFilterAction.this.version + "\"");
        }
    }

    private class LanguageFilterAction
    extends CheckboxAction
    implements DumbAware {
        private final String myLanguageId;

        public LanguageFilterAction(Language language) {
            super(language == null ? "Language is not specified" : language.getDisplayName());
            this.myLanguageId = language == null ? null : language.getID();
        }

        public boolean isSelected(AnActionEvent e) {
            return InspectionFilterAction.this.myInspectionsFilter.containsLanguageId(this.myLanguageId);
        }

        public void setSelected(AnActionEvent e, boolean state) {
            if (state) {
                InspectionFilterAction.this.myInspectionsFilter.addLanguageId(this.myLanguageId);
            } else {
                InspectionFilterAction.this.myInspectionsFilter.removeLanguageId(this.myLanguageId);
            }
        }
    }

    private class ShowEnabledOrDisabledInspectionsAction
    extends CheckboxAction
    implements DumbAware {
        private final Boolean myShowEnabledActions;

        public ShowEnabledOrDisabledInspectionsAction(boolean showEnabledActions) {
            super("Show Only " + (showEnabledActions ? "Enabled" : "Disabled"));
            this.myShowEnabledActions = showEnabledActions;
        }

        public boolean isSelected(AnActionEvent e) {
            return InspectionFilterAction.this.myInspectionsFilter.getSuitableInspectionsStates() == this.myShowEnabledActions;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            boolean previousState = this.isSelected(e);
            InspectionFilterAction.this.myInspectionsFilter.setSuitableInspectionsStates(previousState ? null : this.myShowEnabledActions);
        }
    }

    private class ShowWithSpecifiedSeverityInspectionsAction
    extends CheckboxAction
    implements DumbAware {
        private final HighlightSeverity mySeverity;

        private ShowWithSpecifiedSeverityInspectionsAction(HighlightSeverity severity) {
            super(SingleInspectionProfilePanel.renderSeverity(severity), null, HighlightDisplayLevel.find((HighlightSeverity)severity).getIcon());
            this.mySeverity = severity;
        }

        public boolean isSelected(AnActionEvent e) {
            return InspectionFilterAction.this.myInspectionsFilter.containsSeverity(this.mySeverity);
        }

        public void setSelected(AnActionEvent e, boolean state) {
            if (state) {
                InspectionFilterAction.this.myInspectionsFilter.addSeverity(this.mySeverity);
            } else {
                InspectionFilterAction.this.myInspectionsFilter.removeSeverity(this.mySeverity);
            }
        }
    }

    private class ShowAvailableOnlyOnAnalyzeInspectionsAction
    extends CheckboxAction
    implements DumbAware {
        public ShowAvailableOnlyOnAnalyzeInspectionsAction() {
            super("Show Only \"Available only for Analyze | Inspect Code\"");
        }

        public boolean isSelected(AnActionEvent e) {
            return InspectionFilterAction.this.myInspectionsFilter.isAvailableOnlyForAnalyze();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            InspectionFilterAction.this.myInspectionsFilter.setAvailableOnlyForAnalyze(state);
        }
    }

    private class ShowOnlyCleanupInspectionsAction
    extends CheckboxAction
    implements DumbAware {
        public ShowOnlyCleanupInspectionsAction() {
            super("Show Only Cleanup Inspections");
        }

        public boolean isSelected(AnActionEvent e) {
            return InspectionFilterAction.this.myInspectionsFilter.isShowOnlyCleanupInspections();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            InspectionFilterAction.this.myInspectionsFilter.setShowOnlyCleanupInspections(state);
        }
    }

    private class ResetFilterAction
    extends DumbAwareAction {
        public ResetFilterAction() {
            super("Reset Filter");
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            InspectionFilterAction.this.myInspectionsFilter.reset();
        }

        public void update(@NotNull AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(!InspectionFilterAction.this.myInspectionsFilter.isEmptyFilter());
        }
    }
}

