/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.SeverityUtil;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.SeverityEditorDialog;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.profile.codeInspection.SeverityProvider;
import com.intellij.profile.codeInspection.ui.SingleInspectionProfilePanel;
import com.intellij.profile.codeInspection.ui.table.SeverityRenderer;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class LevelChooserAction
extends ComboBoxAction
implements DumbAware {
    private final SeverityRegistrar mySeverityRegistrar;
    private HighlightSeverity myChosen = null;

    public LevelChooserAction(InspectionProfileImpl profile) {
        this(((SeverityProvider)profile.getProfileManager()).getOwnSeverityRegistrar());
    }

    public LevelChooserAction(SeverityRegistrar severityRegistrar) {
        this.mySeverityRegistrar = severityRegistrar;
    }

    @NotNull
    public DefaultActionGroup createPopupActionGroup(final JComponent anchor) {
        DefaultActionGroup group = new DefaultActionGroup();
        for (HighlightSeverity severity : LevelChooserAction.getSeverities(this.mySeverityRegistrar)) {
            HighlightSeverityAction action = new HighlightSeverityAction(severity);
            if (this.myChosen == null) {
                this.setChosen(action.getSeverity());
            }
            group.add((AnAction)action);
        }
        group.addSeparator();
        group.add((AnAction)new DumbAwareAction("Edit severities..."){

            public void actionPerformed(@NotNull AnActionEvent e) {
                HighlightInfoType type;
                SeverityEditorDialog dlg = new SeverityEditorDialog(anchor, LevelChooserAction.this.myChosen, LevelChooserAction.this.mySeverityRegistrar, true);
                if (dlg.showAndGet() && (type = dlg.getSelectedType()) != null) {
                    HighlightSeverity severity = type.getSeverity(null);
                    LevelChooserAction.this.setChosen(severity);
                    LevelChooserAction.this.onChosen(severity);
                }
            }
        });
        return group;
    }

    public static SortedSet<HighlightSeverity> getSeverities(SeverityRegistrar severityRegistrar) {
        TreeSet<HighlightSeverity> severities = new TreeSet<HighlightSeverity>(severityRegistrar);
        for (SeverityRegistrar.SeverityBasedTextAttributes type : SeverityUtil.getRegisteredHighlightingInfoTypes(severityRegistrar)) {
            severities.add(type.getSeverity());
        }
        severities.add(HighlightSeverity.ERROR);
        severities.add(HighlightSeverity.WARNING);
        severities.add(HighlightSeverity.WEAK_WARNING);
        severities.add(HighlightSeverity.GENERIC_SERVER_ERROR_OR_WARNING);
        return severities;
    }

    protected abstract void onChosen(HighlightSeverity var1);

    public void setChosen(HighlightSeverity severity) {
        this.myChosen = severity;
        Presentation templatePresentation = this.getTemplatePresentation();
        templatePresentation.setText(SingleInspectionProfilePanel.renderSeverity(severity));
        templatePresentation.setIcon(SeverityRenderer.getIcon(HighlightDisplayLevel.find((HighlightSeverity)severity)));
    }

    private class HighlightSeverityAction
    extends DumbAwareAction {
        private final HighlightSeverity mySeverity;

        public HighlightSeverity getSeverity() {
            return this.mySeverity;
        }

        private HighlightSeverityAction(HighlightSeverity severity) {
            this.mySeverity = severity;
            Presentation presentation = this.getTemplatePresentation();
            presentation.setText(SingleInspectionProfilePanel.renderSeverity(severity));
            presentation.setIcon(SeverityRenderer.getIcon(HighlightDisplayLevel.find((HighlightSeverity)severity)));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            HighlightSeverity severity = this.getSeverity();
            LevelChooserAction.this.setChosen(severity);
            LevelChooserAction.this.onChosen(severity);
        }
    }
}

