/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection;

import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.ex.InspectionProfileWrapper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.profile.DefaultProjectProfileManager;
import com.intellij.profile.Profile;
import com.intellij.profile.ProfileEx;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.util.ui.UIUtil;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@State(name="InspectionProjectProfileManager", storages={@Storage(value="inspectionProfiles", stateSplitter=DefaultProjectProfileManager.ProfileStateSplitter.class)})
public class InspectionProjectProfileManagerImpl
extends InspectionProjectProfileManager {
    private final Map<String, InspectionProfileWrapper> myName2Profile = new ConcurrentHashMap<String, InspectionProfileWrapper>();
    private final Map<String, InspectionProfileWrapper> myAppName2Profile = new ConcurrentHashMap<String, InspectionProfileWrapper>();
    private final SeverityRegistrar mySeverityRegistrar;
    private final NamedScopeManager myLocalScopesHolder;
    private NamedScopesHolder.ScopeListener myScopeListener;

    public InspectionProjectProfileManagerImpl(@NotNull Project project2, @NotNull InspectionProfileManager inspectionProfileManager, @NotNull DependencyValidationManager holder, @NotNull NamedScopeManager localScopesHolder) {
        super(project2, inspectionProfileManager, holder);
        this.myLocalScopesHolder = localScopesHolder;
        this.mySeverityRegistrar = new SeverityRegistrar(project2.getMessageBus());
    }

    public static InspectionProjectProfileManagerImpl getInstanceImpl(Project project2) {
        return (InspectionProjectProfileManagerImpl)project2.getComponent(InspectionProjectProfileManager.class);
    }

    @Override
    public boolean isProfileLoaded() {
        InspectionProfile profile = this.getInspectionProfile();
        String name = profile.getName();
        return profile.getProfileManager() == this ? this.myName2Profile.containsKey(name) : this.myAppName2Profile.containsKey(name);
    }

    @NotNull
    public synchronized InspectionProfileWrapper getProfileWrapper() {
        InspectionProfile profile = this.getInspectionProfile();
        String profileName = profile.getName();
        if (profile.getProfileManager() == this) {
            if (!this.myName2Profile.containsKey(profileName)) {
                this.initProfileWrapper((Profile)profile);
            }
            return this.myName2Profile.get(profileName);
        }
        if (!this.myAppName2Profile.containsKey(profileName)) {
            this.initProfileWrapper((Profile)profile);
        }
        return this.myAppName2Profile.get(profileName);
    }

    public InspectionProfileWrapper getProfileWrapper(String profileName) {
        return this.myName2Profile.get(profileName);
    }

    public void updateProfile(@NotNull Profile profile) {
        super.updateProfile(profile);
        this.initProfileWrapper(profile);
    }

    public void deleteProfile(@NotNull String name) {
        super.deleteProfile(name);
        InspectionProfileWrapper profileWrapper = this.myName2Profile.remove(name);
        if (profileWrapper != null) {
            profileWrapper.cleanup(this.myProject);
        }
    }

    public void projectOpened() {
        StartupManager startupManager = StartupManager.getInstance((Project)this.myProject);
        if (startupManager == null) {
            return;
        }
        startupManager.registerPostStartupActivity((Runnable)new DumbAwareRunnable(){

            public void run() {
                final HashSet<Profile> profiles = new HashSet<Profile>();
                profiles.add(InspectionProjectProfileManagerImpl.this.getProjectProfileImpl());
                profiles.addAll(InspectionProjectProfileManagerImpl.this.getProfiles());
                profiles.addAll(InspectionProfileManager.getInstance().getProfiles());
                Application app = ApplicationManager.getApplication();
                Runnable initInspectionProfilesRunnable = new Runnable(){

                    @Override
                    public void run() {
                        for (Profile profile : profiles) {
                            InspectionProjectProfileManagerImpl.this.initProfileWrapper(profile);
                        }
                        InspectionProjectProfileManagerImpl.this.fireProfilesInitialized();
                    }
                };
                if (app.isUnitTestMode() || app.isHeadlessEnvironment()) {
                    initInspectionProfilesRunnable.run();
                    UIUtil.dispatchAllInvocationEvents();
                } else {
                    app.executeOnPooledThread(initInspectionProfilesRunnable);
                }
                InspectionProjectProfileManagerImpl.this.myScopeListener = new NamedScopesHolder.ScopeListener(){

                    public void scopesChanged() {
                        for (Profile profile : InspectionProjectProfileManagerImpl.this.getProfiles()) {
                            ((InspectionProfile)profile).scopesChanged();
                        }
                    }
                };
                InspectionProjectProfileManagerImpl.this.myHolder.addScopeListener(InspectionProjectProfileManagerImpl.this.myScopeListener);
                InspectionProjectProfileManagerImpl.this.myLocalScopesHolder.addScopeListener(InspectionProjectProfileManagerImpl.this.myScopeListener);
                Disposer.register((Disposable)InspectionProjectProfileManagerImpl.this.myProject, (Disposable)new Disposable(){

                    public void dispose() {
                        InspectionProjectProfileManagerImpl.this.myHolder.removeScopeListener(InspectionProjectProfileManagerImpl.this.myScopeListener);
                        InspectionProjectProfileManagerImpl.this.myLocalScopesHolder.removeScopeListener(InspectionProjectProfileManagerImpl.this.myScopeListener);
                    }
                });
            }
        });
    }

    @Override
    public void initProfileWrapper(@NotNull Profile profile) {
        InspectionProfileWrapper wrapper = new InspectionProfileWrapper((InspectionProfile)profile);
        wrapper.init(this.myProject);
        String profileName = profile.getName();
        if (profile.getProfileManager() == this) {
            this.myName2Profile.put(profileName, wrapper);
        } else {
            this.myAppName2Profile.put(profileName, wrapper);
        }
    }

    public void projectClosed() {
        Application app = ApplicationManager.getApplication();
        Runnable cleanupInspectionProfilesRunnable = new Runnable(){

            @Override
            public void run() {
                for (InspectionProfileWrapper wrapper : InspectionProjectProfileManagerImpl.this.myName2Profile.values()) {
                    wrapper.cleanup(InspectionProjectProfileManagerImpl.this.myProject);
                }
                for (InspectionProfileWrapper wrapper : InspectionProjectProfileManagerImpl.this.myAppName2Profile.values()) {
                    wrapper.cleanup(InspectionProjectProfileManagerImpl.this.myProject);
                }
                InspectionProjectProfileManagerImpl.this.fireProfilesShutdown();
            }
        };
        if (app.isUnitTestMode() || app.isHeadlessEnvironment()) {
            cleanupInspectionProfilesRunnable.run();
        } else {
            app.executeOnPooledThread(cleanupInspectionProfilesRunnable);
        }
    }

    @Override
    @NotNull
    public SeverityRegistrar getSeverityRegistrar() {
        return this.mySeverityRegistrar;
    }

    @Override
    @NotNull
    public SeverityRegistrar getOwnSeverityRegistrar() {
        return this.mySeverityRegistrar;
    }

    public void loadState(Element state) {
        try {
            this.mySeverityRegistrar.readExternal(state);
        }
        catch (Throwable e) {
            LOG.error(e);
        }
        super.loadState(state);
    }

    public Element getState() {
        Element state = super.getState();
        this.mySeverityRegistrar.writeExternal(state);
        return state;
    }

    @Override
    public Profile getProfile(@NotNull String name) {
        return this.getProfile(name, true);
    }

    public void convert(Element element) {
        super.convert(element);
        if (this.getProjectProfile() != null) {
            ((ProfileEx)this.getProjectProfileImpl()).convert(element, this.getProject());
        }
    }
}

