/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection;

import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolRegistrar;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.profile.Profile;
import com.intellij.profile.ProfileManager;
import java.io.File;
import java.io.IOException;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionProfileLoadUtil {
    @NonNls
    private static final String PROFILE_NAME_TAG = "profile_name";
    @NonNls
    public static final String PROFILE_TAG = "profile";

    private static String getProfileName(@NotNull File file2, @NotNull Element element) {
        String name = InspectionProfileLoadUtil.getRootElementAttribute(PROFILE_NAME_TAG, element);
        return name != null ? name : FileUtil.getNameWithoutExtension((File)file2);
    }

    private static String getRootElementAttribute(@NotNull Element element, @NonNls String name) {
        return element.getAttributeValue(name);
    }

    @Nullable
    private static String getRootElementAttribute(@NonNls String name, @NotNull Element element) {
        return InspectionProfileLoadUtil.getRootElementAttribute(element, name);
    }

    @NotNull
    public static String getProfileName(@NotNull Element element) {
        String name = InspectionProfileLoadUtil.getRootElementAttribute(element, PROFILE_NAME_TAG);
        if (name != null) {
            return name;
        }
        return "unnamed";
    }

    @NotNull
    public static Profile load(@NotNull File file2, @NotNull InspectionToolRegistrar registrar, @NotNull ProfileManager profileManager) throws JDOMException, IOException, InvalidDataException {
        Element element = JDOMUtil.loadDocument((File)file2).getRootElement();
        InspectionProfileImpl profile = new InspectionProfileImpl(InspectionProfileLoadUtil.getProfileName(file2, element), registrar, profileManager);
        Element profileElement = element.getChild(PROFILE_TAG);
        if (profileElement != null) {
            element = profileElement;
        }
        profile.readExternal(element);
        return profile;
    }
}

