/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile;

import com.intellij.openapi.project.Project;
import com.intellij.profile.Profile;
import com.intellij.profile.ProfileManager;
import com.intellij.util.xmlb.SmartSerializer;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.Transient;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public abstract class ProfileEx
implements Profile {
    public static final String SCOPE = "scope";
    public static final String NAME = "name";
    private final SmartSerializer mySerializer;
    @NotNull
    protected String myName;
    @OptionTag(value="myLocal")
    private boolean myLocal;
    protected ProfileManager myProfileManager;
    private boolean myIsProjectLevel;

    public ProfileEx(@NotNull String name) {
        this(name, SmartSerializer.skipEmptySerializer());
    }

    protected ProfileEx(@NotNull String name, @NotNull SmartSerializer serializer) {
        this.myName = name;
        this.mySerializer = serializer;
    }

    @OptionTag(value="myName")
    @NotNull
    public String getName() {
        return this.myName;
    }

    public void copyFrom(@NotNull Profile profile) {
        Element config = new Element("config");
        profile.writeExternal(config);
        this.readExternal(config);
    }

    @Transient
    public boolean isLocal() {
        return !this.myIsProjectLevel;
    }

    @Transient
    public boolean isProjectLevel() {
        return this.myIsProjectLevel;
    }

    public void setProjectLevel(boolean isProjectLevel) {
        this.myIsProjectLevel = isProjectLevel;
    }

    public void setLocal(boolean isLocal) {
        this.myIsProjectLevel = !isLocal;
    }

    public void setName(@NotNull String name) {
        this.myName = name;
    }

    @Transient
    @NotNull
    public ProfileManager getProfileManager() {
        return this.myProfileManager;
    }

    public void setProfileManager(@NotNull ProfileManager profileManager) {
        this.myProfileManager = profileManager;
    }

    public void readExternal(Element element) {
        this.mySerializer.readExternal((Object)this, element);
    }

    public void serializeInto(@NotNull Element element, boolean preserveCompatibility) {
        this.mySerializer.writeExternal((Object)this, element, preserveCompatibility);
    }

    public void writeExternal(Element element) {
        this.serializeInto(element, true);
    }

    public void profileChanged() {
    }

    public boolean equals(Object o) {
        return this == o || o instanceof ProfileEx && this.myName.equals(((ProfileEx)o).myName);
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    public int compareTo(@NotNull Object o) {
        if (o instanceof Profile) {
            return this.getName().compareToIgnoreCase(((Profile)o).getName());
        }
        return 0;
    }

    public void convert(@NotNull Element element, @NotNull Project project2) {
    }
}

