/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pom.xml.impl.events;

import com.intellij.pom.PomModel;
import com.intellij.pom.event.PomChangeSet;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.xml.XmlAspect;
import com.intellij.pom.xml.events.XmlChange;
import com.intellij.pom.xml.events.XmlDocumentChanged;
import com.intellij.pom.xml.impl.XmlAspectChangeSetImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import org.jetbrains.annotations.NotNull;

public class XmlDocumentChangedImpl
implements XmlDocumentChanged {
    private final XmlDocument myDocument;

    public XmlDocumentChangedImpl(@NotNull XmlDocument document) {
        this.myDocument = document;
    }

    public XmlDocument getDocument() {
        return this.myDocument;
    }

    public static PomModelEvent createXmlDocumentChanged(PomModel source, XmlDocument document) {
        PomModelEvent event = new PomModelEvent(source);
        XmlFile xmlFile = (XmlFile)PsiTreeUtil.getParentOfType((PsiElement)document, XmlFile.class);
        XmlAspectChangeSetImpl xmlAspectChangeSet = new XmlAspectChangeSetImpl(source, xmlFile);
        xmlAspectChangeSet.add((XmlChange)new XmlDocumentChangedImpl(document));
        event.registerChangeSet(source.getModelAspect(XmlAspect.class), (PomChangeSet)xmlAspectChangeSet);
        return event;
    }

    public String toString() {
        return "Xml document changed";
    }
}

