/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.templates.github;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.templates.github.DownloadUtil;
import com.intellij.platform.templates.github.GeneratorException;
import com.intellij.platform.templates.github.Outcome;
import com.intellij.util.NullableFunction;
import com.intellij.util.Producer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.concurrent.Callable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ZipUtil {
    private static final Logger LOG = Logger.getInstance(ZipUtil.class);

    public static void unzipWithProgressSynchronously(@Nullable Project project2, @NotNull String progressTitle, @NotNull File zipArchive, @NotNull File extractToDir, boolean unwrapSingleTopLevelFolder) throws GeneratorException {
        ZipUtil.unzipWithProgressSynchronously(project2, progressTitle, zipArchive, extractToDir, null, unwrapSingleTopLevelFolder);
    }

    public static void unzipWithProgressSynchronously(@Nullable Project project2, @NotNull String progressTitle, final @NotNull File zipArchive, final @NotNull File extractToDir, final @Nullable NullableFunction<String, String> pathConvertor, final boolean unwrapSingleTopLevelFolder) throws GeneratorException {
        Outcome<Boolean> outcome = DownloadUtil.provideDataWithProgressSynchronously(project2, progressTitle, "Unpacking ...", new Callable<Boolean>(){

            @Override
            public Boolean call() throws IOException {
                ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
                ZipUtil.unzip(progress, extractToDir, zipArchive, (NullableFunction<String, String>)pathConvertor, null, unwrapSingleTopLevelFolder);
                return true;
            }
        }, new Producer<Boolean>(){

            public Boolean produce() {
                return false;
            }
        });
        Boolean result = outcome.get();
        if (result == null) {
            Exception e = outcome.getException();
            if (e != null) {
                throw new GeneratorException("Unpacking failed, downloaded archive is broken");
            }
            throw new GeneratorException("Unpacking was cancelled");
        }
    }

    private static File getUnzipToDir(@Nullable ProgressIndicator progress, @NotNull File targetDir, boolean unwrapSingleTopLevelFolder) throws IOException {
        if (progress != null) {
            progress.setText("Extracting...");
        }
        if (unwrapSingleTopLevelFolder) {
            return FileUtil.createTempDirectory((String)"unzip-dir-", null);
        }
        return targetDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(@Nullable ProgressIndicator progress, @NotNull File targetDir, @NotNull File zipArchive, @Nullable NullableFunction<String, String> pathConvertor, @Nullable ContentProcessor contentProcessor, boolean unwrapSingleTopLevelFolder) throws IOException {
        File unzipToDir = ZipUtil.getUnzipToDir(progress, targetDir, unwrapSingleTopLevelFolder);
        try (ZipFile zipFile = new ZipFile(zipArchive, 1);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                InputStream entryContentStream = zipFile.getInputStream(entry);
                ZipUtil.unzipEntryToDir(progress, entry, entryContentStream, unzipToDir, pathConvertor, contentProcessor);
                entryContentStream.close();
            }
        }
        ZipUtil.doUnwrapSingleTopLevelFolder(unwrapSingleTopLevelFolder, unzipToDir, targetDir);
    }

    public static void unzip(@Nullable ProgressIndicator progress, @NotNull File targetDir, @NotNull ZipInputStream stream, @Nullable NullableFunction<String, String> pathConvertor, @Nullable ContentProcessor contentProcessor, boolean unwrapSingleTopLevelFolder) throws IOException {
        ZipEntry entry;
        File unzipToDir = ZipUtil.getUnzipToDir(progress, targetDir, unwrapSingleTopLevelFolder);
        while ((entry = stream.getNextEntry()) != null) {
            ZipUtil.unzipEntryToDir(progress, entry, stream, unzipToDir, pathConvertor, contentProcessor);
        }
        ZipUtil.doUnwrapSingleTopLevelFolder(unwrapSingleTopLevelFolder, unzipToDir, targetDir);
    }

    private static void doUnwrapSingleTopLevelFolder(boolean unwrapSingleTopLevelFolder, @NotNull File unzipToDir, @NotNull File targetDir) throws IOException {
        if (unwrapSingleTopLevelFolder) {
            File[] topLevelFiles = unzipToDir.listFiles();
            File dirToMove = topLevelFiles != null && topLevelFiles.length == 1 && topLevelFiles[0].isDirectory() ? topLevelFiles[0] : unzipToDir;
            FileUtil.copyDirContent((File)dirToMove, (File)targetDir);
            FileUtil.delete((File)unzipToDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unzipEntryToDir(@Nullable ProgressIndicator progress, @NotNull ZipEntry zipEntry, @NotNull InputStream entryContentStream, @NotNull File extractToDir, @Nullable NullableFunction<String, String> pathConvertor, @Nullable ContentProcessor contentProcessor) throws IOException {
        File dir;
        String relativeExtractPath = ZipUtil.createRelativeExtractPath(zipEntry);
        if (pathConvertor != null && (relativeExtractPath = (String)pathConvertor.fun((Object)relativeExtractPath)) == null) {
            return;
        }
        File child = new File(extractToDir, relativeExtractPath);
        File file2 = dir = zipEntry.isDirectory() ? child : child.getParentFile();
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Unable to create dir: '" + dir + "'!");
        }
        if (zipEntry.isDirectory()) {
            return;
        }
        if (progress != null) {
            progress.setText("Extracting " + relativeExtractPath + " ...");
        }
        if (contentProcessor == null) {
            try (FileOutputStream fileOutputStream = new FileOutputStream(child);){
                FileUtil.copy((InputStream)entryContentStream, (OutputStream)fileOutputStream);
            }
        } else {
            byte[] content = contentProcessor.processContent(FileUtil.loadBytes((InputStream)entryContentStream), child);
            if (content != null) {
                FileUtil.writeToFile((File)child, (byte[])content);
            }
        }
        LOG.info("Extract: " + relativeExtractPath);
    }

    @NotNull
    private static String createRelativeExtractPath(@NotNull ZipEntry zipEntry) {
        String name = StringUtil.trimStart((String)zipEntry.getName(), (String)"/");
        return StringUtil.trimEnd((String)name, (String)"/");
    }

    public static interface ContentProcessor {
        @Nullable
        public byte[] processContent(byte[] var1, File var2) throws IOException;
    }
}

