/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.templates;

import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.platform.templates.ArchivedProjectTemplate;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.Icon;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalArchivedTemplate
extends ArchivedProjectTemplate {
    public static final String DESCRIPTION_PATH = ".idea/description.html";
    static final String TEMPLATE_DESCRIPTOR = ".idea/project-template.xml";
    private final URL myArchivePath;
    private final ModuleType myModuleType;
    private Icon myIcon;

    public LocalArchivedTemplate(@NotNull URL archivePath, @NotNull ClassLoader classLoader) {
        super(LocalArchivedTemplate.getTemplateName(archivePath), null);
        this.myArchivePath = archivePath;
        this.myModuleType = LocalArchivedTemplate.computeModuleType(this);
        String s = this.readEntry(TEMPLATE_DESCRIPTOR);
        if (s != null) {
            try {
                Element templateElement = JDOMUtil.loadDocument((CharSequence)s).getRootElement();
                this.populateFromElement(templateElement);
                String iconPath = templateElement.getChildText("icon-path");
                if (iconPath != null) {
                    this.myIcon = IconLoader.findIcon((String)iconPath, (ClassLoader)classLoader);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static String getTemplateName(URL url) {
        String fileName = new File(url.getPath()).getName();
        return fileName.substring(0, fileName.length() - ".zip".length()).replace('_', ' ');
    }

    public String getDescription() {
        return this.readEntry(DESCRIPTION_PATH);
    }

    @Override
    public Icon getIcon() {
        return this.myIcon == null ? super.getIcon() : this.myIcon;
    }

    @Nullable
    String readEntry(final @NotNull String endsWith) {
        try {
            return this.processStream(new ArchivedProjectTemplate.StreamProcessor<String>(){

                @Override
                public String consume(@NotNull ZipInputStream stream) throws IOException {
                    ZipEntry entry;
                    while ((entry = stream.getNextEntry()) != null) {
                        if (!entry.getName().endsWith(endsWith)) continue;
                        return StreamUtil.readText((InputStream)stream, (Charset)CharsetToolkit.UTF8_CHARSET);
                    }
                    return null;
                }
            });
        }
        catch (IOException ignored) {
            return null;
        }
    }

    @NotNull
    private static ModuleType computeModuleType(LocalArchivedTemplate template) {
        String iml = template.readEntry(".iml");
        if (iml == null) {
            return ModuleType.EMPTY;
        }
        try {
            Document document = JDOMUtil.loadDocument((CharSequence)iml);
            String type = document.getRootElement().getAttributeValue("type");
            return ModuleTypeManager.getInstance().findByID(type);
        }
        catch (Exception e) {
            return ModuleType.EMPTY;
        }
    }

    @Override
    protected ModuleType getModuleType() {
        return this.myModuleType;
    }

    @Override
    public <T> T processStream(@NotNull ArchivedProjectTemplate.StreamProcessor<T> consumer) throws IOException {
        return LocalArchivedTemplate.consumeZipStream(consumer, new ZipInputStream(this.myArchivePath.openStream()));
    }

    public URL getArchivePath() {
        return this.myArchivePath;
    }
}

