/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.templates;

import com.intellij.icons.AllIcons;
import com.intellij.ide.fileTemplates.impl.UrlUtil;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.platform.ProjectTemplate;
import com.intellij.platform.ProjectTemplatesFactory;
import com.intellij.platform.templates.LocalArchivedTemplate;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashMap;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArchivedTemplatesFactory
extends ProjectTemplatesFactory {
    private static final Logger LOG = Logger.getInstance(ArchivedTemplatesFactory.class);
    static final String ZIP = ".zip";
    private final ClearableLazyValue<MultiMap<String, Pair<URL, ClassLoader>>> myGroups = new ClearableLazyValue<MultiMap<String, Pair<URL, ClassLoader>>>(){

        @NotNull
        protected MultiMap<String, Pair<URL, ClassLoader>> compute() {
            MultiMap map = MultiMap.createSmart();
            THashMap urls = new THashMap();
            URL configURL = ArchivedTemplatesFactory.getCustomTemplatesURL();
            urls.put(configURL, ClassLoader.getSystemClassLoader());
            for (Map.Entry url : urls.entrySet()) {
                try {
                    List<String> children2 = UrlUtil.getChildrenRelativePaths((URL)url.getKey());
                    if (configURL == url.getKey() && !children2.isEmpty()) {
                        map.putValue((Object)"User-defined", (Object)Pair.create(url.getKey(), url.getValue()));
                        continue;
                    }
                    for (String child : children2) {
                        int index = child.indexOf(47);
                        if (index != -1) {
                            child = child.substring(0, index);
                        }
                        String name = child.replace('_', ' ');
                        map.putValue((Object)name, (Object)Pair.create((Object)new URL(((URL)url.getKey()).toExternalForm() + "/" + child), url.getValue()));
                    }
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
            return map;
        }
    };

    @NotNull
    private static URL getCustomTemplatesURL() {
        try {
            return new File(ArchivedTemplatesFactory.getCustomTemplatesPath()).toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    static String getCustomTemplatesPath() {
        return PathManager.getConfigPath() + "/projectTemplates";
    }

    public static File getTemplateFile(String name) {
        return new File(ArchivedTemplatesFactory.getCustomTemplatesPath() + "/" + name + ZIP);
    }

    @Override
    @NotNull
    public String[] getGroups() {
        this.myGroups.drop();
        Set groups = ((MultiMap)this.myGroups.getValue()).keySet();
        return ArrayUtil.toStringArray((Collection)groups);
    }

    @Override
    @NotNull
    public ProjectTemplate[] createTemplates(@Nullable String group, WizardContext context) {
        if (group == null) {
            return ProjectTemplate.EMPTY_ARRAY;
        }
        List templates = null;
        for (Pair url : ((MultiMap)this.myGroups.getValue()).get((Object)group)) {
            try {
                for (String child : UrlUtil.getChildrenRelativePaths((URL)url.first)) {
                    if (!child.endsWith(ZIP)) continue;
                    if (templates == null) {
                        templates = new SmartList();
                    }
                    templates.add(new LocalArchivedTemplate(new URL(((URL)url.first).toExternalForm() + '/' + child), (ClassLoader)url.second));
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        return ContainerUtil.isEmpty(templates) ? ProjectTemplate.EMPTY_ARRAY : templates.toArray(new ProjectTemplate[templates.size()]);
    }

    @Override
    public int getGroupWeight(String group) {
        return "User-defined".equals(group) ? -2 : 0;
    }

    @Override
    public Icon getGroupIcon(String group) {
        return "User-defined".equals(group) ? AllIcons.Modules.Types.UserDefined : super.getGroupIcon(group);
    }
}

