/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.templates;

import com.intellij.facet.frameworks.beans.Artifact;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ProjectTemplateParameterFactory;
import com.intellij.ide.util.projectWizard.WizardInputField;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.platform.ProjectTemplate;
import com.intellij.platform.templates.TemplateModuleBuilder;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipInputStream;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="template")
public abstract class ArchivedProjectTemplate
implements ProjectTemplate {
    public static final String INPUT_FIELD = "input-field";
    protected final String myDisplayName;
    @Nullable
    private final String myCategory;
    private List<WizardInputField> myInputFields = Collections.emptyList();
    private List<String> myFrameworks = new ArrayList<String>();
    private List<Artifact> myArtifacts = new ArrayList<Artifact>();

    public ArchivedProjectTemplate(@NotNull String displayName, @Nullable String category) {
        this.myDisplayName = displayName;
        this.myCategory = category;
    }

    @NotNull
    public String getName() {
        return this.myDisplayName;
    }

    public Icon getIcon() {
        return this.getModuleType().getIcon();
    }

    protected abstract ModuleType getModuleType();

    @NotNull
    public ModuleBuilder createModuleBuilder() {
        return new TemplateModuleBuilder(this, this.getModuleType(), this.getInputFields());
    }

    @NotNull
    public List<WizardInputField> getInputFields() {
        return this.myInputFields;
    }

    @Property(surroundWithTag=false)
    @AbstractCollection(elementTag="artifact", surroundWithTag=false)
    public List<Artifact> getArtifacts() {
        return this.myArtifacts;
    }

    public void setArtifacts(List<Artifact> artifacts) {
        this.myArtifacts = artifacts;
    }

    @Property(surroundWithTag=false)
    @AbstractCollection(elementTag="framework", surroundWithTag=false, elementValueAttribute="")
    @NotNull
    public List<String> getFrameworks() {
        return this.myFrameworks;
    }

    public void setFrameworks(List<String> frameworks) {
        this.myFrameworks = frameworks;
    }

    @Nullable
    public ValidationInfo validateSettings() {
        return null;
    }

    public abstract <T> T processStream(@NotNull StreamProcessor<T> var1) throws IOException;

    @Nullable
    public String getCategory() {
        return this.myCategory;
    }

    public void populateFromElement(@NotNull Element element) {
        XmlSerializer.deserializeInto((Object)this, (Element)element);
        this.myInputFields = ArchivedProjectTemplate.getFields(element);
    }

    private static List<WizardInputField> getFields(Element templateElement) {
        return ContainerUtil.mapNotNull((Collection)templateElement.getChildren(INPUT_FIELD), (Function)new Function<Element, WizardInputField>(){

            public WizardInputField fun(Element element) {
                ProjectTemplateParameterFactory factory = WizardInputField.getFactoryById((String)element.getText());
                return factory == null ? null : factory.createField(element.getAttributeValue("default"));
            }
        });
    }

    static <T> T consumeZipStream(@NotNull StreamProcessor<T> consumer, @NotNull ZipInputStream stream) throws IOException {
        try {
            T t = consumer.consume(stream);
            return t;
        }
        finally {
            StreamUtil.closeStream((Closeable)stream);
        }
    }

    public static abstract class StreamProcessor<T> {
        public abstract T consume(@NotNull ZipInputStream var1) throws IOException;
    }
}

