/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform;

import com.intellij.facet.ui.ValidationResult;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.DirectoryProjectGenerator;
import com.intellij.ui.IdeBorderFactory;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WebProjectGenerator<T>
implements DirectoryProjectGenerator<T> {
    @Override
    @NotNull
    @Nls
    public abstract String getName();

    public abstract String getDescription();

    @Nullable
    public Integer getPreferredDescriptionWidth() {
        return null;
    }

    @Nullable
    public String getHelpId() {
        return null;
    }

    @Override
    @NotNull
    public final T showGenerationSettings(VirtualFile baseDir) throws ProcessCanceledException {
        GeneratorPeer<T> peer = this.createPeer();
        MyDialogWrapper dialog = new MyDialogWrapper(peer);
        dialog.show();
        if (dialog.getExitCode() != 0) {
            throw new ProcessCanceledException();
        }
        return peer.getSettings();
    }

    @Override
    public abstract void generateProject(@NotNull Project var1, @NotNull VirtualFile var2, @NotNull T var3, @NotNull Module var4);

    @Override
    @NotNull
    public final ValidationResult validate(@NotNull String baseDirPath) {
        return ValidationResult.OK;
    }

    @NotNull
    public abstract GeneratorPeer<T> createPeer();

    public boolean isPrimaryGenerator() {
        return true;
    }

    private class MyDialogWrapper
    extends DialogWrapper {
        private final GeneratorPeer myPeer;
        private final JComponent myCenterComponent;
        private final JTextPane myDescriptionPane;

        protected MyDialogWrapper(GeneratorPeer<T> peer) {
            super(true);
            this.myPeer = peer;
            this.myCenterComponent = peer.getComponent();
            final Integer preferredDescriptionWidth = WebProjectGenerator.this.getPreferredDescriptionWidth();
            this.myDescriptionPane = preferredDescriptionWidth == null ? new JTextPane() : new JTextPane(){

                @Override
                public Dimension getPreferredSize() {
                    Dimension dimension = super.getPreferredSize();
                    dimension.width = preferredDescriptionWidth;
                    return dimension;
                }
            };
            this.myDescriptionPane.setBorder(IdeBorderFactory.createEmptyBorder((int)5, (int)0, (int)10, (int)0));
            Messages.configureMessagePaneUi((JTextPane)this.myDescriptionPane, (String)WebProjectGenerator.this.getDescription());
            this.getOKAction().setEnabled(peer.validate() == null);
            peer.addSettingsStateListener(new SettingsStateListener(){

                @Override
                public void stateChanged(boolean validSettings) {
                    MyDialogWrapper.this.getOKAction().setEnabled(validSettings);
                }
            });
            this.setTitle(WebProjectGenerator.this.getName());
            this.init();
        }

        @Nullable
        protected String getHelpId() {
            return WebProjectGenerator.this.getHelpId();
        }

        protected boolean postponeValidation() {
            return false;
        }

        protected ValidationInfo doValidate() {
            ValidationInfo validationInfo = this.myPeer.validate();
            if (validationInfo != null && this.myPeer.isBackgroundJobRunning()) {
                return null;
            }
            return validationInfo;
        }

        @Nullable
        protected JComponent createNorthPanel() {
            return this.myDescriptionPane;
        }

        protected JComponent createCenterPanel() {
            return this.myCenterComponent;
        }
    }

    public static interface SettingsStateListener {
        public void stateChanged(boolean var1);
    }

    public static interface GeneratorPeer<T> {
        @NotNull
        public JComponent getComponent();

        public void buildUI(@NotNull SettingsStep var1);

        @NotNull
        public T getSettings();

        @Nullable
        public ValidationInfo validate();

        public boolean isBackgroundJobRunning();

        public void addSettingsStateListener(@NotNull SettingsStateListener var1);
    }
}

