/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ProjectBaseDirectory;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PlatformVcsDetector
implements ProjectComponent {
    private final Project myProject;
    private final ProjectLevelVcsManagerImpl myVcsManager;

    public PlatformVcsDetector(Project project2, ProjectLevelVcsManagerImpl vcsManager) {
        this.myProject = project2;
        this.myVcsManager = vcsManager;
    }

    public void projectOpened() {
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized((Runnable)new DumbAwareRunnable(){

            public void run() {
                DumbAwareRunnable runnable2 = new DumbAwareRunnable(){

                    public void run() {
                        AbstractVcs vcs;
                        VirtualFile file2 = ProjectBaseDirectory.getInstance(PlatformVcsDetector.this.myProject).getBaseDir(PlatformVcsDetector.this.myProject.getBaseDir());
                        if (PlatformVcsDetector.this.myVcsManager.needAutodetectMappings() && (vcs = PlatformVcsDetector.this.myVcsManager.findVersioningVcs(file2)) != null && vcs != PlatformVcsDetector.this.myVcsManager.getVcsFor(file2)) {
                            PlatformVcsDetector.this.myVcsManager.removeDirectoryMapping(new VcsDirectoryMapping("", ""));
                            PlatformVcsDetector.this.myVcsManager.setAutoDirectoryMapping(file2.getPath(), vcs.getName());
                            PlatformVcsDetector.this.myVcsManager.cleanupMappings();
                            PlatformVcsDetector.this.myVcsManager.updateActiveVcss();
                        }
                    }
                };
                ApplicationManager.getApplication().invokeLater((Runnable)runnable2, new Condition(){

                    public boolean value(Object o) {
                        return !PlatformVcsDetector.this.myProject.isOpen() || PlatformVcsDetector.this.myProject.isDisposed();
                    }
                });
            }
        });
    }

    public void projectClosed() {
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        return "PlatformVcsDetector";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }
}

