/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.peer.impl;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.LocalFilePath;
import com.intellij.openapi.vcs.RemoteFilePath;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.actions.VcsContextWrapper;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocalChangeListImpl;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.NotNullFunction;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class VcsContextFactoryImpl
implements VcsContextFactory {
    @NotNull
    public VcsContext createCachedContextOn(@NotNull AnActionEvent event) {
        return VcsContextWrapper.createCachedInstanceOn(event);
    }

    @NotNull
    public VcsContext createContextOn(@NotNull AnActionEvent event) {
        return new VcsContextWrapper(event.getDataContext(), event.getModifiers(), event.getPlace(), event.getPresentation().getText());
    }

    @NotNull
    public FilePath createFilePathOn(@NotNull VirtualFile virtualFile) {
        return this.createFilePath(virtualFile.getPath(), virtualFile.isDirectory());
    }

    @NotNull
    public FilePath createFilePathOn(@NotNull File file2) {
        VirtualFile vf = LocalFileSystem.getInstance().findFileByIoFile(file2);
        return vf != null ? this.createFilePathOn(vf) : this.createFilePath(file2.getPath(), file2.isDirectory());
    }

    @NotNull
    public FilePath createFilePathOn(@NotNull File file2, @NotNull NotNullFunction<File, Boolean> detector) {
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(file2);
        if (virtualFile != null) {
            return this.createFilePathOn(virtualFile);
        }
        return this.createFilePathOn(file2, (Boolean)detector.fun((Object)file2));
    }

    @NotNull
    public FilePath createFilePathOn(@NotNull File file2, boolean isDirectory) {
        return this.createFilePath(file2.getPath(), isDirectory);
    }

    @NotNull
    public FilePath createFilePathOnNonLocal(@NotNull String path, boolean isDirectory) {
        return new RemoteFilePath(path, isDirectory);
    }

    @NotNull
    public FilePath createFilePathOnDeleted(@NotNull File file2, boolean isDirectory) {
        return this.createFilePathOn(file2, isDirectory);
    }

    @NotNull
    public FilePath createFilePathOn(@NotNull VirtualFile parent, @NotNull String name) {
        return this.createFilePath(parent, name, false);
    }

    @NotNull
    public FilePath createFilePath(@NotNull VirtualFile parent, @NotNull String fileName, boolean isDirectory) {
        return this.createFilePath(parent.getPath() + "/" + fileName, isDirectory);
    }

    @NotNull
    public LocalChangeList createLocalChangeList(@NotNull Project project2, @NotNull String name) {
        return LocalChangeListImpl.createEmptyChangeListImpl(project2, name);
    }

    @NotNull
    public FilePath createFilePath(@NotNull String path, boolean isDirectory) {
        return new LocalFilePath(path, isDirectory);
    }
}

