/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.ui;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModulePointer;
import com.intellij.openapi.module.ModuleType;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.TreeNodePresentation;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PlatformIcons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleElementPresentation
extends TreeNodePresentation {
    private final ModulePointer myModulePointer;
    private final ArtifactEditorContext myContext;
    private final boolean myTestOutput;

    public ModuleElementPresentation(@Nullable ModulePointer modulePointer, @NotNull ArtifactEditorContext context, boolean testOutput) {
        this.myModulePointer = modulePointer;
        this.myContext = context;
        this.myTestOutput = testOutput;
    }

    public String getPresentableName() {
        return this.myModulePointer != null ? this.myModulePointer.getModuleName() : "<unknown>";
    }

    public boolean canNavigateToSource() {
        return this.findModule() != null;
    }

    @Nullable
    private Module findModule() {
        return this.myModulePointer != null ? this.myModulePointer.getModule() : null;
    }

    public void navigateToSource() {
        Module module2 = this.findModule();
        if (module2 != null) {
            this.myContext.selectModule(module2);
        }
    }

    public void render(@NotNull PresentationData presentationData, SimpleTextAttributes mainAttributes, SimpleTextAttributes commentAttributes) {
        String moduleName;
        Module module2 = this.findModule();
        if (this.myTestOutput) {
            presentationData.setIcon(PlatformIcons.TEST_SOURCE_FOLDER);
        } else if (module2 != null) {
            presentationData.setIcon(ModuleType.get((Module)module2).getIcon());
        }
        if (module2 != null) {
            String newName;
            moduleName = module2.getName();
            ModifiableModuleModel moduleModel = this.myContext.getModifiableModuleModel();
            if (moduleModel != null && (newName = moduleModel.getNewName(module2)) != null) {
                moduleName = newName;
            }
        } else {
            moduleName = this.myModulePointer != null ? this.myModulePointer.getModuleName() : "<unknown>";
        }
        String text = this.myTestOutput ? CompilerBundle.message((String)"node.text.0.test.compile.output", (Object[])new Object[]{moduleName}) : CompilerBundle.message((String)"node.text.0.compile.output", (Object[])new Object[]{moduleName});
        presentationData.addText(text, module2 != null ? mainAttributes : SimpleTextAttributes.ERROR_ATTRIBUTES);
    }

    public int getWeight() {
        return 20;
    }
}

