/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.run;

import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.ConfigurationSettingsEditorWrapper;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerFilter;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactAdapter;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactPointer;
import com.intellij.packaging.artifacts.ArtifactPointerManager;
import com.intellij.packaging.impl.compiler.ArtifactCompileScope;
import com.intellij.packaging.impl.run.ArtifactChooser;
import com.intellij.packaging.impl.run.BuildArtifactsBeforeRunTask;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class BuildArtifactsBeforeRunTaskProvider
extends BeforeRunTaskProvider<BuildArtifactsBeforeRunTask> {
    @NonNls
    public static final String BUILD_ARTIFACTS_ID = "BuildArtifacts";
    public static final Key<BuildArtifactsBeforeRunTask> ID = Key.create((String)"BuildArtifacts");
    private final Project myProject;

    public BuildArtifactsBeforeRunTaskProvider(Project project2) {
        this.myProject = project2;
        project2.getMessageBus().connect().subscribe(ArtifactManager.TOPIC, (Object)new ArtifactAdapter(){

            public void artifactRemoved(@NotNull Artifact artifact) {
                RunManagerEx runManager = RunManagerEx.getInstanceEx(BuildArtifactsBeforeRunTaskProvider.this.myProject);
                for (RunConfiguration configuration : runManager.getAllConfigurationsList()) {
                    List<BuildArtifactsBeforeRunTask> tasks = runManager.getBeforeRunTasks(configuration, ID);
                    for (BuildArtifactsBeforeRunTask task : tasks) {
                        ArtifactPointer[] pointers;
                        String artifactName = artifact.getName();
                        List<ArtifactPointer> pointersList = task.getArtifactPointers();
                        for (ArtifactPointer pointer : pointers = pointersList.toArray(new ArtifactPointer[pointersList.size()])) {
                            if (!pointer.getArtifactName().equals(artifactName) || ArtifactManager.getInstance((Project)BuildArtifactsBeforeRunTaskProvider.this.myProject).findArtifact(artifactName) != null) continue;
                            task.removeArtifact(pointer);
                        }
                    }
                }
            }
        });
    }

    public Key<BuildArtifactsBeforeRunTask> getId() {
        return ID;
    }

    public Icon getIcon() {
        return AllIcons.Nodes.Artifact;
    }

    public String getName() {
        return CompilerBundle.message((String)"build.artifacts.before.run.description.empty", (Object[])new Object[0]);
    }

    public Icon getTaskIcon(BuildArtifactsBeforeRunTask task) {
        List<ArtifactPointer> pointers = task.getArtifactPointers();
        if (pointers == null || pointers.isEmpty()) {
            return this.getIcon();
        }
        Artifact artifact = pointers.get(0).getArtifact();
        if (artifact == null) {
            return this.getIcon();
        }
        return artifact.getArtifactType().getIcon();
    }

    public String getDescription(BuildArtifactsBeforeRunTask task) {
        List<ArtifactPointer> pointers = task.getArtifactPointers();
        if (pointers.isEmpty()) {
            return CompilerBundle.message((String)"build.artifacts.before.run.description.empty", (Object[])new Object[0]);
        }
        if (pointers.size() == 1) {
            return CompilerBundle.message((String)"build.artifacts.before.run.description.single", (Object[])new Object[]{pointers.get(0).getArtifactName()});
        }
        return CompilerBundle.message((String)"build.artifacts.before.run.description.multiple", (Object[])new Object[]{pointers.size()});
    }

    public boolean isConfigurable() {
        return true;
    }

    public BuildArtifactsBeforeRunTask createTask(RunConfiguration runConfiguration) {
        if (this.myProject.isDefault()) {
            return null;
        }
        return new BuildArtifactsBeforeRunTask(this.myProject);
    }

    public boolean configureTask(RunConfiguration runConfiguration, BuildArtifactsBeforeRunTask task) {
        Artifact[] artifacts = ArtifactManager.getInstance((Project)this.myProject).getArtifacts();
        THashSet pointers = new THashSet();
        for (Artifact artifact : artifacts) {
            pointers.add(ArtifactPointerManager.getInstance((Project)this.myProject).createPointer(artifact));
        }
        pointers.addAll(task.getArtifactPointers());
        ArtifactChooser chooser = new ArtifactChooser(new ArrayList<ArtifactPointer>((Collection<ArtifactPointer>)pointers));
        chooser.markElements(task.getArtifactPointers());
        chooser.setPreferredSize((Dimension)JBUI.size((int)400, (int)300));
        DialogBuilder builder = new DialogBuilder(this.myProject);
        builder.setTitle(CompilerBundle.message((String)"build.artifacts.before.run.selector.title", (Object[])new Object[0]));
        builder.setDimensionServiceKey("#BuildArtifactsBeforeRunChooser");
        builder.addOkAction();
        builder.addCancelAction();
        builder.setCenterPanel((JComponent)chooser);
        builder.setPreferredFocusComponent((JComponent)chooser);
        if (builder.show() == 0) {
            task.setArtifactPointers(chooser.getMarkedElements());
            return true;
        }
        return false;
    }

    public boolean canExecuteTask(RunConfiguration configuration, BuildArtifactsBeforeRunTask task) {
        for (ArtifactPointer pointer : task.getArtifactPointers()) {
            if (pointer.getArtifact() == null) continue;
            return true;
        }
        return false;
    }

    public boolean executeTask(DataContext context, RunConfiguration configuration, final ExecutionEnvironment env, final BuildArtifactsBeforeRunTask task) {
        final Ref result = Ref.create((Object)false);
        final Semaphore finished = new Semaphore();
        final ArrayList artifacts = new ArrayList();
        new ReadAction(){

            protected void run(@NotNull Result result) {
                for (ArtifactPointer pointer : task.getArtifactPointers()) {
                    ContainerUtil.addIfNotNull((Object)pointer.getArtifact(), (Collection)artifacts);
                }
            }
        }.execute();
        final CompileStatusNotification callback = new CompileStatusNotification(){

            public void finished(boolean aborted, int errors, int warnings, CompileContext compileContext) {
                result.set((Object)(!aborted && errors == 0 ? 1 : 0));
                finished.up();
            }
        };
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                if (BuildArtifactsBeforeRunTaskProvider.this.myProject.isDisposed()) {
                    return;
                }
                CompilerManager manager = CompilerManager.getInstance((Project)BuildArtifactsBeforeRunTaskProvider.this.myProject);
                CompileScope scope = ArtifactCompileScope.createArtifactsScope(BuildArtifactsBeforeRunTaskProvider.this.myProject, artifacts);
                ExecutionManagerImpl.EXECUTION_SESSION_ID_KEY.set((UserDataHolder)scope, ExecutionManagerImpl.EXECUTION_SESSION_ID_KEY.get((UserDataHolder)env));
                finished.down();
                manager.make(scope, CompilerFilter.ALL, callback);
            }
        }, ModalityState.NON_MODAL);
        finished.waitFor();
        return (Boolean)result.get();
    }

    public static void setBuildArtifactBeforeRunOption(@NotNull JComponent runConfigurationEditorComponent, Project project2, @NotNull Artifact artifact, boolean enable) {
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)runConfigurationEditorComponent);
        ConfigurationSettingsEditorWrapper editor = (ConfigurationSettingsEditorWrapper)ConfigurationSettingsEditorWrapper.CONFIGURATION_EDITOR_KEY.getData(dataContext);
        if (editor != null) {
            List<BeforeRunTask> tasks = editor.getStepsBeforeLaunch();
            ArrayList<BuildArtifactsBeforeRunTask> myTasks = new ArrayList<BuildArtifactsBeforeRunTask>();
            for (BeforeRunTask beforeRunTask : tasks) {
                if (!(beforeRunTask instanceof BuildArtifactsBeforeRunTask)) continue;
                myTasks.add((BuildArtifactsBeforeRunTask)beforeRunTask);
            }
            if (enable && myTasks.isEmpty()) {
                BuildArtifactsBeforeRunTask task = new BuildArtifactsBeforeRunTask(project2);
                task.addArtifact(artifact);
                task.setEnabled(true);
                editor.addBeforeLaunchStep(task);
            } else {
                for (BuildArtifactsBeforeRunTask buildArtifactsBeforeRunTask : myTasks) {
                    if (enable) {
                        buildArtifactsBeforeRunTask.addArtifact(artifact);
                        buildArtifactsBeforeRunTask.setEnabled(true);
                        continue;
                    }
                    buildArtifactsBeforeRunTask.removeArtifact(artifact);
                    if (!buildArtifactsBeforeRunTask.getArtifactPointers().isEmpty()) continue;
                    buildArtifactsBeforeRunTask.setEnabled(false);
                }
            }
        }
    }

    public static void setBuildArtifactBeforeRun(@NotNull Project project2, @NotNull RunConfiguration configuration, @NotNull Artifact artifact) {
        RunManagerEx runManager = RunManagerEx.getInstanceEx(project2);
        List<BuildArtifactsBeforeRunTask> buildArtifactsTasks = runManager.getBeforeRunTasks(configuration, ID);
        if (buildArtifactsTasks.isEmpty()) {
            BuildArtifactsBeforeRunTask task = new BuildArtifactsBeforeRunTask(project2);
            buildArtifactsTasks.add(task);
            List<BeforeRunTask> tasks = runManager.getBeforeRunTasks(configuration);
            tasks.add(task);
            runManager.setBeforeRunTasks(configuration, tasks, false);
        }
        for (BuildArtifactsBeforeRunTask task : buildArtifactsTasks) {
            task.setEnabled(true);
            task.addArtifact(artifact);
        }
    }
}

