/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.CompositePackagingElementType;
import com.intellij.packaging.impl.elements.DirectoryPackagingElement;
import com.intellij.packaging.impl.elements.FilePathValidator;
import com.intellij.packaging.impl.elements.PackagingElementFactoryImpl;
import com.intellij.packaging.impl.ui.properties.DirectoryElementPropertiesPanel;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingElementPropertiesPanel;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.incremental.artifacts.impl.JpsArtifactUtil;

class DirectoryElementType
extends CompositePackagingElementType<DirectoryPackagingElement> {
    DirectoryElementType() {
        super("directory", CompilerBundle.message((String)"element.type.name.directory", (Object[])new Object[0]));
    }

    public Icon getCreateElementIcon() {
        return AllIcons.Actions.NewFolder;
    }

    @NotNull
    public DirectoryPackagingElement createEmpty(@NotNull Project project2) {
        return new DirectoryPackagingElement();
    }

    public PackagingElementPropertiesPanel createElementPropertiesPanel(@NotNull DirectoryPackagingElement element, @NotNull ArtifactEditorContext context) {
        if (JpsArtifactUtil.isArchiveName((String)element.getDirectoryName())) {
            return new DirectoryElementPropertiesPanel(element, context);
        }
        return null;
    }

    public CompositePackagingElement<?> createComposite(CompositePackagingElement<?> parent, String baseName, @NotNull ArtifactEditorContext context) {
        String initialValue = PackagingElementFactoryImpl.suggestFileName(parent, baseName != null ? baseName : "folder", "");
        String path = Messages.showInputDialog((Project)context.getProject(), (String)"Enter directory name: ", (String)"New Directory", null, (String)initialValue, (InputValidator)new FilePathValidator());
        if (path == null) {
            return null;
        }
        return PackagingElementFactoryImpl.createDirectoryOrArchiveWithParents(path, false);
    }
}

