/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.compiler.ant.Generator;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.AntCopyInstructionCreator;
import com.intellij.packaging.elements.ArtifactAntGenerationContext;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.elements.FileOrDirectoryCopyPackagingElement;
import com.intellij.packaging.impl.elements.PackagingElementFactoryImpl;
import com.intellij.packaging.impl.ui.DirectoryCopyPresentation;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingElementPresentation;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DirectoryCopyPackagingElement
extends FileOrDirectoryCopyPackagingElement<DirectoryCopyPackagingElement> {
    public DirectoryCopyPackagingElement() {
        super(PackagingElementFactoryImpl.DIRECTORY_COPY_ELEMENT_TYPE);
    }

    public DirectoryCopyPackagingElement(String directoryPath) {
        this();
        this.myFilePath = directoryPath;
    }

    public PackagingElementPresentation createPresentation(@NotNull ArtifactEditorContext context) {
        return new DirectoryCopyPresentation(this.myFilePath);
    }

    public List<? extends Generator> computeAntInstructions(@NotNull PackagingElementResolvingContext resolvingContext, @NotNull AntCopyInstructionCreator creator, @NotNull ArtifactAntGenerationContext generationContext, @NotNull ArtifactType artifactType) {
        String path = generationContext.getSubstitutedPath(this.myFilePath);
        return Collections.singletonList(creator.createDirectoryContentCopyInstruction(path));
    }

    public DirectoryCopyPackagingElement getState() {
        return this;
    }

    public void loadState(DirectoryCopyPackagingElement state) {
        this.myFilePath = state.getFilePath();
    }

    public String toString() {
        return "dir:" + this.myFilePath;
    }
}

